/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.othres;

import java.util.Comparator;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import org.eclipse.jface.viewers.ViewerSorter;

public class DomainTransitionTreeAsciiOrderSorter
extends ViewerSorter
implements Comparator<Object> {
    private boolean domainComesFirst = false;
    private boolean compareFullpath = false;
    private boolean includeDeirective = false;

    public DomainTransitionTreeAsciiOrderSorter() {
    }

    public DomainTransitionTreeAsciiOrderSorter(boolean domainComesFirst, boolean compareFullpath, boolean includeDeirective) {
        this.domainComesFirst = domainComesFirst;
        this.compareFullpath = compareFullpath;
        this.includeDeirective = includeDeirective;
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        if (this.domainComesFirst && obj1 instanceof Domain && !(obj2 instanceof Domain)) {
            return 1;
        }
        String str1 = this.toString(obj1);
        String str2 = this.toString(obj2);
        try {
            return str1.compareTo(str2);
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    private String toString(Object obj) {
        String text;
        if (obj instanceof Domain) {
            Domain domain = (Domain)obj;
            text = this.compareFullpath ? domain.getText() : domain.getProcessName();
        } else if (obj instanceof AccessPermission) {
            AccessPermission permission = (AccessPermission)obj;
            text = this.includeDeirective ? permission.getText() : permission.getContents();
        } else {
            text = obj.toString();
        }
        return text;
    }
}

