/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.base.ssh.ui;

import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.base.ssh.Activator;
import jp.sourceforge.tomoyo.base.ssh.ui.Messages;
import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.server.ConnectionManager;
import jp.sourceforge.tomoyo.core.server.ConnectionStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class UIUtilities {
    private IProject project = null;
    private static FormToolkit toolkit = null;
    private Image connecedImage = Activator.getImage("connected.gif");
    private Image notConnecedImage = new Image((Device)Display.getCurrent(), this.connecedImage, 2);

    public UIUtilities(IProject project) {
        this.project = project;
    }

    private FormToolkit getToolkit() {
        if (toolkit == null) {
            toolkit = new FormToolkit(Activator.getStandardDisplay());
        }
        return toolkit;
    }

    private ProjectProperty getProjectProperty() {
        return ProjectPropertyManager.getInstance().getProperty(this.project);
    }

    public void createSettingComposite(Composite parent) {
        parent.setLayout((Layout)new GridLayout(4, false));
        GridData data = new GridData(4, 4, true, true, 1, 1);
        parent.setLayoutData((Object)data);
        this.createConnectionOnOffComposites(parent);
        this.createAuthenticationMethodComposites(parent);
        this.createLoginUserComposites(parent);
        if (this.getProjectProperty().usePublicKeyAuthentication()) {
            this.createPrivateKeyComposites(parent);
        } else {
            this.createRememberPasswordComposites(parent);
        }
        if (this.getProjectProperty().useKnownHostsCheck()) {
            this.createKnownHostsComposites(parent);
        } else {
            this.createUseKnownHostsCheckComposites(parent);
        }
    }

    private void createConnectionOnOffComposites(Composite parent) {
        FormToolkit toolkit = this.getToolkit();
        Label title = toolkit.createLabel(parent, String.valueOf(Messages.ProjectOverviewPage_Connect2ServerTitle) + " :");
        title.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        title.setLayoutData((Object)new GridData(1, 2, true, false, 1, 1));
        ImageHyperlink connectLink = new ImageHyperlink(parent, 0);
        connectLink.setBackground(parent.getBackground());
        connectLink.setText(Messages.ProjectOverviewPage_Connect2ServerLinkText);
        connectLink.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        connectLink.setEnabled(true);
        connectLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ConnectionManager.getInstance().connect(UIUtilities.this.project);
            }
        });
        if (this.getProjectProperty().usePublicKeyAuthentication()) {
            connectLink.setForeground(JFaceColors.getActiveHyperlinkText((Display)Activator.getStandardDisplay()));
        } else {
            connectLink.setForeground(Display.getCurrent().getSystemColor(15));
        }
        ImageHyperlink disConnectLink = new ImageHyperlink(parent, 0);
        disConnectLink.setBackground(parent.getBackground());
        disConnectLink.setText(Messages.ProjectOverviewPage_DisconnectFromServerLinkText);
        disConnectLink.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        disConnectLink.setEnabled(false);
        disConnectLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                boolean b = MessageDialog.openQuestion((Shell)Activator.getStandardDisplay().getActiveShell(), (String)Messages.ProjectOverviewPage_DisconnectFromServerQuestionDialogTitle, (String)Messages.ProjectOverviewPage_DisconnectFromServerQuestionDialogDescription);
                if (b) {
                    ConnectionManager.getInstance().disConnect(UIUtilities.this.project);
                }
            }
        });
        if (this.getProjectProperty().usePublicKeyAuthentication()) {
            disConnectLink.setForeground(Display.getCurrent().getSystemColor(15));
        } else {
            disConnectLink.setForeground(JFaceColors.getActiveHyperlinkText((Display)Activator.getStandardDisplay()));
        }
        ImageHyperlink imageLink = new ImageHyperlink(parent, 0);
        imageLink.setBackground(parent.getBackground());
        imageLink.setEnabled(false);
        imageLink.setImage(this.notConnecedImage);
        imageLink.redraw();
        ConnectionManager.getInstance().addObserver(new Observer(){

            @Override
            public void update(Observable arg0, Object arg1) {
                ConnectionStatus status = (ConnectionStatus)arg1;
                if (status.getProject().equals((Object)UIUtilities.this.project)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (connectLink.isDisposed()) {
                                return;
                            }
                            if (ConnectionManager.getInstance().isConnected(UIUtilities.this.project)) {
                                connectLink.setEnabled(false);
                                disConnectLink.setEnabled(true);
                                connectLink.setForeground(JFaceColors.getActiveHyperlinkText((Display)Display.getCurrent()));
                                disConnectLink.setForeground(Display.getCurrent().getSystemColor(15));
                                imageLink.setImage(UIUtilities.this.connecedImage);
                            } else {
                                connectLink.setEnabled(true);
                                disConnectLink.setEnabled(false);
                                connectLink.setForeground(Display.getCurrent().getSystemColor(15));
                                disConnectLink.setForeground(JFaceColors.getActiveHyperlinkText((Display)Activator.getStandardDisplay()));
                                imageLink.setImage(UIUtilities.this.notConnecedImage);
                            }
                            connectLink.redraw();
                            disConnectLink.redraw();
                            connectLink.redraw();
                            disConnectLink.redraw();
                            imageLink.redraw();
                        }
                    });
                }
            }
        });
    }

    private void createLoginUserComposites(Composite parent) {
        FormToolkit toolkit = this.getToolkit();
        Label label = toolkit.createLabel(parent, String.valueOf(Messages.UIUtilities_LoginUserLabelTitle) + " :");
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        String property = this.getProjectProperty().getProperty(PersistentPropertyManager.PROPERTY_LOGIN_USERNAME);
        Text text = toolkit.createText(parent, property == null ? "" : property, 0);
        text.setEditable(false);
        text.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Button button = toolkit.createButton(parent, "", 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        button.setImage(Activator.getImage("edit.gif"));
        button.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        button.setEnabled(false);
    }

    private void createAuthenticationMethodComposites(Composite parent) {
        FormToolkit toolkit = this.getToolkit();
        Label title = toolkit.createLabel(parent, String.valueOf(Messages.UIUtilities_AuthenticationMethodLabelTitle) + " :");
        title.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        title.setLayoutData((Object)new GridData(1, 2, true, false, 1, 1));
        ImageHyperlink link1 = new ImageHyperlink(parent, 0);
        link1.setBackground(parent.getBackground());
        link1.setText(Messages.UIUtilities_PublicKeyLinkCaption);
        link1.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        link1.setEnabled(false);
        if (this.getProjectProperty().usePublicKeyAuthentication()) {
            link1.setForeground(JFaceColors.getActiveHyperlinkText((Display)Activator.getStandardDisplay()));
        } else {
            link1.setForeground(Display.getCurrent().getSystemColor(15));
        }
        ImageHyperlink link2 = new ImageHyperlink(parent, 0);
        link2.setBackground(parent.getBackground());
        link2.setText(Messages.UIUtilities_PasswordLinkCaption);
        link2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        link2.setEnabled(false);
        if (this.getProjectProperty().usePublicKeyAuthentication()) {
            link2.setForeground(Display.getCurrent().getSystemColor(15));
        } else {
            link2.setForeground(JFaceColors.getActiveHyperlinkText((Display)Activator.getStandardDisplay()));
        }
        toolkit.createLabel(parent, "");
    }

    private void createRememberPasswordComposites(Composite parent) {
        FormToolkit toolkit = this.getToolkit();
        Label title = toolkit.createLabel(parent, String.valueOf(Messages.UIUtilities_RememberPasswordLabelTitle) + " :");
        title.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        title.setLayoutData((Object)new GridData(1, 2, true, false, 1, 1));
        ImageHyperlink link1 = new ImageHyperlink(parent, 0);
        link1.setBackground(parent.getBackground());
        link1.setText(Messages.UIUtilities_Yes);
        link1.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        link1.setEnabled(false);
        String password = this.getProjectProperty().getProperty(PersistentPropertyManager.PROPERTY_LOGIN_PASSWORD);
        if (password != null) {
            link1.setForeground(JFaceColors.getActiveHyperlinkText((Display)Activator.getStandardDisplay()));
        } else {
            link1.setForeground(Display.getCurrent().getSystemColor(15));
        }
        ImageHyperlink link2 = new ImageHyperlink(parent, 0);
        link2.setBackground(parent.getBackground());
        link2.setText(Messages.UIUtilities_No);
        link2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        link2.setEnabled(false);
        if (password != null) {
            link2.setForeground(Display.getCurrent().getSystemColor(15));
        } else {
            link2.setForeground(JFaceColors.getActiveHyperlinkText((Display)Activator.getStandardDisplay()));
        }
        toolkit.createLabel(parent, "");
    }

    private void createKnownHostsComposites(Composite parent) {
        FormToolkit toolkit = this.getToolkit();
        Label label = toolkit.createLabel(parent, String.valueOf(Messages.UIUtilities_KnownHostsLabelTitle) + " :");
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        String property = this.getProjectProperty().getProperty(PersistentPropertyManager.PROPERTY_KNOWN_HOSTS);
        Text text = toolkit.createText(parent, property == null ? "" : property, 0);
        text.setEditable(false);
        text.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Button button = toolkit.createButton(parent, "", 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        button.setImage(Activator.getImage("edit.gif"));
        button.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        button.setEnabled(false);
    }

    private void createUseKnownHostsCheckComposites(Composite parent) {
        FormToolkit toolkit = this.getToolkit();
        Label title = toolkit.createLabel(parent, String.valueOf(Messages.UIUtilities_UseKnownHostsLabelTitle) + " :");
        title.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        title.setLayoutData((Object)new GridData(1, 2, true, false, 1, 1));
        ImageHyperlink link1 = new ImageHyperlink(parent, 0);
        link1.setBackground(parent.getBackground());
        link1.setText(Messages.UIUtilities_Yes);
        link1.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        link1.setEnabled(false);
        if (this.getProjectProperty().useKnownHostsCheck()) {
            link1.setForeground(JFaceColors.getActiveHyperlinkText((Display)Activator.getStandardDisplay()));
        } else {
            link1.setForeground(Display.getCurrent().getSystemColor(15));
        }
        ImageHyperlink link2 = new ImageHyperlink(parent, 0);
        link2.setBackground(parent.getBackground());
        link2.setText(Messages.UIUtilities_No);
        link2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        link2.setEnabled(false);
        if (this.getProjectProperty().useKnownHostsCheck()) {
            link2.setForeground(Display.getCurrent().getSystemColor(15));
        } else {
            link2.setForeground(JFaceColors.getActiveHyperlinkText((Display)Activator.getStandardDisplay()));
        }
        toolkit.createLabel(parent, "");
    }

    private void createPrivateKeyComposites(Composite parent) {
        FormToolkit toolkit = this.getToolkit();
        Label label = toolkit.createLabel(parent, String.valueOf(Messages.UIUtilities_PrivateKeyFile) + " :");
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        String property = this.getProjectProperty().getProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY);
        Text text = toolkit.createText(parent, property == null ? "" : property, 0);
        text.setEditable(false);
        text.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Button button = toolkit.createButton(parent, "", 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        button.setImage(Activator.getImage("edit.gif"));
        button.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        button.setEnabled(false);
    }
}

