/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import java.io.File;
import jp.sourceforge.tomoyo.base.ssh.Activator;
import jp.sourceforge.tomoyo.base.ssh.connection.SSHConnectionAdapter;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.AbstractWizardPage;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.Messages;
import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.server.ConnectionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConnectionSettingPage
extends AbstractWizardPage {
    private static final String DIALOG_SETTINGS_KEY_HOSTLIST = "host.list";
    private static final String PAGE_DESCRPTION = Messages.ConnectionSettingPage_PageDescription;
    private Combo hostCombo = null;
    private Text portText = null;
    private Combo userCombo = null;
    private Text pswdText = null;
    private Text pkeyText = null;
    private Button useKnownHostsCheck;
    private Text knownHostsText;
    private Button knownHostsButton;
    private Button pkeyButton;
    private Button connectButton = null;
    private CTabFolder tabFolder;
    private Button rememberPassword;

    public ConnectionSettingPage() {
        super(Messages.ConnectionSettingPage_PageName);
        this.setTitle(Messages.ConnectionSettingPage_PageTitle);
        this.setDescription(PAGE_DESCRPTION);
        this.setPageComplete(false);
    }

    @Override
    protected String getHelpResourceName() {
        return "connection_settings";
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.createHostGroup(composite);
        this.tabFolder = new CTabFolder(composite, 2048);
        this.tabFolder.setSimple(false);
        this.tabFolder.setTabPosition(128);
        this.tabFolder.setSelectionForeground(Display.getCurrent().getSystemColor(30));
        this.tabFolder.setSelectionBackground(new Color[]{Activator.getStandardDisplay().getSystemColor(31), Activator.getStandardDisplay().getSystemColor(32)}, new int[]{100}, true);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ConnectionSettingPage.this.tabFolderSelectionChanged();
            }
        });
        this.createPublicKeyAuthFolder(this.tabFolder);
        this.createPasswordAuthFolder(this.tabFolder);
        if (this.tabFolder.getItemCount() > 0) {
            this.tabFolder.setSelection(0);
        }
        this.createConnectionGroup(composite);
        this.hostCombo.setFocus();
        this.restoreHistory();
        this.setupDefault();
        this.setControl((Control)composite);
    }

    private void tabFolderSelectionChanged() {
        this.inputChanged();
    }

    private void setupDefault() {
        if (this.hostCombo.getItemCount() > 0) {
            this.hostCombo.select(0);
        }
        this.userCombo.setText("root");
    }

    @Override
    public IWizardPage getPreviousPage() {
        if (ConnectionManager.getInstance().connect(this.getProject())) {
            return null;
        }
        return super.getPreviousPage();
    }

    private void restoreHistory() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings(((Object)((Object)this)).getClass().getName());
        if (settings == null) {
            return;
        }
        String[] hosts = settings.getArray(DIALOG_SETTINGS_KEY_HOSTLIST);
        if (hosts != null) {
            this.hostCombo.setItems(hosts);
        }
    }

    private void saveHistory() {
        String[] hosts;
        IDialogSettings settings = Activator.getDefault().getDialogSettings(((Object)((Object)this)).getClass().getName());
        String newHost = this.hostCombo.getText();
        if (settings.getArray(DIALOG_SETTINGS_KEY_HOSTLIST) == null) {
            hosts = new String[]{};
        } else {
            hosts = settings.getArray(DIALOG_SETTINGS_KEY_HOSTLIST);
            if (this.includesHosts(hosts, newHost)) {
                return;
            }
        }
        String[] newHosts = new String[hosts.length + 1];
        newHosts[0] = newHost;
        System.arraycopy(this.hostCombo.getItems(), 0, newHosts, 1, this.hostCombo.getItemCount());
        settings.put(DIALOG_SETTINGS_KEY_HOSTLIST, newHosts);
    }

    private boolean includesHosts(String[] hosts, String newHost) {
        if (hosts == null) {
            return false;
        }
        int cnt = 0;
        while (cnt < hosts.length) {
            if (hosts[cnt].equals(newHost)) {
                return true;
            }
            ++cnt;
        }
        return false;
    }

    private void createHostGroup(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData(4, 4, true, false, 1, 1);
        container.setLayoutData((Object)data);
        Label ipLabel = new Label(container, 0);
        ipLabel.setText(Messages.ConnectionSettingPage_HostLabelCaption);
        GridData griddata = new GridData();
        griddata.widthHint = 150;
        this.hostCombo = new Combo(container, 2052);
        this.hostCombo.setLayoutData((Object)new GridData(768));
        this.hostCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionSettingPage.this.inputChanged();
            }
        });
        this.hostCombo.setLayoutData((Object)griddata);
        new Label(container, 0);
        Label portLabel = new Label(container, 0);
        portLabel.setText(Messages.ConnectionSettingPage_PortLabelCaption);
        GridData portGrid = new GridData();
        portGrid.widthHint = 50;
        this.portText = new Text(container, 2048);
        this.portText.setText("22");
        this.portText.setTextLimit(5);
        this.portText.setLayoutData((Object)portGrid);
        this.portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionSettingPage.this.inputChanged();
            }
        });
        new Label(container, 0);
        this.createKnownHostGroup(container);
    }

    private void createPublicKeyAuthFolder(CTabFolder tabFolder) {
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(Messages.ConnectionSettingPage_PublicKeyAuthTabTitle);
        tabItem.setControl((Control)this.createPublicKeyControl((Composite)tabFolder));
    }

    private void createPasswordAuthFolder(CTabFolder tabFolder) {
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(Messages.ConnectionSettingPage_PasswordAuthTabTitle);
        tabItem.setControl((Control)this.createPasswordAuthControl((Composite)tabFolder));
    }

    private Composite createPublicKeyControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData(4, 4, true, false, 1, 1);
        container.setLayoutData((Object)data);
        Label pathLabel = new Label(container, 0);
        pathLabel.setText(Messages.ConnectionSettingPage_PrivateKeyLabelCaption);
        this.pkeyText = new Text(container, 2048);
        this.pkeyText.setLayoutData((Object)new GridData(768));
        this.pkeyText.setText(String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".ssh" + System.getProperty("file.separator") + "id_rsa");
        this.pkeyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionSettingPage.this.inputChanged();
            }
        });
        this.pkeyButton = new Button(container, 8);
        this.pkeyButton.setText(Messages.ConnectionSettingPage_PrivateKeyFileSelectionButtonTitle);
        this.pkeyButton.setEnabled(true);
        this.pkeyButton.setLayoutData((Object)this.createButtonGridData());
        this.pkeyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                dialog.setText(ConnectionSettingPage.this.pkeyText.getText());
                String file = dialog.open();
                if (file != null) {
                    ConnectionSettingPage.this.pkeyText.setText(file);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return container;
    }

    private Composite createPasswordAuthControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(4, 4, true, false, 1, 1);
        container.setLayoutData((Object)data);
        Label userLabel = new Label(container, 0);
        userLabel.setText(Messages.ConnectionSettingPage_UsernameLabelCaption);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        this.userCombo = new Combo(container, 4);
        this.userCombo.setLayoutData((Object)gridData);
        this.userCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionSettingPage.this.inputChanged();
            }
        });
        Label pswdLabel = new Label(container, 0);
        pswdLabel.setText(Messages.ConnectionSettingPage_PasswordLabelCaption);
        gridData = new GridData();
        gridData.widthHint = 200;
        this.pswdText = new Text(container, 0x400804);
        this.pswdText.setLayoutData((Object)gridData);
        this.pswdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionSettingPage.this.inputChanged();
            }
        });
        gridData = new GridData();
        this.rememberPassword = new Button(container, 32);
        this.rememberPassword.setText(Messages.ConnectionSettingPage_RememberPassword);
        this.rememberPassword.setSelection(false);
        this.rememberPassword.setLayoutData((Object)gridData);
        this.rememberPassword.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionSettingPage.this.inputChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return container;
    }

    private void createKnownHostGroup(Composite parent) {
        GridData gridData = new GridData();
        this.useKnownHostsCheck = new Button(parent, 32);
        this.useKnownHostsCheck.setText(Messages.ConnectionSettingPage_UseKnownHostFileCheckButtonTitle);
        this.useKnownHostsCheck.setSelection(true);
        this.useKnownHostsCheck.setLayoutData((Object)gridData);
        this.useKnownHostsCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionSettingPage.this.inputChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.knownHostsText = new Text(parent, 2048);
        this.knownHostsText.setLayoutData((Object)new GridData(768));
        this.knownHostsText.setText(String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".ssh" + System.getProperty("file.separator") + "known_hosts");
        this.knownHostsText.setEnabled(false);
        this.knownHostsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionSettingPage.this.inputChanged();
            }
        });
        this.knownHostsButton = new Button(parent, 8);
        this.knownHostsButton.setText(Messages.ConnectionSettingPage_KnownHostFileSelectionButtonTitle);
        this.knownHostsButton.setEnabled(false);
        GridData buttonGrid = this.createButtonGridData();
        this.knownHostsButton.setLayoutData((Object)buttonGrid);
        this.knownHostsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                dialog.setText(ConnectionSettingPage.this.knownHostsText.getText());
                String file = dialog.open();
                if (file != null) {
                    ConnectionSettingPage.this.knownHostsText.setText(file);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private GridData createButtonGridData() {
        GridData gridData = new GridData(3);
        gridData.widthHint = 50;
        return gridData;
    }

    private void createConnectionGroup(Composite container) {
        Composite conButtonComposite = new Composite(container, 0);
        conButtonComposite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        conButtonComposite.setLayoutData((Object)gridData);
        Label blank = new Label(conButtonComposite, 0);
        GridData lineData = new GridData(768);
        lineData.horizontalSpan = 1;
        blank.setLayoutData((Object)lineData);
        this.connectButton = new Button(conButtonComposite, 8);
        this.connectButton.setText(Messages.ConnectionSettingPage_ConnectionTestButtonTitle);
        this.connectButton.setEnabled(false);
        this.connectButton.setLayoutData((Object)new GridData(128));
        this.connectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionSettingPage.this.handleConnectionButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void handleConnectionButtonPressed() {
        try {
            this.setErrorMessage(null);
            IProject project = this.getProject();
            this.storeProperties(project);
            if (ConnectionManager.getInstance().connect(project)) {
                this.setMessage(Messages.ConnectionSettingPage_ConnectionEstablishedMessage, 1);
                this.disableControls();
                this.getWizard().getContainer().updateButtons();
                this.saveHistory();
                this.setPageComplete(true);
            } else {
                this.setErrorMessage(ConnectionManager.getInstance().getErrorMessage(project));
            }
        }
        catch (CoreException e1) {
            Activator.logException(e1);
        }
    }

    private void disableControls() {
        this.hostCombo.setEnabled(false);
        this.userCombo.setEnabled(false);
        this.portText.setEnabled(false);
        this.knownHostsText.setEnabled(false);
        this.knownHostsButton.setEnabled(false);
        this.useKnownHostsCheck.setEnabled(false);
        this.pkeyText.setEnabled(false);
        this.pkeyButton.setEnabled(false);
        this.pswdText.setEnabled(false);
        this.connectButton.setEnabled(false);
    }

    private boolean usePublicKeyAuth() {
        if (this.tabFolder == null) {
            return true;
        }
        return this.tabFolder.getSelectionIndex() == 0;
    }

    private void storeProperties(IProject project) throws CoreException {
        ProjectProperty properties = new ProjectProperty(project);
        properties.setProperty(PersistentPropertyManager.PROPERTY_CONNECTION_ADAPTER, SSHConnectionAdapter.ADAPTER_ID);
        properties.setProperty(PersistentPropertyManager.PROPERTY_SERVER_HOSTNAME, this.hostCombo.getText().trim());
        properties.setProperty(PersistentPropertyManager.PROPERTY_SERVER_PORT, this.portText.getText().trim());
        properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_USERNAME, this.userCombo.getText().trim());
        if (this.useKnownHostsCheck.getSelection()) {
            properties.setProperty(PersistentPropertyManager.PROPERTY_KNOWN_HOSTS, this.knownHostsText.getText().trim());
        } else {
            properties.setProperty(PersistentPropertyManager.PROPERTY_KNOWN_HOSTS, null);
        }
        if (this.usePublicKeyAuth()) {
            properties.setProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY, this.pkeyText.getText().trim());
            properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_PASSWORD, null);
        } else {
            properties.setProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY, null);
            if (this.rememberPassword.getSelection()) {
                properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_PASSWORD, this.pswdText.getText().trim());
            } else {
                properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_PASSWORD, null);
            }
        }
        properties.setProperty(PersistentPropertyManager.PROPERTY_MANAGER_CONFIRM_CONNECT, "true");
    }

    private void inputChanged() {
        this.knownHostsText.setEnabled(this.useKnownHostsCheck.getSelection());
        this.knownHostsButton.setEnabled(this.useKnownHostsCheck.getSelection());
        this.pswdText.setEnabled(this.rememberPassword.getSelection());
        if (this.hostCombo.getText().trim().length() == 0) {
            this.setInputErrorMessage(Messages.ConnectionSettingPage_ErrorMessageInputHostname);
            return;
        }
        if (this.portText.getText().trim().length() == 0) {
            this.setInputErrorMessage(Messages.ConnectionSettingPage_ErrorMessageInputPortNo);
            return;
        }
        try {
            int port = Integer.parseInt(this.portText.getText().trim());
            if (port < 1 || 65535 < port) {
                this.setInputErrorMessage(Messages.ConnectionSettingPage_ErrorMessagePortNoRange);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setInputErrorMessage(Messages.ConnectionSettingPage_ErrorMessagePortNoMustBeInteger);
            return;
        }
        if (this.usePublicKeyAuth()) {
            if (this.pkeyText.getText().trim().length() == 0) {
                this.setInputErrorMessage(Messages.ConnectionSettingPage_ErrorMessageInputPrivateKeyFile);
                return;
            }
            if (!new File(this.pkeyText.getText().trim()).exists()) {
                this.setInputErrorMessage(Messages.ConnectionSettingPage_ErrorMessageInvalidPrivateKeyFile);
                return;
            }
        } else if (this.userCombo.getText().trim().length() == 0) {
            this.setInputErrorMessage(Messages.ConnectionSettingPage_ErrorMessageInputUsername);
            return;
        }
        if (this.useKnownHostsCheck.getSelection()) {
            if (this.knownHostsText.getText().trim().length() == 0) {
                this.setInputErrorMessage(Messages.ConnectionSettingPage_ErrorMessageInputKnownHotsFile);
                return;
            }
            if (!new File(this.knownHostsText.getText().trim()).exists()) {
                this.setInputErrorMessage(Messages.ConnectionSettingPage_ErrorMessageInvalidKnownHotsFile);
                return;
            }
        }
        this.connectButton.setEnabled(true);
        this.setErrorMessage(null);
        this.setMessage(Messages.ConnectionSettingPage_ConnectionOK, 1);
    }

    private void setInputErrorMessage(String message) {
        this.connectButton.setEnabled(false);
        this.setErrorMessage(message);
    }
}

