/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import java.lang.reflect.InvocationTargetException;
import jp.sourceforge.tomoyo.base.ssh.Activator;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.AbstractWizardPage;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.CreateNewProjectWizard;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.Messages;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DownloadResourcePage
extends AbstractWizardPage {
    private Button downloadButton;
    private Composite composite;
    private Composite container;
    private Label[] statusLabel = null;

    public DownloadResourcePage() {
        super(Messages.DownloadResourcePage_PageTitle);
        this.setTitle(Messages.DownloadResourcePage_PageTitle);
        this.setDescription(Messages.DownloadResourcePage_PageDesription);
        this.setPageComplete(false);
    }

    @Override
    protected String getHelpResourceName() {
        return "download_resource";
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        this.composite.setLayout((Layout)layout);
        this.createConfigComposite(this.composite);
        this.createDownloadGroup(this.composite);
        this.setControl((Control)this.composite);
        this.downloadButton.setFocus();
    }

    @Override
    protected void hookFirstVisit() {
        super.hookFirstVisit();
        ProcResourceSet pr = ProcResourceManager.getInstance().getProcResourceSet(this.getProject());
        String[] resourceNames = pr.listLocalResourceNames(this.getProject());
        this.statusLabel = new Label[resourceNames.length];
        int cnt = 0;
        while (cnt < resourceNames.length) {
            Label name = new Label(this.container, 0);
            name.setText(resourceNames[cnt]);
            name.setLayoutData((Object)new GridData(768));
            this.statusLabel[cnt] = new Label(this.container, 0);
            this.statusLabel[cnt].setAlignment(16384);
            this.statusLabel[cnt].setText(Messages.DownloadResourcePage_StatusLabelNotDownloaded);
            this.statusLabel[cnt].setForeground(Activator.getStandardDisplay().getSystemColor(16));
            this.statusLabel[cnt].setLayoutData((Object)new GridData(768));
            ++cnt;
        }
        this.composite.layout(true);
        this.composite.redraw();
    }

    private void createConfigComposite(Composite composite) {
        GridLayout layout = new GridLayout(2, true);
        this.container = new Composite(composite, 0);
        GridData data = new GridData(768);
        this.container.setLayoutData((Object)data);
        this.container.setLayout((Layout)layout);
    }

    private void createDownloadGroup(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        container.setLayoutData((Object)gridData);
        Label blank = new Label(container, 0);
        GridData lineData = new GridData(768);
        lineData.horizontalSpan = 1;
        blank.setLayoutData((Object)lineData);
        this.downloadButton = new Button(container, 8);
        this.downloadButton.setText(Messages.DownloadResourcePage_DownloadButton);
        this.downloadButton.setLayoutData((Object)new GridData(128));
        this.downloadButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DownloadResourcePage.this.handleIntallButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void handleIntallButtonPressed() {
        if (this.download()) {
            this.downloadButton.setEnabled(false);
            this.setMessage(Messages.DownloadResourcePage_DonwloadOKMessage, 1);
            this.setPageComplete(true);
        } else {
            this.downloadButton.setEnabled(true);
            this.setMessage(Messages.DownloadResourcePage_DownloadNGMessage, 3);
            this.setPageComplete(false);
        }
    }

    private boolean download() {
        CreateNewProjectWizard wizard = (CreateNewProjectWizard)this.getWizard();
        CreateLocalResourceRunnable runnable = new CreateLocalResourceRunnable(wizard.getProject());
        try {
            wizard.getContainer().run(true, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            Activator.logException(e);
            return false;
        }
        catch (InterruptedException e) {
            Activator.logException(e);
            return false;
        }
        return runnable.isOK();
    }

    private void updateLabel(int index, String message) {
        Display.getDefault().asyncExec((Runnable)new UpdateLabelRunnable(index, message));
    }

    @Override
    protected void previousButtonPressed() {
    }

    @Override
    protected void nextButtonPressed() {
    }

    private class UpdateLabelRunnable
    implements Runnable {
        private int index;
        private String message;

        public UpdateLabelRunnable(int index, String message) {
            this.index = index;
            this.message = message;
        }

        @Override
        public void run() {
            DownloadResourcePage.this.statusLabel[this.index].setText(this.message);
            DownloadResourcePage.this.statusLabel[this.index].setForeground(Activator.getStandardDisplay().getSystemColor(9));
            DownloadResourcePage.this.statusLabel[this.index].pack();
            DownloadResourcePage.this.statusLabel[this.index].redraw();
        }
    }

    private class CreateLocalResourceRunnable
    implements IRunnableWithProgress {
        private IProject project;
        private boolean status = false;

        public CreateLocalResourceRunnable(IProject project) {
            this.project = project;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            ProcResourceSet pr = ProcResourceManager.getInstance().getProcResourceSet(this.project);
            LocalResource[] resources = pr.listLocalResource(DownloadResourcePage.this.getProject());
            monitor.beginTask("", resources.length);
            int cnt = 0;
            while (cnt < resources.length) {
                DownloadResourcePage.this.updateLabel(cnt, Messages.DownloadResourcePage_DownloadingMessage);
                LocalResource localResource = resources[cnt];
                localResource.create();
                if (!ProcResourceManager.getInstance().synchronize(this.project, localResource)) {
                    DownloadResourcePage.this.updateLabel(cnt, Messages.DownloadResourcePage_DownloadNGMessage);
                    return;
                }
                DownloadResourcePage.this.updateLabel(cnt, Messages.DownloadResourcePage_StatusLabelDownloaded);
                monitor.worked(1);
                ++cnt;
            }
            this.status = true;
        }

        public boolean isOK() {
            return this.status;
        }
    }
}

