/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.AbstractWizardPage;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.Messages;
import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ServerSettingsPage
extends AbstractWizardPage {
    private Button useDefaultCheck;
    private Text ccsToolDirText = null;
    private Text ccsDataDirText = null;

    public ServerSettingsPage() {
        super(Messages.ServerSettingsPage_PageName);
        this.setTitle(Messages.ServerSettingsPage_PageTitle);
        this.setDescription(Messages.ServerSettingsPage_PageDescription);
        this.setPageComplete(true);
    }

    @Override
    protected String getHelpResourceName() {
        return "server_settings";
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.createConfigComposite(composite);
        this.restoreDefault();
        this.setControl((Control)composite);
    }

    private void restoreDefault() {
        IPreferenceStore store = TomoyoCorePlugin.getDefault().getPreferenceStore();
        this.ccsToolDirText.setText(store.getString("ccs.tool.path"));
        this.ccsDataDirText.setText(store.getString("ccs.data.path"));
    }

    private void createConfigComposite(Composite composite) {
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        GridData data = new GridData(768);
        container.setLayoutData((Object)data);
        this.useDefaultCheck = new Button(container, 32);
        this.useDefaultCheck.setText(Messages.ServerSettingsPage_UseDefaultLocationCheckButttonTitle);
        this.useDefaultCheck.setSelection(true);
        this.useDefaultCheck.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ServerSettingsPage.this.ccsDataDirText.setEnabled(!ServerSettingsPage.this.useDefaultCheck.getSelection());
                ServerSettingsPage.this.ccsToolDirText.setEnabled(!ServerSettingsPage.this.useDefaultCheck.getSelection());
            }
        });
        GridData checkGD = new GridData(1);
        this.useDefaultCheck.setLayoutData((Object)checkGD);
        Group systemConfigGroup = new Group(container, 0);
        systemConfigGroup.setLayout((Layout)new GridLayout(2, false));
        systemConfigGroup.setText(Messages.ServerSettingsPage_SystemGroupText);
        systemConfigGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label((Composite)systemConfigGroup, 0);
        label.setText(Messages.ServerSettingsPage_PolicyDirectoryLabelCaption);
        this.ccsDataDirText = new Text((Composite)systemConfigGroup, 2052);
        this.ccsDataDirText.setLayoutData((Object)new GridData(768));
        this.ccsDataDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerSettingsPage.this.inputChanged();
            }
        });
        this.ccsDataDirText.setEnabled(false);
        label = new Label((Composite)systemConfigGroup, 0);
        label.setText(Messages.ServerSettingsPage_ToolDirectoryLabelCaption);
        this.ccsToolDirText = new Text((Composite)systemConfigGroup, 2052);
        this.ccsToolDirText.setLayoutData((Object)new GridData(768));
        this.ccsToolDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerSettingsPage.this.inputChanged();
            }
        });
        this.ccsToolDirText.setEnabled(false);
    }

    public String getCcsToolDir() {
        if (this.useDefaultCheck.getSelection()) {
            IPreferenceStore store = TomoyoCorePlugin.getDefault().getPreferenceStore();
            return store.getString("ccs.tool.path");
        }
        return this.ccsToolDirText.getText();
    }

    public String getCcsDataDir() {
        if (this.useDefaultCheck.getSelection()) {
            IPreferenceStore store = TomoyoCorePlugin.getDefault().getPreferenceStore();
            return store.getString("ccs.data.path");
        }
        return this.ccsDataDirText.getText();
    }

    private void inputChanged() {
        if (this.checkError(this.ccsToolDirText)) {
            this.setInputErrorMessage(Messages.ServerSettingsPage_ErrorMessageInputToolDirectory);
            return;
        }
        if (this.checkError(this.ccsDataDirText)) {
            this.setInputErrorMessage(Messages.ServerSettingsPage_ErrorMessageInputDataDirectory);
            return;
        }
        this.setInputErrorMessage(null);
        this.setMessage(Messages.ServerSettingsPage_PageDescription, 1);
    }

    private boolean checkError(Text text) {
        if (text.getText().trim().length() == 0) {
            return true;
        }
        return !text.getText().trim().startsWith("/");
    }

    private void setInputErrorMessage(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    @Override
    protected void previousButtonPressed() {
    }

    @Override
    protected void nextButtonPressed() {
        this.storeProperties();
    }

    private void storeProperties() {
        ProjectProperty properties = new ProjectProperty(this.getProject());
        properties.setProperty(PersistentPropertyManager.PROPERTY_CCS_DATA_DIRECTORY, this.getCcsDataDir());
        properties.setProperty(PersistentPropertyManager.PROPERTY_CCS_TOOL_DIRECTORY, this.getCcsToolDir());
    }
}

