/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.base.ssh.connection;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.base.ssh.Activator;
import jp.sourceforge.tomoyo.base.ssh.connection.CommandThread;
import jp.sourceforge.tomoyo.base.ssh.connection.SSHConnectionSettings;
import jp.sourceforge.tomoyo.base.ssh.connection.SSHSession;
import jp.sourceforge.tomoyo.base.ssh.ui.UIUtilities;
import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.extensions.IConnectionAdapter;
import jp.sourceforge.tomoyo.core.extensions.IConnectionSettings;
import jp.sourceforge.tomoyo.core.server.AbstractCommand;
import jp.sourceforge.tomoyo.core.server.ConcreteCommand;
import jp.sourceforge.tomoyo.core.server.Connection;
import jp.sourceforge.tomoyo.core.server.ConnectionManager;
import jp.sourceforge.tomoyo.core.server.ICommand;
import jp.sourceforge.tomoyo.core.server.ReadCommand;
import jp.sourceforge.tomoyo.core.server.WriteCommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Composite;

public class SSHConnectionAdapter
implements IConnectionAdapter,
Observer {
    public static final String ADAPTER_ID = SSHConnectionAdapter.class.getName();
    private static Hashtable<IProject, SSHSession> connectionCache = new Hashtable();

    public String getID() {
        return ADAPTER_ID;
    }

    public static IConnectionSettings getConnectionSettings(IProject project) {
        if (project == null || !project.isOpen()) {
            return null;
        }
        SSHConnectionSettings settings = new SSHConnectionSettings();
        settings.project = project;
        try {
            ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(project);
            settings.hostname = properties.getProperty(PersistentPropertyManager.PROPERTY_SERVER_HOSTNAME);
            settings.username = properties.getProperty(PersistentPropertyManager.PROPERTY_LOGIN_USERNAME);
            settings.portno = Integer.parseInt(properties.getProperty(PersistentPropertyManager.PROPERTY_SERVER_PORT));
            settings.isPublicKeyAuthentication = properties.usePublicKeyAuthentication();
            settings.pkeyfile = properties.getPrivateKeyFile();
            settings.password = properties.getProperty(PersistentPropertyManager.PROPERTY_LOGIN_PASSWORD);
            settings.knownHosts = properties.getKnownHostsFile();
            String confirmConnect = properties.getProperty(PersistentPropertyManager.PROPERTY_MANAGER_CONFIRM_CONNECT);
            settings.confirmConnection = confirmConnect == null ? true : confirmConnect.equals("true");
        }
        catch (Exception e) {
            Activator.log(e);
            return null;
        }
        return settings;
    }

    public boolean connect(IProject project) {
        Connection connection = this.getConnection(SSHConnectionAdapter.getConnectionSettings(project));
        if (connection.isConnected()) {
            return true;
        }
        return connection.connect();
    }

    public boolean exec(ConcreteCommand cCommand) {
        return this._exec((ICommand)cCommand);
    }

    public boolean read(ReadCommand rCommand) {
        return this._exec((ICommand)rCommand);
    }

    public boolean write(WriteCommand wCommand) {
        return this._exec((ICommand)wCommand);
    }

    private boolean _exec(ICommand command) {
        if (!this._checkConnection(command)) {
            return false;
        }
        Connection connection = this.getConnection(SSHConnectionAdapter.getConnectionSettings(command.getProject()));
        CommandThread thread = new CommandThread((SSHSession)connection, command);
        Activator.getStandardDisplay().syncExec((Runnable)thread);
        return this._checkStatus(command, thread);
    }

    private boolean _checkConnection(ICommand cCommand) {
        if (this.isConnected(cCommand.getProject())) {
            return true;
        }
        return this.connect(cCommand.getProject());
    }

    private boolean _checkStatus(ICommand command, CommandThread thread) {
        if (thread.isSuccessful()) {
            if (!command.isSuccessful()) {
                AbstractCommand aCommand = (AbstractCommand)command;
                String additionalMessage = null;
                if (command instanceof ConcreteCommand) {
                    ConcreteCommand cCommand = (ConcreteCommand)command;
                    additionalMessage = " command = " + CommandThread.toCommandString(cCommand);
                } else if (command instanceof ReadCommand) {
                    ReadCommand rCommand = (ReadCommand)command;
                    additionalMessage = " source = " + rCommand.getSource();
                } else if (command instanceof WriteCommand) {
                    WriteCommand wCommand = (WriteCommand)command;
                    additionalMessage = " target = " + wCommand.getTarget();
                }
                Activator.log(new Exception("Exec command failure : status = " + command.getSystemStatusCode() + additionalMessage + " output = " + this.convert(aCommand.getSTDOut()) + " error message = " + this.convert(aCommand.getSTDErr())));
            }
            return true;
        }
        if (command instanceof ConcreteCommand) {
            ConcreteCommand cCommand = (ConcreteCommand)command;
            Activator.log(new Exception("Exec command failure : status = " + cCommand.getSystemStatusCode() + " command = " + CommandThread.toCommandString(cCommand)));
        } else if (command instanceof ReadCommand) {
            ReadCommand rCommand = (ReadCommand)command;
            Activator.log(new Exception("Read command failure : status = " + rCommand.getSystemStatusCode() + " source = " + rCommand.getSource()));
        } else if (command instanceof WriteCommand) {
            WriteCommand wCommand = (WriteCommand)command;
            Activator.log(new Exception("Write command failure : status = " + wCommand.getSystemStatusCode() + " target = " + wCommand.getTarget()));
        }
        return false;
    }

    private String convert(String source) {
        try {
            return new String(source.getBytes(), "EUC-JP");
        }
        catch (UnsupportedEncodingException e) {
            Activator.log(e);
            return source;
        }
    }

    public void cleanup(IProject project) {
        Connection connection = this.getConnection(SSHConnectionAdapter.getConnectionSettings(project));
        if (connection.isConnected()) {
            connection.disconnect();
        }
    }

    public boolean isConnected(IProject project) {
        Connection connection = this.getConnection(SSHConnectionAdapter.getConnectionSettings(project));
        return connection.isConnected();
    }

    public String getErrorMessage(IProject project) {
        Connection connection = this.getConnection(SSHConnectionAdapter.getConnectionSettings(project));
        return connection.getErrorMessage();
    }

    public void disconnect(IProject project) {
        Connection connection = this.getConnection(SSHConnectionAdapter.getConnectionSettings(project));
        connection.disconnect();
    }

    public void createSettingComposite(IProject project, Composite parent) {
        new UIUtilities(project).createSettingComposite(parent);
    }

    public String getSelfDomain(IProject project) {
        ConcreteCommand cCommand = new ConcreteCommand(project, "cat < /proc/ccs/info/self_domain");
        Connection connection = this.getConnection(SSHConnectionAdapter.getConnectionSettings(cCommand.getProject()));
        CommandThread thread = new CommandThread((SSHSession)connection, (ICommand)cCommand);
        Activator.getStandardDisplay().syncExec((Runnable)thread);
        if (cCommand.isSuccessful()) {
            return cCommand.getSTDOut();
        }
        return null;
    }

    private Connection getConnection(IConnectionSettings settings) {
        if (connectionCache.get(settings.getProject()) == null) {
            SSHSession connection = new SSHSession((SSHConnectionSettings)settings);
            connectionCache.put(settings.getProject(), connection);
            connection.addObserver(this);
        } else {
            SSHSession connection = connectionCache.get(settings.getProject());
            connection.settings = (SSHConnectionSettings)settings;
        }
        return connectionCache.get(settings.getProject());
    }

    @Override
    public void update(Observable o, Object arg) {
        IConnectionSettings settings = (IConnectionSettings)arg;
        ConnectionManager.getInstance().updateConnectionState(settings.getProject(), this.isConnected(settings.getProject()));
    }
}

