/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.AbstractWizardPage;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.Distribution;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.DistributionManager;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DistributionSelectionPage
extends AbstractWizardPage {
    private static final String PAGE_DESCRPTION = Messages.DistributionSelectionPage_PageDescription;
    private Button[] checkButtons = new Button[DistributionManager.getDistributionCount()];

    public DistributionSelectionPage() {
        super(Messages.DistributionSelectionPage_PageName);
        this.setTitle(Messages.DistributionSelectionPage_PageTitle);
        this.setDescription(PAGE_DESCRPTION);
        this.setPageComplete(false);
    }

    @Override
    protected String getHelpResourceName() {
        return "select_distribution";
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.createDistroGroup(composite);
        this.setControl((Control)composite);
    }

    @Override
    protected void hookFirstVisit() {
        this.setPreviousPage(null);
    }

    private void createDistroGroup(Composite composite) {
        GridLayout layout = new GridLayout(1, false);
        Composite container = new Composite(composite, 0);
        GridData data = new GridData(768);
        container.setLayoutData((Object)data);
        container.setLayout((Layout)layout);
        Distribution[] distros = DistributionManager.listDeistibutions();
        int cnt = 0;
        while (cnt < distros.length) {
            this.checkButtons[cnt] = new Button(container, 16);
            this.checkButtons[cnt].setText(distros[cnt].getName());
            this.checkButtons[cnt].setSelection(false);
            this.checkButtons[cnt].addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    DistributionSelectionPage.this.inputChanged();
                }
            });
            this.checkButtons[cnt].setEnabled(distros[cnt].isSupported());
            ++cnt;
        }
    }

    private void inputChanged() {
        int selection = this.getSelectedVersionIndex();
        if (selection < 0) {
            this.setPageComplete(false);
            return;
        }
        Distribution[] distros = DistributionManager.listDeistibutions();
        Distribution distribution = distros[selection];
        if (!distribution.isSupported()) {
            this.setPageComplete(false);
            this.setErrorMessage(String.valueOf(Messages.DistributionSelectionPage_NotSupportedErrorMessagePrefix) + distribution.getName() + Messages.DistributionSelectionPage_NotSupportedErrorMessageSuffix);
            return;
        }
        this.setPageComplete(true);
        this.setMessage(Messages.DistributionSelectionPage_PageCompleteMessage, 1);
    }

    private int getSelectedVersionIndex() {
        int cnt = 0;
        while (cnt < this.checkButtons.length) {
            if (this.checkButtons[cnt].getSelection()) {
                return cnt;
            }
            ++cnt;
        }
        return -1;
    }

    public String getVersionID() {
        int selection = this.getSelectedVersionIndex();
        if (selection < 0) {
            return null;
        }
        Distribution[] distros = DistributionManager.listDeistibutions();
        Distribution distribution = distros[selection];
        return distribution.getID();
    }

    @Override
    protected void previousButtonPressed() {
    }

    @Override
    protected void nextButtonPressed() {
        this.storeProperties();
    }

    private void storeProperties() {
    }
}

