/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tomoyo.ui.editor.CoreEditor;
import jp.sourceforge.tomoyo.ui.editor.ICoreEditorOutlilePage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CoreEditorOutlineContainer
extends Page
implements IContentOutlinePage {
    private PageBook pagebook;
    private ContentOutlinePage currentPage;
    private ArrayList<ISelectionChangedListener> listeners = new ArrayList();
    private ISelection selection;

    public CoreEditorOutlineContainer(CoreEditor editor) {
    }

    public void setPageActive(ContentOutlinePage page) {
        this.currentPage = page;
        if (this.pagebook == null) {
            return;
        }
        Control control = page.getControl();
        if (control == null || control.isDisposed()) {
            page.createControl((Composite)this.pagebook);
            control = page.getControl();
        }
        this.pagebook.showPage(control);
        this.updateToolbar(page);
        this.currentPage = page;
    }

    private void updateToolbar(ContentOutlinePage page) {
        IActionBars actionBars = this.getSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.removeAll();
        actionBars.updateActionBars();
        page.setActionBars(actionBars);
        if (page instanceof ICoreEditorOutlilePage) {
            ICoreEditorOutlilePage outline = (ICoreEditorOutlilePage)page;
            List<Action> actionList = outline.getToolBarActions();
            int cnt = 0;
            while (cnt < actionList.size()) {
                if (actionList.get(cnt) instanceof IContributionItem) {
                    IContributionItem item = (IContributionItem)actionList.get(cnt);
                    toolBarManager.add(item);
                }
                if (actionList.get(cnt) instanceof IAction) {
                    IAction action = (IAction)actionList.get(cnt);
                    toolBarManager.add(action);
                }
                ++cnt;
            }
            page.setActionBars(actionBars);
            actionBars.updateActionBars();
        }
    }

    public void setActionBars(IActionBars actionBars) {
        if (this.currentPage != null) {
            this.setPageActive(this.currentPage);
        }
    }

    public void createControl(Composite parent) {
        this.pagebook = new PageBook(parent, 0);
    }

    public Control getControl() {
        return this.pagebook;
    }

    public void setFocus() {
        if (this.currentPage != null) {
            this.currentPage.setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        if (this.listeners == null) {
            return;
        }
        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).selectionChanged(e);
            ++i;
        }
    }
}

