/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.dialog;

import java.util.ArrayList;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileGroup;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.ConcreteCommand;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.dialog.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ChangeProfileDialog
extends TitleAreaDialog {
    private IProject project;
    private Domain[] domainArray;
    private TableViewer viewer = null;
    private static final String[] COLUMN_PROPERTIES = new String[]{"no", "comment", "description"};
    private Button[] radioButtons = new Button[2];

    public ChangeProfileDialog(Shell parentShell, IProject project, Domain[] domainArray) {
        super(parentShell);
        this.project = project;
        this.domainArray = domainArray;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ChangeProfileDialog_ShellTitle);
    }

    protected int getShellStyle() {
        return 1264;
    }

    protected Point getInitialSize() {
        return new Point(400, 500);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            Button okButton = super.createButton(parent, id, label, defaultButton);
            okButton.setEnabled(this.domainArray != null && this.domainArray.length > 0);
            return okButton;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ChangeProfileDialog_DialogTitle);
        this.setTitleImage(Activator.getImage("coloring_wiz.gif"));
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginTop = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createViewer(container);
        this.createRadioButtons(container);
        this.initializeUI();
        return composite;
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 2048);
        Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ChangeProfileDialog.this.okPressed();
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangeProfileDialog.this.setErrorMessage(null);
            }
        });
        TableColumn column = new TableColumn(table, 0x1000000);
        column.setText(Messages.ChangeProfileDialog_ColumnProfile);
        column.setWidth(50);
        column = new TableColumn(table, 0x1000000);
        column.setText(Messages.ChangeProfileDialog_ColumnComment);
        column.setWidth(100);
        column = new TableColumn(table, 0x1000000);
        column.setText(Messages.ChangeProfileDialog_ColumnDescription);
        column.setWidth(200);
        this.viewer.setColumnProperties(COLUMN_PROPERTIES);
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)};
        this.viewer.setCellEditors(editors);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ColoringLabelProvider());
        ArrayList input = ProfileManager.getInstance().getProjectProfile(this.project).toList(true);
        this.viewer.setInput((Object)input);
    }

    private void createRadioButtons(Composite composite) {
        this.radioButtons[0] = this.createRadioButton(composite, Messages.ChangeProfileDialog_OptionRecursive);
        this.radioButtons[1] = this.createRadioButton(composite, Messages.ChangeProfileDialog_OptionNotRecursive);
        this.radioButtons[0].setSelection(true);
    }

    protected Button createRadioButton(Composite parent, String text) {
        Button button = new Button(parent, 16);
        button.setText(text);
        button.setFont(parent.getFont());
        return button;
    }

    private void initializeUI() {
        this.viewer.getControl().setFocus();
    }

    protected void okPressed() {
        ProfileGroup group = this.getGroup();
        if (group == null) {
            return;
        }
        if (this.save(group)) {
            super.okPressed();
        } else {
            this.setErrorMessage(Messages.ChangeProfileDialog_ChangeNGMessage);
        }
    }

    private boolean save(ProfileGroup selectedGroup) {
        String strDomain = this.domainArray[0].getText();
        if (selectedGroup == null) {
            return false;
        }
        boolean recursive = this.radioButtons[0].getSelection();
        StringBuffer setProfileCommand = new StringBuffer();
        setProfileCommand.append(CommandManager.createCCSToolPath((IProject)this.project, (String)"setprofile"));
        setProfileCommand.append(" ");
        String option = null;
        if (recursive) {
            option = "-r";
        }
        setProfileCommand.append(selectedGroup.getNo());
        setProfileCommand.append(" ");
        setProfileCommand.append("'" + strDomain + "'");
        ConcreteCommand command = CommandManager.getInstance().exec(this.project, CommandManager.createCCSToolPath((IProject)this.project, (String)"setprofile"), new String[]{option}, new String[]{String.valueOf(selectedGroup.getNo()), "'" + strDomain + "'"});
        if (command.isSuccessful()) {
            DomainPolicy domainPolicy = ProcResourceManager.getInstance().getProcResourceSet(this.project).getDomainPolicy();
            if (ProcResourceManager.getInstance().synchronize(this.project, (LocalResource)domainPolicy)) {
                String message = Messages.ChangeProfileDialog_ChangeOKMessage;
                TomoyoCorePlugin.getDefault().setStatusMessage(message);
                return true;
            }
            String message = Messages.ChangeProfileDialog_ChangeNGMessage;
            TomoyoCorePlugin.getDefault().setStatusErrorMessage(message);
            return false;
        }
        return false;
    }

    private ProfileGroup getGroup() {
        Object firstElement;
        if (this.viewer.getSelection() instanceof StructuredSelection && (firstElement = ((StructuredSelection)this.viewer.getSelection()).getFirstElement()) instanceof ProfileGroup) {
            ProfileGroup group = (ProfileGroup)firstElement;
            return group;
        }
        return null;
    }

    private class ColoringLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private ColoringLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ProfileGroup group = (ProfileGroup)element;
            String result = "";
            switch (columnIndex) {
                case 0: {
                    result = String.valueOf(group.getNo());
                    break;
                }
                case 1: {
                    result = group.getComment();
                    break;
                }
                case 2: {
                    result = group.getDescription();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public Color getBackground(Object element, int columnIndex) {
            ProfileGroup group = (ProfileGroup)element;
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    RGB rgb = group.getBackcolor();
                    if (rgb == null) break;
                    return Activator.getDefault().getColor(rgb);
                }
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            ProfileGroup group = (ProfileGroup)element;
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    RGB rgb = group.getForecolor();
                    if (rgb == null) break;
                    return Activator.getDefault().getColor(rgb);
                }
            }
            return null;
        }
    }
}

