/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.dialog;

import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.WriteCommand;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.dialog.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewAccessPermissionDialog
extends TitleAreaDialog {
    private IProject project;
    private Domain domain;
    private String strAccessPermission;
    private final String INPUT_NEW_ACCESS_PERMISSION = Messages.NewAccessPermissionDialog_InputNewAccessPermissionMessage;
    private Text accessPermissionText;

    public NewAccessPermissionDialog(Shell parentShell, IProject project, Domain domain) {
        this(parentShell, project, domain, null);
    }

    public NewAccessPermissionDialog(Shell parentShell, IProject project, Domain domain, String argAccessPermission) {
        super(parentShell);
        this.project = project;
        this.domain = domain;
        this.strAccessPermission = argAccessPermission;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.NewAccessPermissionDialog_ShellTitle);
    }

    protected int getShellStyle() {
        return 1264;
    }

    protected Point getInitialSize() {
        return new Point(500, 250);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            Button okButton = super.createButton(parent, id, label, defaultButton);
            okButton.setEnabled(false);
            return okButton;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.NewAccessPermissionDialog_DialogTitle);
        this.setTitleImage(Activator.getImage("coloring_wiz.gif"));
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createComposite(composite);
        this.initializeUI();
        return composite;
    }

    private void initializeUI() {
        if (this.strAccessPermission == null) {
            this.accessPermissionText.setText(this.INPUT_NEW_ACCESS_PERMISSION);
        } else {
            this.accessPermissionText.setText(this.strAccessPermission);
        }
        this.accessPermissionText.selectAll();
    }

    private void createComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        data.horizontalIndent = 0;
        container.setLayoutData((Object)data);
        Label domainIconLabel = new Label(container, 0);
        domainIconLabel.setLayoutData((Object)new GridData(1));
        domainIconLabel.setImage(Activator.getImage("domain.gif"));
        Label domainLabel = new Label(container, 64);
        domainLabel.setText(this.domain.getText());
        domainLabel.setToolTipText(domainLabel.getText());
        Label accessPermissionIconLabel = new Label(container, 0);
        accessPermissionIconLabel.setLayoutData((Object)new GridData(1));
        accessPermissionIconLabel.setImage(Activator.getImage("resource.gif"));
        this.accessPermissionText = this.createText(container, 2048);
        this.accessPermissionText.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private Text createText(Composite parent, int style) {
        Text text = new Text(parent, style);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewAccessPermissionDialog.this.handleModifyText((Text)e.getSource());
            }
        });
        GridData data = new GridData();
        text.setLayoutData((Object)data);
        return text;
    }

    private void handleModifyText(Text eventText) {
        if (eventText == this.accessPermissionText) {
            this.handleModifyAccessPermissionText();
        }
    }

    private void handleModifyAccessPermissionText() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.canSave(this.accessPermissionText.getText()));
        }
    }

    private boolean canSave(String argText) {
        String checkText = argText.trim();
        String[] strs = checkText.split("[\\s]+");
        if (strs.length < 2) {
            this.setErrorMessage(Messages.NewAccessPermissionDialog_InvalidFormatErrorMessage);
            return false;
        }
        String directive = strs[0];
        if (!this.getLocalResource().getModel().isDirectiveSupported(directive)) {
            this.setErrorMessage(Messages.NewAccessPermissionDialog_InvalidDirectiveMessage);
            return false;
        }
        if (this.hasDuplicateContent(this.domain, checkText, true)) {
            this.setErrorMessage(Messages.NewAccessPermissionDialog_AlreadyExistsMessage);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(Messages.NewAccessPermissionDialog_InputOKMessage, 1);
        return true;
    }

    private boolean hasDuplicateContent(Domain domain, String strAccessPermission, boolean ignoreDeleted) {
        if (domain == null || strAccessPermission == null) {
            return true;
        }
        AccessPermission element = PolicyCacheManager.getInstance().findAccessPermission(this.project, domain, strAccessPermission);
        if (element == null) {
            return false;
        }
        return !element.isDeleted();
    }

    private boolean checkSaved(String newDomainText, String newAccessText) {
        Domain domain;
        PolicyElement savedElement = PolicyCacheManager.getInstance().findElement(this.project, AccessPermission.class, newAccessText);
        if (savedElement != null && savedElement.getParent() instanceof Domain && (domain = (Domain)savedElement.getParent()) != null) {
            return domain.getText().equals(newDomainText);
        }
        return false;
    }

    protected void okPressed() {
        if (this.save()) {
            super.okPressed();
        } else {
            super.okPressed();
        }
    }

    private boolean save() {
        String newDomainText = this.domain.getText();
        String newAccessText = this.accessPermissionText.getText();
        LocalResource localResource = this.getLocalResource();
        WriteCommand command = CommandManager.getInstance().write(this.project, localResource, this.getInput(newDomainText, newAccessText));
        if (command.isSuccessful() && ProcResourceManager.getInstance().synchronize(this.project, localResource)) {
            if (this.checkSaved(newDomainText, newAccessText)) {
                String message = String.valueOf(Messages.NewAccessPermissionDialog_SaveOKMessage) + " : " + newAccessText;
                TomoyoCorePlugin.getDefault().setStatusMessage(message);
                return true;
            }
            String message = String.valueOf(Messages.NewAccessPermissionDialog_SaveNGMessage) + " : " + newAccessText;
            TomoyoCorePlugin.getDefault().setStatusErrorMessage(message);
            return false;
        }
        return false;
    }

    private String getInput(String newDomainText, String newAccessText) {
        StringBuffer input = new StringBuffer();
        input.append(newDomainText);
        input.append("\n");
        input.append(" ");
        input.append(newAccessText);
        input.append("\n");
        return input.toString();
    }

    private LocalResource getLocalResource() {
        DomainPolicy localResource = ProcResourceManager.getInstance().getProcResourceSet(this.project).getDomainPolicy();
        return localResource;
    }
}

