/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.form;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.core.local.parser.PolicyParserManager;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.server.ConnectionManager;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.ICoreEditorOutlinePageProvider;
import jp.sourceforge.tomoyo.ui.editor.form.Messages;
import jp.sourceforge.tomoyo.ui.editor.form.outline.ProjectOutlinePage;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public abstract class PlainFormPage
extends FormPage
implements ICoreEditorOutlinePageProvider {
    private SashForm todoSash;
    private ShowTODOAction showTODOAction = new ShowTODOAction();
    private SwitchSashOrientationAction verticalOrientAction = new SwitchSashOrientationAction(512);
    private SwitchSashOrientationAction horizontalOrientAction = new SwitchSashOrientationAction(256);
    protected Action back2homeAction = this.createBack2HomeAction();
    protected Action connectAction = this.createConnectAction();
    protected static final String STATUS_MSG_CONNECTING = Messages.PlainFormPage_StatusMessageConnecting;
    protected static final String STATUS_MSG_SAVING = Messages.PlainFormPage_StatusMessageSaving;
    protected static final String STATUS_MSG_LOADING = Messages.PlainFormPage_StatusMessageLoading;
    protected static final String STATUS_MSG_CONNECTED = Messages.PlainFormPage_StatusMessageConnected;
    protected static final String STATUS_MSG_DISCONNECTED = Messages.PlainFormPage_StatusMessageDisconnected;
    protected static final String STATUS_MSG_CANT_CONNECTED = Messages.PlainFormPage_StatusMessageCannotConnect2Server;
    protected static final String STATUS_MSG_SAVED = Messages.PlainFormPage_StatusMessageSaved;
    protected static final String STATUS_MSG_LOADED = Messages.PlainFormPage_StatusMessageLoaded;
    protected static final String STATUS_MSG_ERROR = Messages.PlainFormPage_StatusMessageErrorOccured;
    private Class focusedSectionClass;
    private ArrayList<Widget> widgedList = new ArrayList();
    private boolean initialzed = false;
    private ProjectOutlinePage outlinePage = null;

    public PlainFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        String formTitle = this.getFormTitle();
        form.setData("title", (Object)formTitle);
        form.setText(formTitle);
        this.createToolBarActions(managedForm);
        this.crateBody(this.setupBody(form));
        this.restoreDefault();
        managedForm.refresh();
        this.setupObservers();
        this.markInitialized();
    }

    protected void setupObservers() {
        PolicyParserManager.getInstance().addObserver((Observer)new PolicyUpdateObserver());
        ProfileManager.getInstance().addObserver((Observer)new ProfileUpdateObserver());
        ConnectionManager.getInstance().addObserver((Observer)new ConnectionStatusObserver());
    }

    private Composite setupBody(ScrolledForm form) {
        Composite body = form.getBody();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        body.setLayout((Layout)layout);
        return body;
    }

    protected abstract String getFormTitle();

    protected void handleAuditLogSelectionChanged(ISelection selection) {
    }

    protected void handleHistoryElementSelectionChanged(ISelection selection) {
    }

    protected void crateBody(Composite body) {
        this.todoSash = new SashForm(body, 512);
        GridLayout layout1 = new GridLayout();
        this.todoSash.setBackground(body.getBackground());
        this.todoSash.setLayout((Layout)layout1);
        this.todoSash.setLayoutData((Object)new GridData(1808));
        this.createTodoSection((Composite)this.todoSash);
        this.createClient((Composite)this.todoSash);
    }

    protected abstract void createClient(Composite var1);

    protected void restoreDefault() {
        this.showTODOAction.setChecked(false);
        this.showTODOAction.run();
        this.verticalOrientAction.setChecked(true);
        this.verticalOrientAction.run();
        this.updateConnectToolbarAction(ConnectionManager.getInstance().isConnected(this.getProject()));
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        List<Action> actionList = this.getToolBarActions();
        if (actionList == null) {
            return;
        }
        ScrolledForm form = managedForm.getForm();
        int cnt = 0;
        while (cnt < actionList.size()) {
            Action action = actionList.get(cnt);
            form.getToolBarManager().add((IAction)action);
            ++cnt;
        }
        form.updateToolBar();
    }

    protected List<Action> getToolBarActions() {
        ArrayList<Action> actionList = new ArrayList<Action>();
        actionList.add(this.back2homeAction);
        actionList.add(this.connectAction);
        return actionList;
    }

    protected Action createBack2HomeAction() {
        Action action = new Action("", 1){

            public void run() {
                FormEditor formEditor = PlainFormPage.this.getEditor();
                formEditor.setActivePage("Overview");
            }
        };
        action.setToolTipText(Messages.PlainFormPage_Back2HomeToolTipText);
        action.setImageDescriptor(Activator.getImageDescriptor("home.gif"));
        return action;
    }

    protected Action createConnectAction() {
        Action action = new Action(Messages.PlainFormPage_Connect2ServerActionTitle, 2){

            public void run() {
                if (this.isChecked()) {
                    ConnectionManager.getInstance().connect(PlainFormPage.this.getProject());
                } else {
                    ConnectionManager.getInstance().disConnect(PlainFormPage.this.getProject());
                }
            }
        };
        action.setToolTipText(action.getText());
        action.setImageDescriptor(Activator.getImageDescriptor("disconnected.gif"));
        return action;
    }

    protected Action createShowHelpAction() {
        Action action = new Action(Messages.PlainFormPage_ShowHelpResourceActionTitle, 1){

            public void run() {
                ScrolledForm form = PlainFormPage.this.getManagedForm().getForm();
                BusyIndicator.showWhile((Display)form.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(PlainFormPage.this.getHelpPath());
                    }
                });
            }
        };
        action.setToolTipText(action.getText());
        action.setImageDescriptor(Activator.getImageDescriptor("help.gif"));
        return action;
    }

    protected abstract String getHelpPath();

    private FormText createFormText(Composite section, String content) {
        FormText text = this.getManagedForm().getToolkit().createFormText(section, true);
        try {
            text.setText(content, true, false);
        }
        catch (SWTException e) {
            text.setText(e.getMessage(), false, false);
        }
        section.setLayoutData((Object)new TableWrapData(128, 256));
        return text;
    }

    protected Section createSection(Composite parent, String gridID) {
        String description;
        Section section = this.getManagedForm().getToolkit().createSection(parent, 0x100 | this.getStyle(gridID));
        section.setLayoutData((Object)new GridData(1808, 1808));
        String title = this.getSectionTitle(gridID);
        if (title != null) {
            section.setText(title);
        }
        if ((description = this.getSectionDescription(gridID)) != null) {
            section.setDescription(description);
        }
        section.setData("gridID", (Object)gridID);
        Composite container = this.getManagedForm().getToolkit().createComposite((Composite)section);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808, 1808));
        this.createContent(container, gridID);
        section.setTextClient((Control)this.createToolbar(section));
        this.getManagedForm().getToolkit().paintBordersFor(container);
        section.setClient((Control)container);
        return section;
    }

    protected Composite createToolbar(Section section) {
        return null;
    }

    protected int getStyle(String gridID) {
        return 0;
    }

    protected Object getSectionLayoutData(String gridID) {
        return null;
    }

    protected String getSectionTitle(String gridID) {
        return null;
    }

    protected String getSectionDescription(String gridID) {
        return null;
    }

    protected void createContent(Composite parent, String gridID) {
    }

    protected Section createSection(Composite parent, FormToolkit toolkit, String title, String description, String helppath, int style) {
        Section section = toolkit.createSection(parent, style);
        section.setText(title);
        if (description != null) {
            section.setDescription(description);
        }
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(1808, 1808));
        return section;
    }

    protected IProject getProject() {
        return ((FileEditorInput)this.getEditor().getEditorInput()).getFile().getProject();
    }

    protected ProjectProperty getProjectProperty() {
        return ProjectPropertyManager.getInstance().getProperty(this.getProject());
    }

    protected FormToolkit getToolKit() {
        return this.getManagedForm().getToolkit();
    }

    protected Shell getActiveShell() {
        return Activator.getStandardDisplay().getActiveShell();
    }

    private void handleViewerFocusGaind(Viewer viewer) {
        this.focusedSectionClass = (Class)viewer.getData("filter");
    }

    protected Class getFocusedSectionClass() {
        return this.focusedSectionClass;
    }

    public void notifyPageChanged(PlainFormPage editorPage) {
    }

    protected void notifyPolicyUpdated(IProject project, LocalResource localResource) {
    }

    protected void notifyProfileUpdated(IProject project) {
    }

    protected void notifyConnectionUpdated(IProject project, boolean isConnected) {
        this.updateConnectToolbarAction(isConnected);
    }

    private void updateConnectToolbarAction(boolean isConnected) {
        this.connectAction.setChecked(isConnected);
        if (isConnected) {
            this.connectAction.setImageDescriptor(Activator.getImageDescriptor("connected.gif"));
        } else {
            this.connectAction.setImageDescriptor(Activator.getImageDescriptor("disconnected.gif"));
        }
    }

    protected Widget addWidget(Widget widget) {
        this.widgedList.add(widget);
        return widget;
    }

    protected boolean hasDisposedWidgets() {
        for (Widget next : this.widgedList) {
            Widget widget;
            if (!(next instanceof Widget) || !(widget = next).isDisposed()) continue;
            return false;
        }
        return true;
    }

    private void markInitialized() {
        this.initialzed = true;
    }

    public boolean isInitizlized() {
        return this.initialzed;
    }

    protected boolean checkWidgets() {
        return !this.hasDisposedWidgets() && this.isInitizlized();
    }

    protected void createTodoSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        composite.setBackground(parent.getBackground());
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Section section = this.createSection(composite, this.getManagedForm().getToolkit(), this.getTodoSectionTitle(), this.getTodoSectionDescription(), "helppath", 256);
        section.setLayout((Layout)new TableWrapLayout());
        section.setLayoutData((Object)new GridData(1808));
        Composite container = this.getManagedForm().getToolkit().createComposite((Composite)section, 0);
        TableWrapLayout containerLayout = new TableWrapLayout();
        containerLayout.numColumns = 1;
        containerLayout.makeColumnsEqualWidth = false;
        containerLayout.horizontalSpacing = 0;
        container.setLayout((Layout)containerLayout);
        StringBuffer formHTML = new StringBuffer();
        formHTML.append("<form>");
        int cnt = 0;
        while (cnt < this.getTodoCount()) {
            formHTML.append("<li style=\"image\" value=\"img" + cnt + "\" bindent=\"5\">");
            formHTML.append("<a href=\"" + this.getHref(cnt) + "\">");
            formHTML.append(this.getLinkText(cnt));
            formHTML.append("</a>");
            formHTML.append(" : ");
            formHTML.append(this.getLinkDescription(cnt));
            formHTML.append("</li>");
            ++cnt;
        }
        formHTML.append("</form>");
        FormText compileFormText = this.createFormText(container, formHTML.toString());
        int cnt2 = 0;
        while (cnt2 < this.getTodoCount()) {
            compileFormText.setImage("img" + cnt2, this.getLinkImage(cnt2));
            ++cnt2;
        }
        compileFormText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String href = e.getHref().toString();
                PlainFormPage.this.handleTodoLinkEvent(href);
            }
        });
        section.setClient((Control)container);
    }

    protected abstract void handleTodoLinkEvent(String var1);

    protected String getTodoSectionTitle() {
        return "TODO";
    }

    protected String getTodoSectionDescription() {
        return null;
    }

    protected int getTodoCount() {
        Todo[] todoList = this.getTodoList();
        if (todoList == null) {
            return 0;
        }
        return todoList.length;
    }

    protected abstract Todo[] getTodoList();

    protected Image getLinkImage(int index) {
        Todo[] todoList = this.getTodoList();
        if (todoList == null) {
            return null;
        }
        return todoList[index].getImage();
    }

    protected String getLinkText(int index) {
        Todo[] todoList = this.getTodoList();
        if (todoList == null) {
            return null;
        }
        return todoList[index].getLinkText();
    }

    protected String getLinkDescription(int index) {
        Todo[] todoList = this.getTodoList();
        if (todoList == null) {
            return null;
        }
        return todoList[index].getDescription();
    }

    protected String getHref(int index) {
        Todo[] todoList = this.getTodoList();
        if (todoList == null) {
            return null;
        }
        return todoList[index].getHref();
    }

    protected GridLayout setBorder0(GridLayout layout) {
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    protected GridLayout setMargin(GridLayout layout, int width) {
        layout.horizontalSpacing = 10;
        return layout;
    }

    @Override
    public ContentOutlinePage getContentOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new ProjectOutlinePage(this.getEditor());
        }
        return this.outlinePage;
    }

    private class ShowTODOAction
    extends Action {
        public ShowTODOAction() {
            super("", 2);
            this.setImageDescriptor(Activator.getImageDescriptor("todo.gif"));
        }

        public void run() {
            this.showTODO(this.isChecked());
            this.setSashEnabled(this.isChecked());
        }

        private void showTODO(boolean b) {
            if (b) {
                PlainFormPage.this.todoSash.setMaximizedControl(null);
            } else {
                PlainFormPage.this.todoSash.setMaximizedControl(PlainFormPage.this.todoSash.getChildren()[1]);
            }
        }

        private void setSashEnabled(boolean b) {
            PlainFormPage.this.verticalOrientAction.setEnabled(b);
            PlainFormPage.this.horizontalOrientAction.setEnabled(b);
        }
    }

    private class SwitchSashOrientationAction
    extends Action {
        private int orientation;

        public SwitchSashOrientationAction(int orientation) {
            super("", 8);
            this.orientation = orientation;
            if (orientation == 512) {
                this.setImageDescriptor(Activator.getImageDescriptor("vertical.gif"));
            } else {
                this.setImageDescriptor(Activator.getImageDescriptor("horizontal.gif"));
            }
        }

        public void run() {
            if (this.orientation == 512) {
                this.setHorizontal();
            } else {
                this.setVertical();
            }
        }

        private void setVertical() {
            PlainFormPage.this.todoSash.setOrientation(512);
            PlainFormPage.this.todoSash.setWeights(new int[]{1, 4});
        }

        private void setHorizontal() {
            PlainFormPage.this.todoSash.setOrientation(256);
            PlainFormPage.this.todoSash.setWeights(new int[]{1, 4});
        }
    }

    protected class ViewerFocusAdapter
    extends FocusAdapter {
        private Viewer viewer;

        public ViewerFocusAdapter(Viewer viewer) {
            this.viewer = viewer;
        }

        public void focusGained(FocusEvent e) {
            PlainFormPage.this.handleViewerFocusGaind(this.viewer);
        }
    }

    private class PolicyUpdateObserver
    implements Observer {
        private PolicyUpdateObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            Display.getDefault().asyncExec((Runnable)new PolicyUpdateThread(o, arg));
        }
    }

    private class PolicyUpdateThread
    implements Runnable {
        private Observable o;
        private Object arg;

        public PolicyUpdateThread(Observable o, Object arg) {
            this.o = o;
            this.arg = arg;
        }

        @Override
        public void run() {
            if (this.o instanceof PolicyParserManager) {
                LocalResource localResource = (LocalResource)this.arg;
                IProject project = localResource.getProject();
                if (PlainFormPage.this.getPartControl().isDisposed()) {
                    return;
                }
                PlainFormPage.this.notifyPolicyUpdated(project, localResource);
            }
        }
    }

    private class ProfileUpdateObserver
    implements Observer {
        private ProfileUpdateObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            Display.getDefault().asyncExec((Runnable)new ProfileUpdateThread(o, arg));
        }
    }

    private class ProfileUpdateThread
    implements Runnable {
        private Observable o;
        private Object arg;

        public ProfileUpdateThread(Observable o, Object arg) {
            this.o = o;
            this.arg = arg;
        }

        @Override
        public void run() {
            if (this.o instanceof ProfileManager) {
                Hashtable table = (Hashtable)this.arg;
                IProject project = (IProject)table.get(IProject.class);
                PlainFormPage.this.notifyProfileUpdated(project);
            }
        }
    }

    private class ConnectionStatusObserver
    implements Observer {
        private ConnectionStatusObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            Display.getDefault().asyncExec((Runnable)new ConnectionStatusUpdateThread(o, arg));
        }
    }

    private class ConnectionStatusUpdateThread
    implements Runnable {
        public ConnectionStatusUpdateThread(Observable o, Object arg) {
        }

        @Override
        public void run() {
            boolean isConnected = ConnectionManager.getInstance().isConnected(PlainFormPage.this.getProject());
            PlainFormPage.this.notifyConnectionUpdated(PlainFormPage.this.getProject(), isConnected);
        }
    }

    protected class Todo {
        private Image image;
        private String linkText;
        private String description;
        private String href;

        public Todo(Image image, String linkText, String description, String href) {
            this.image = image;
            this.linkText = linkText;
            this.description = description;
            this.href = href;
        }

        public String getDescription() {
            return this.description;
        }

        public String getHref() {
            return this.href;
        }

        public Image getImage() {
            return this.image;
        }

        public String getLinkText() {
            return this.linkText;
        }
    }
}

