/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.form.domain;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.core.extensions.PolicyElementHistory;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.model.domain.Profile;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileGroup;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.core.local.model.status.ProjectProfile;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.ExceptPolicy;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.othres.DomainTransitionTreeAsciiOrderSorter;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.CoreEditorOutlineLabelProvider;
import jp.sourceforge.tomoyo.ui.editor.CoreEditorOutlineMouseListener;
import jp.sourceforge.tomoyo.ui.editor.ViewerExpandCollapseKeyListener;
import jp.sourceforge.tomoyo.ui.editor.dialog.CcsTreeDialog;
import jp.sourceforge.tomoyo.ui.editor.dialog.ColoringDialog;
import jp.sourceforge.tomoyo.ui.editor.form.PlainFormPage;
import jp.sourceforge.tomoyo.ui.editor.form.ResourceFormPage;
import jp.sourceforge.tomoyo.ui.editor.form.domain.DomainPolicyOutlineMouseListener;
import jp.sourceforge.tomoyo.ui.editor.form.domain.DomainPolicyViewerKeyListener;
import jp.sourceforge.tomoyo.ui.editor.form.domain.DomainSearchDialog;
import jp.sourceforge.tomoyo.ui.editor.form.domain.DomainSearchDialogObserver;
import jp.sourceforge.tomoyo.ui.editor.form.domain.Messages;
import jp.sourceforge.tomoyo.ui.editor.text.outline.DomainPolicyOutlineContentProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.DomainPolicyOutlineDecoratingLabelProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.DomainPolicyOutlineLabelProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlineContentProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlineMenuListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.Section;

public class DomainPolicyPage
extends ResourceFormPage {
    public static final String PAGE_ID = "Domain";
    private TreeViewer domainViewer;
    private Label iconLabel;
    private FormText formText;
    private Button domainExpandButton;
    private Button domainCollapseButton;
    private Button coloringButton;
    private Button showSearchButton;
    private Button showCCSTreeButton;
    private Button domainChildCountButton;
    private TreeViewer accessViewer;
    private Label profileIconLabel;
    private Label prifileTextLabel;
    private Button accessExpandButton;
    private Button accessCollapseButton;
    private Button accessChildCountButton;
    private Button accessElementOrderButton;
    private Button accessPathOrderButton;
    private Button accessAscendButton;
    private AccessControlSorter accessSorter;
    private DomainSearchDialogObserver dialogObserver = new DomainSearchDialogObserver();
    private boolean needToRefreshViewer = false;

    public DomainPolicyPage(FormEditor editor) {
        super(editor, PAGE_ID, Messages.DomainPolicyPage_PageTitle);
        this.setContentDescription(Messages.DomainPolicyPage_PageDescription);
    }

    @Override
    protected LocalResource getLocalResource() {
        return ProcResourceManager.getInstance().getProcResourceSet(this.getProject()).getDomainPolicy();
    }

    @Override
    protected String getFormTitle() {
        return Messages.DomainPolicyPage_FormText;
    }

    @Override
    protected PlainFormPage.Todo[] getTodoList() {
        PlainFormPage.Todo[] todoList = new PlainFormPage.Todo[]{};
        return todoList;
    }

    @Override
    protected void handleTodoLinkEvent(String href) {
        if (href.equals("href.search")) {
            this.handleSearchDomain();
        }
        href.equals("href.learning");
        href.equals("href.permissive");
        href.equals("href.enforcing");
        href.equals("href.initializer");
        href.equals("href.keep_domain");
        if (href.equals("href.ccstree")) {
            this.handleCCSTree();
        }
    }

    @Override
    protected void createClient(Composite body) {
        Composite composite = new Composite(body, 0);
        composite.setBackground(body.getBackground());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        SashForm sash = new SashForm(composite, 256);
        GridLayout layout2 = new GridLayout();
        sash.setBackground(body.getBackground());
        sash.setLayout((Layout)layout2);
        sash.setLayoutData((Object)new GridData(1808));
        Composite left = this.getManagedForm().getToolkit().createComposite((Composite)sash, 0);
        left.setLayout((Layout)this.setBorder0(new GridLayout()));
        left.setLayoutData((Object)new GridData(1808));
        this.createSection1(left);
        Composite right = this.getManagedForm().getToolkit().createComposite((Composite)sash, 0);
        right.setLayout((Layout)this.setBorder0(new GridLayout()));
        right.setLayoutData((Object)new GridData(1808));
        this.createSection2(right);
        sash.setWeights(new int[]{3, 2});
    }

    protected Section createSection1(Composite parent) {
        Section section = this.getManagedForm().getToolkit().createSection(parent, 256);
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        String title = Messages.DomainPolicyPage_DomainViewerSectionTitle;
        if (title != null) {
            section.setText(title);
        }
        Composite container = this.getManagedForm().getToolkit().createComposite((Composite)section);
        container.setLayout((Layout)this.setBorder0(new GridLayout()));
        container.setLayoutData((Object)new GridData(1808));
        this.domainViewer = this.createDomainTreeViewer(container);
        this.getManagedForm().getToolkit().paintBordersFor(container);
        section.setClient((Control)container);
        return section;
    }

    protected Section createSection2(Composite parent) {
        Section section = this.getManagedForm().getToolkit().createSection(parent, 256);
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        String title = Messages.DomainPolicyPage_AccessViewerSectionTitle;
        if (title != null) {
            section.setText(title);
        }
        Composite container = this.getManagedForm().getToolkit().createComposite((Composite)section);
        container.setLayout((Layout)this.setBorder0(new GridLayout()));
        container.setLayoutData((Object)new GridData(1808));
        this.accessViewer = this.createAccessTreeViewer(container);
        this.getManagedForm().getToolkit().paintBordersFor(container);
        section.setClient((Control)container);
        return section;
    }

    @Override
    protected void restoreDefault() {
        super.restoreDefault();
        this.setAccessViewerTreeStyle(true);
        this.accessAscendButton.setSelection(true);
        this.setAccessViewerOrientation(true);
        this.coloringButton.setSelection(true);
        this.setDomainColoringEnabled(true);
        this.domainChildCountButton.setSelection(true);
        this.showChildDomainCount(true);
        this.accessChildCountButton.setSelection(true);
        this.showChildACLCount(true);
        this.domainViewer.setInput(this.createModel());
        this.expandTree(this.domainViewer);
        this.accessExpandButton.setSelection(true);
        this.accessViewer.expandAll();
        this.setDefaultSelection(this.domainViewer);
        this.domainViewer.getControl().setFocus();
    }

    private void setDefaultSelection(TreeViewer viewer) {
        Object[] visibles = viewer.getVisibleExpandedElements();
        if (visibles == null || visibles.length == 0) {
            return;
        }
        viewer.setSelection((ISelection)new StructuredSelection(visibles[0]));
    }

    @Override
    protected void handleHistoryElementSelectionChanged(ISelection selection) {
        StructuredSelection structured;
        if (selection instanceof StructuredSelection && (structured = (StructuredSelection)selection).size() == 1) {
            PolicyElementHistory history = (PolicyElementHistory)structured.getFirstElement();
            PolicyElement element = history.getPolicyElement();
            if (element instanceof Domain) {
                this.setSelection(this.domainViewer, element);
            }
            if (element instanceof AccessPermission) {
                Domain domain = (Domain)element.getParent();
                this.setSelection(this.domainViewer, (PolicyElement)domain);
                this.setSelection(this.accessViewer, element);
            }
        }
    }

    private void handleCCSTree() {
        CcsTreeDialog dialog = new CcsTreeDialog(Activator.getStandardDisplay().getActiveShell(), this.getProject());
        dialog.setParent(this);
        dialog.open();
    }

    private Composite createDomainTreeViewerHeaderArea(Composite parent) {
        Composite container = this.getManagedForm().getToolkit().createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        container.setLayoutData((Object)gd);
        this.iconLabel = this.getManagedForm().getToolkit().createLabel(container, null);
        this.iconLabel.setLayoutData((Object)new GridData(1));
        this.iconLabel.setImage(Activator.getImage("blank.gif"));
        this.formText = this.getManagedForm().getToolkit().createFormText(container, true);
        try {
            this.formText.setText("", false, false);
        }
        catch (SWTException e) {
            Activator.logException(e);
        }
        this.formText.setHyperlinkSettings(new HyperlinkSettings(Activator.getStandardDisplay()){

            public Cursor getBusyCursor() {
                return null;
            }
        });
        this.formText.setLayoutData((Object)new GridData(1808));
        this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Domain targetDomain = PolicyCacheManager.getInstance().findDomain(DomainPolicyPage.this.getProject(), e.getHref().toString());
                if (targetDomain != null) {
                    DomainPolicyPage.this.setSelection(DomainPolicyPage.this.domainViewer, (PolicyElement)targetDomain);
                }
            }
        });
        return container;
    }

    private String createDomainLink(Domain domain) {
        StringBuffer formHTML = new StringBuffer();
        formHTML.append("<form>");
        formHTML.append("<p>");
        int cnt = 0;
        while (cnt < domain.getDepth()) {
            int depth = cnt + 1;
            formHTML.append("<a href=\"" + this.escape(domain.getText2(depth)) + "\">");
            formHTML.append(this.escape(domain.getText(cnt)));
            formHTML.append("</a>");
            formHTML.append(" ");
            ++cnt;
        }
        formHTML.append("</p>");
        formHTML.append("</form>");
        return formHTML.toString();
    }

    private String escape(String html) {
        String rep1 = html.replaceAll("<", "&lt;");
        String rep2 = rep1.replaceAll(">", "&gt;");
        return rep2;
    }

    private void updateDomainText(PolicyElement element) {
        DomainPolicyOutlineDecoratingLabelProvider decoratingLabelProvider = (DomainPolicyOutlineDecoratingLabelProvider)this.domainViewer.getLabelProvider();
        CoreEditorOutlineLabelProvider labelProvider = (CoreEditorOutlineLabelProvider)decoratingLabelProvider.getLabelProvider();
        if (element == null) {
            this.formText.setText("", false, false);
            this.iconLabel.setImage(null);
            return;
        }
        if (element instanceof Domain) {
            Domain domain = (Domain)element;
            this.formText.setText(this.createDomainLink(domain), true, false);
            this.iconLabel.setImage(labelProvider.getImage(element));
            return;
        }
        if (element instanceof AccessPermission) {
            AccessPermission permission = (AccessPermission)element;
            this.formText.setText(permission.getText(), false, false);
            this.iconLabel.setImage(labelProvider.getImage(element));
            return;
        }
        if (element instanceof Profile) {
            Profile profile = (Profile)element;
            this.formText.setText(profile.getLongName(), false, false);
            this.iconLabel.setImage(labelProvider.getImage(element));
            return;
        }
        this.formText.setText("", false, false);
    }

    private TreeViewer createDomainTreeViewer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true, 1, 1);
        container.setLayoutData((Object)data);
        this.createDomainTreeViewerHeaderArea(container);
        TreeViewer viewer = new TreeViewer(container, 2050);
        GridData gd = new GridData(1808);
        gd.heightHint = 50;
        gd.widthHint = 50;
        viewer.getControl().setLayoutData((Object)gd);
        viewer.setLabelProvider(this.createDomainViewerLabelProvider());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DomainPolicyPage.this.handleDomainSelectionChanged((TreeViewer)event.getSource());
            }
        });
        viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                DomainPolicyPage.this.handleTreeExpansionStateChanged((TreeViewer)event.getSource());
            }

            public void treeExpanded(TreeExpansionEvent event) {
                DomainPolicyPage.this.handleTreeExpansionStateChanged((TreeViewer)event.getSource());
            }
        });
        viewer.getControl().addKeyListener((KeyListener)new ViewerExpandCollapseKeyListener(viewer));
        viewer.getControl().addKeyListener((KeyListener)new DomainPolicyViewerKeyListener(this.getProject(), viewer, null, this.dialogObserver));
        viewer.getControl().addMouseListener((MouseListener)new CoreEditorOutlineMouseListener(viewer));
        viewer.getControl().addMouseListener((MouseListener)new DomainPolicyOutlineMouseListener(this.getProject(), viewer));
        viewer.getControl().addFocusListener((FocusListener)new ResourceFormPage.TreeFocusAdapter(viewer));
        viewer.setContentProvider((IContentProvider)new DomainPolicyOutlineContentProvider());
        DomainPolicyOutlineDecoratingLabelProvider decoratingLabelProvider = (DomainPolicyOutlineDecoratingLabelProvider)viewer.getLabelProvider();
        DomainPolicyOutlineLabelProvider labelProvider = (DomainPolicyOutlineLabelProvider)decoratingLabelProvider.getLabelProvider();
        labelProvider.setDomainVerbose(false);
        viewer.setSorter((ViewerSorter)new DomainTransitionTreeAsciiOrderSorter());
        this.setupDomainViewerMenuListener(parent, viewer);
        this.createDomainButtonContoler(container);
        container.setTabList(new Control[]{viewer.getControl()});
        return viewer;
    }

    private boolean checkViewers() {
        if (this.domainViewer == null || this.domainViewer.getControl().isDisposed()) {
            return true;
        }
        return this.accessViewer == null || this.accessViewer.getControl().isDisposed();
    }

    private void refreshViewers() {
        if (this.checkViewers()) {
            return;
        }
        TreePath[] domainTreePaths = this.domainViewer.getExpandedTreePaths();
        StructuredSelection domainSelections = (StructuredSelection)this.domainViewer.getSelection();
        StructuredSelection domainParentSelection = this.getParentSelection(this.domainViewer, domainSelections);
        TreePath[] accessTreePaths = this.accessViewer.getExpandedTreePaths();
        StructuredSelection accessSelections = (StructuredSelection)this.accessViewer.getSelection();
        StructuredSelection accessParentSelection = this.getParentSelection(this.accessViewer, accessSelections);
        this.domainViewer.getTree().setRedraw(false);
        this.domainViewer.setInput(this.createModel());
        this.domainViewer.setExpandedTreePaths(domainTreePaths);
        this.updateSelection(this.domainViewer, domainSelections, domainParentSelection);
        this.domainViewer.getTree().setRedraw(true);
        Domain domain = (Domain)domainSelections.getFirstElement();
        if (domainSelections.getFirstElement() instanceof Domain) {
            this.accessViewer.getTree().setRedraw(false);
            AccessViewerLabelProvider labelProvider = (AccessViewerLabelProvider)this.accessViewer.getLabelProvider();
            labelProvider.inputChanged(domain);
            this.accessViewer.setInput((Object)domain);
            this.accessViewer.setExpandedTreePaths(accessTreePaths);
            this.updateSelection(this.accessViewer, accessSelections, accessParentSelection);
            this.accessViewer.getTree().setRedraw(true);
        }
        this.updateDomainText((PolicyElement)domain);
        this.updateProfileBar(domain);
    }

    private StructuredSelection getParentSelection(TreeViewer treeViewer, StructuredSelection selections) {
        if (selections.getFirstElement() instanceof PolicyElement) {
            PolicyElement firstElement = (PolicyElement)selections.getFirstElement();
            if (treeViewer.getContentProvider() instanceof PolicyOutlineContentProvider) {
                PolicyOutlineContentProvider cProvider = (PolicyOutlineContentProvider)treeViewer.getContentProvider();
                return cProvider.getParentSelection(firstElement);
            }
        }
        return null;
    }

    private void updateSelection(TreeViewer viewer, StructuredSelection selections, StructuredSelection parentSelection) {
        if (selections.getFirstElement() instanceof PolicyElement) {
            PolicyElement firstElement = (PolicyElement)selections.getFirstElement();
            if (PolicyCacheManager.getInstance().exists(this.getProject(), firstElement)) {
                viewer.setSelection((ISelection)selections);
                viewer.reveal(selections.getFirstElement());
            } else if (parentSelection != null) {
                viewer.setSelection((ISelection)parentSelection);
                if (parentSelection.getFirstElement() != null) {
                    viewer.reveal(parentSelection.getFirstElement());
                }
            }
        }
    }

    private void setupDomainViewerMenuListener(Composite parent, TreeViewer viewer) {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)new DomainPolicyOutlineMenuListener(this.getProject(), (StructuredViewer)viewer));
        Menu menu = menuManager.createContextMenu((Control)parent);
        viewer.getTree().setMenu(menu);
    }

    private void handleDomainSelectionChanged(TreeViewer viewer) {
        if (this.checkSameSelection(viewer)) {
            return;
        }
        ISelection selection = viewer.getSelection();
        StructuredSelection selections = (StructuredSelection)selection;
        PolicyElement firstElement = (PolicyElement)selections.getFirstElement();
        this.updateDomainText(firstElement);
        if (selections.size() > 0) {
            this.storeSelection(viewer, selections);
        }
        if (firstElement instanceof Domain) {
            this.updateAccessSelection((Domain)firstElement);
        } else {
            this.updateAccessSelection(null);
        }
    }

    private boolean checkSameSelection(TreeViewer viewer) {
        StructuredSelection selections = this.getPersistentTreeSelection(viewer);
        if (selections == null) {
            return false;
        }
        return selections.getFirstElement() == ((StructuredSelection)viewer.getSelection()).getFirstElement();
    }

    private void handleTreeExpansionStateChanged(TreeViewer viewer) {
        Object[] expandedElements = viewer.getExpandedElements();
        this.storeTreeExpansionState(viewer, expandedElements);
    }

    private void updateAccessSelection(Domain domain) {
        AccessViewerLabelProvider labelProvider = (AccessViewerLabelProvider)this.accessViewer.getLabelProvider();
        labelProvider.inputChanged(domain);
        this.accessViewer.setInput((Object)domain);
        this.accessViewer.refresh(true);
        this.accessViewer.expandAll();
        this.updateProfileBar(domain);
    }

    private void updateProfileBar(Domain domain) {
        if (domain == null || domain.getProfile() == null) {
            this.profileIconLabel.setImage(null);
            this.prifileTextLabel.setText("");
            this.profileIconLabel.setBackground(Activator.getStandardDisplay().getSystemColor(1));
            this.prifileTextLabel.setBackground(Activator.getStandardDisplay().getSystemColor(1));
            this.profileIconLabel.getParent().setBackground(Activator.getStandardDisplay().getSystemColor(1));
        } else {
            Profile profile = domain.getProfile();
            this.profileIconLabel.setImage(Activator.getImage("profile.gif"));
            this.prifileTextLabel.setText(profile.getLongName());
            int groupNo = Integer.parseInt(profile.getNo());
            ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(this.getProject());
            ProfileGroup group = pp.getGroup(groupNo);
            if (group == null) {
                return;
            }
            RGB foreGround = group.getForecolor();
            RGB backGround = group.getBackcolor();
            if (foreGround != null) {
                this.prifileTextLabel.setForeground(Activator.getDefault().getColor(foreGround));
            } else {
                this.prifileTextLabel.setForeground(Activator.getStandardDisplay().getSystemColor(2));
            }
            if (backGround != null) {
                this.profileIconLabel.setBackground(Activator.getDefault().getColor(backGround));
                this.prifileTextLabel.setBackground(Activator.getDefault().getColor(backGround));
                this.profileIconLabel.getParent().setBackground(Activator.getDefault().getColor(backGround));
            } else {
                this.profileIconLabel.setBackground(Activator.getStandardDisplay().getSystemColor(1));
                this.prifileTextLabel.setBackground(Activator.getStandardDisplay().getSystemColor(1));
                this.profileIconLabel.getParent().setBackground(Activator.getStandardDisplay().getSystemColor(1));
            }
        }
    }

    private void createDomainButtonContoler(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.marginLeft = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        GridData data = new GridData(131072, 4, false, true, 1, 1);
        data.horizontalIndent = 0;
        container.setLayoutData((Object)data);
        this.domainExpandButton = this.createButton(container, Activator.getImage("expandall.gif"), 0);
        this.domainExpandButton.setToolTipText(Messages.DomainPolicyPage_ExpandTreeButtonTooltip);
        this.domainCollapseButton = this.createButton(container, Activator.getImage("collapseall.gif"), 0);
        this.domainCollapseButton.setToolTipText(Messages.DomainPolicyPage_CollapseTreeButtonTooltip);
        this.domainChildCountButton = this.createButton(container, Activator.getImage("count.gif"), 2);
        this.domainChildCountButton.setToolTipText(Messages.DomainPolicyPage_ShowAccessPermissionCountButtonTooltip);
        this.coloringButton = this.createButton(container, Activator.getImage("coloring.gif"), 2);
        this.coloringButton.setToolTipText(Messages.DomainPolicyPage_EnableColorDecorationButtonTooltip);
        this.showSearchButton = this.createButton(container, Activator.getImage("search.gif"), 8);
        this.showSearchButton.setToolTipText(Messages.DomainPolicyPage_OpenSearchDialogButtonTooltip);
        this.showCCSTreeButton = this.createButton(container, Activator.getImage("ccstree.gif"), 8);
        this.showCCSTreeButton.setToolTipText(Messages.DomainPolicyPage_OpenProdessTreeDialogButtonTooltip);
    }

    @Override
    protected void handleButtonSelected(Button button) {
        if (button == this.domainChildCountButton) {
            this.showChildDomainCount(button.getSelection());
            this.domainViewer.refresh();
            return;
        }
        if (button == this.coloringButton) {
            this.setDomainColoringEnabled(button.getSelection());
            this.domainViewer.refresh();
            if (button.getSelection()) {
                this.showColoringDialog();
            }
            return;
        }
        if (button == this.showSearchButton) {
            this.handleSearchDomain();
            return;
        }
        if (button == this.showCCSTreeButton) {
            CcsTreeDialog dialog = new CcsTreeDialog(Activator.getStandardDisplay().getActiveShell(), this.getProject());
            dialog.setParent(this);
            dialog.open();
            return;
        }
        if (button == this.domainExpandButton) {
            this.expandTree(this.domainViewer);
        }
        if (button == this.domainCollapseButton) {
            this.collapseTree(this.domainViewer, 2);
        }
        if (button == this.accessChildCountButton) {
            this.showChildACLCount(button.getSelection());
            this.domainViewer.refresh();
            return;
        }
        if (button == this.accessElementOrderButton) {
            this.setAccessViewerElementOrder(button.getSelection());
            this.accessPathOrderButton.setSelection(!button.getSelection());
        }
        if (button == this.accessPathOrderButton) {
            this.setAccessViewerElementOrder(!button.getSelection());
            this.accessElementOrderButton.setSelection(!button.getSelection());
        }
        if (button == this.accessAscendButton) {
            this.setAccessViewerOrientation(button.getSelection());
        }
        if (button == this.accessExpandButton) {
            this.expandTree(this.accessViewer);
        }
        if (button == this.accessCollapseButton) {
            this.collapseTree(this.accessViewer, 0);
        }
    }

    private void showColoringDialog() {
        ColoringDialog dialog = new ColoringDialog(Activator.getStandardDisplay().getActiveShell(), this.getProject());
        dialog.addObserver(new ColoringDialogObserver());
        dialog.open();
    }

    private TreeViewer createAccessTreeViewer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true, 2, 1);
        container.setLayoutData((Object)data);
        this.createAccessTreeViewerHeaderArea(container);
        TreeViewer viewer = new TreeViewer(container, 2050);
        GridData gd = new GridData(1808);
        gd.heightHint = 50;
        gd.widthHint = 50;
        viewer.getControl().setLayoutData((Object)gd);
        AccessControlViewerContentProvider contentProvider = new AccessControlViewerContentProvider();
        viewer.setContentProvider((IContentProvider)contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new AccessViewerLabelProvider(this.getProject()));
        viewer.setSorter((ViewerSorter)this.createAccessControlSorter());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeViewer viewer = (TreeViewer)event.getSource();
                ISelection selection = viewer.getSelection();
                StructuredSelection selections = (StructuredSelection)selection;
                if (selections.size() > 0) {
                    DomainPolicyPage.this.storeSelection(viewer, selections);
                }
            }
        });
        viewer.getControl().addKeyListener((KeyListener)new ViewerExpandCollapseKeyListener(viewer));
        viewer.getControl().addKeyListener((KeyListener)new DomainPolicyViewerKeyListener(this.getProject(), this.domainViewer, viewer, null));
        viewer.getControl().addMouseListener((MouseListener)new CoreEditorOutlineMouseListener(viewer));
        viewer.getControl().addFocusListener((FocusListener)new ResourceFormPage.TreeFocusAdapter(viewer));
        this.setupAccessViewerMenuListener(parent, viewer);
        this.createAccessButtonContoler(container);
        container.setTabList(new Control[]{viewer.getControl()});
        return viewer;
    }

    private void setupAccessViewerMenuListener(Composite parent, TreeViewer viewer) {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)new AccessPermissionOutlineMenuListener(this.getProject(), (StructuredViewer)viewer));
        Menu menu = menuManager.createContextMenu((Control)parent);
        viewer.getTree().setMenu(menu);
    }

    private Composite createAccessTreeViewerHeaderArea(Composite parent) {
        Composite container = this.getManagedForm().getToolkit().createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        gd.horizontalSpan = 2;
        container.setLayoutData((Object)gd);
        this.profileIconLabel = this.getManagedForm().getToolkit().createLabel(container, null);
        this.profileIconLabel.setLayoutData((Object)new GridData(1));
        this.prifileTextLabel = this.getManagedForm().getToolkit().createLabel(container, null);
        this.prifileTextLabel.setLayoutData((Object)new GridData(768));
        return container;
    }

    private void expandTree(TreeViewer viewer) {
        viewer.getTree().setRedraw(false);
        viewer.expandAll();
        viewer.setSelection((ISelection)this.getPersistentTreeSelection(viewer));
        viewer.getTree().setRedraw(true);
    }

    private void collapseTree(TreeViewer viewer, int level) {
        viewer.getTree().setRedraw(false);
        viewer.collapseAll();
        if (level > 0) {
            viewer.expandToLevel(level);
        }
        viewer.getTree().setRedraw(true);
    }

    private void storeSelection(TreeViewer viewer, StructuredSelection selections) {
        viewer.setData("PersistentSelection", (Object)selections);
    }

    private void storeTreeExpansionState(TreeViewer viewer, Object[] expandedElements) {
        viewer.setData("PersistentExpansionState", (Object)expandedElements);
    }

    private StructuredSelection getPersistentTreeSelection(TreeViewer viewer) {
        StructuredSelection selections = (StructuredSelection)viewer.getData("PersistentSelection");
        return selections;
    }

    public void setSelection(String domain) {
        Domain cacheDomain = PolicyCacheManager.getInstance().findDomain(this.getProject(), domain);
        this.setSelection(cacheDomain);
    }

    public void setSelection(Domain domain) {
        if (domain == null) {
            return;
        }
        this.setSelection(this.domainViewer, (PolicyElement)domain);
    }

    @Override
    protected void setSelection(TreeViewer viewer, PolicyElement element) {
        super.setSelection(viewer, element);
        if (viewer == null) {
            return;
        }
        StructuredSelection selection = new StructuredSelection((Object)element);
        this.storeSelection(viewer, selection);
    }

    private void createAccessButtonContoler(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.marginLeft = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        GridData data = new GridData(131072, 4, false, true, 1, 1);
        data.horizontalIndent = 0;
        container.setLayoutData((Object)data);
        this.accessExpandButton = this.createButton(container, Activator.getImage("expandall.gif"), 0);
        this.accessExpandButton.setToolTipText(Messages.DomainPolicyPage_ExpandTreeButtonTooltip);
        this.accessCollapseButton = this.createButton(container, Activator.getImage("collapseall.gif"), 0);
        this.accessCollapseButton.setToolTipText(Messages.DomainPolicyPage_CollapseTreeButtonTooltip);
        this.accessChildCountButton = this.createButton(container, Activator.getImage("count.gif"), 2);
        this.accessChildCountButton.setToolTipText(Messages.DomainPolicyPage_ShowDirectiveAccessPermissionCountButtonTooltip);
        this.accessAscendButton = this.createButton(container, Activator.getImage("sort_asc.gif"), 2);
        this.accessAscendButton.setToolTipText(Messages.DomainPolicyPage_SortButtonTooltip);
    }

    private void setAccessViewerTreeStyle(boolean b) {
        AccessControlViewerContentProvider contentProvider = (AccessControlViewerContentProvider)this.accessViewer.getContentProvider();
        contentProvider.setTreeStyle(b);
        DomainPolicyOutlineLabelProvider labelProvider = (DomainPolicyOutlineLabelProvider)this.accessViewer.getLabelProvider();
        labelProvider.setAccessControlVerbose(!b);
        this.accessViewer.refresh(true);
        if (this.accessExpandButton.getSelection()) {
            this.accessViewer.expandAll();
        }
    }

    private void setAccessViewerElementOrder(boolean b) {
        this.accessSorter.setElementOrder(b);
        this.accessViewer.refresh(true);
    }

    private void setAccessViewerOrientation(boolean b) {
        this.accessSorter.setOrientation(b);
        this.accessViewer.refresh();
    }

    private void setDomainColoringEnabled(boolean b) {
        DomainPolicyOutlineDecoratingLabelProvider decoratingLabelProvider = (DomainPolicyOutlineDecoratingLabelProvider)this.domainViewer.getLabelProvider();
        DomainPolicyOutlineLabelProvider labelProvider = (DomainPolicyOutlineLabelProvider)decoratingLabelProvider.getLabelProvider();
        labelProvider.setColoringEnabled(b);
    }

    private void showChildDomainCount(boolean selection) {
        DomainPolicyOutlineDecoratingLabelProvider decoratingLabelProvider = (DomainPolicyOutlineDecoratingLabelProvider)this.domainViewer.getLabelProvider();
        DomainPolicyOutlineLabelProvider labelProvider = (DomainPolicyOutlineLabelProvider)decoratingLabelProvider.getLabelProvider();
        labelProvider.showResourceCount(selection);
    }

    private void showChildACLCount(boolean selection) {
        AccessViewerLabelProvider lavelProvider = (AccessViewerLabelProvider)this.accessViewer.getLabelProvider();
        lavelProvider.showChildACLCount(selection);
        this.accessViewer.refresh();
    }

    private AccessControlSorter createAccessControlSorter() {
        if (this.accessSorter == null) {
            this.accessSorter = new AccessControlSorter();
        }
        return this.accessSorter;
    }

    protected Object createModel() {
        DomainPolicy domainPolicy = ProcResourceManager.getInstance().getProcResourceSet(this.getProject()).getDomainPolicy();
        return domainPolicy.getModel();
    }

    private IBaseLabelProvider createDomainViewerLabelProvider() {
        DomainPolicyOutlineLabelProvider labelProvider = new DomainPolicyOutlineLabelProvider(this.getProject());
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        return new DomainPolicyOutlineDecoratingLabelProvider((ILabelProvider)labelProvider, decorator);
    }

    private void handleSearchDomain() {
        DomainSearchDialog dialog = DomainSearchDialog.getInstance(Activator.getStandardDisplay().getActiveShell());
        this.dialogObserver.setDialog(dialog);
        this.dialogObserver.setViewer(this.domainViewer);
        dialog.open();
    }

    public void notifySelectionChanged(ISelection selection) {
    }

    @Override
    public void notifyPageChanged(PlainFormPage editorPage) {
        super.notifyPageChanged(editorPage);
        if (this.needToRefreshViewer) {
            this.refreshViewers();
            this.needToRefreshViewer = false;
        }
    }

    @Override
    protected void notifyPolicyUpdated(IProject project, LocalResource localResource) {
        super.notifyPolicyUpdated(project, localResource);
        if (project == this.getProject()) {
            if (localResource instanceof DomainPolicy) {
                if (this.domainViewer.getTree().isVisible()) {
                    this.refreshViewers();
                } else {
                    this.needToRefreshViewer = true;
                }
            }
            if (localResource instanceof ExceptPolicy) {
                if (this.domainViewer.getTree().isVisible()) {
                    this.refreshViewers();
                } else {
                    this.needToRefreshViewer = true;
                }
            }
        }
    }

    @Override
    protected void notifyProfileUpdated(IProject project) {
        if (!this.checkWidgets()) {
            return;
        }
        if (project == this.getProject()) {
            this.domainViewer.refresh();
        }
    }

    @Override
    protected String getHelpPath() {
        return "/jp.sourceforge.tomoyo.doc/html/page-domain.html";
    }

    private class DomainPolicyOutlineMenuListener
    extends PolicyOutlineMenuListener {
        public DomainPolicyOutlineMenuListener(IProject project, StructuredViewer viewer) {
            super(project, viewer);
        }

        @Override
        public void menuAboutToShow(IMenuManager manager) {
            IStructuredSelection selection;
            Domain domain = null;
            String domainText = null;
            boolean withSuffix = true;
            if (!this.getSelection(this.viewer).isEmpty() && (selection = this.getSelection(this.viewer)).getFirstElement() instanceof Domain) {
                domain = (Domain)selection.getFirstElement();
                domainText = domain.getText();
            }
            Action workAction = null;
            workAction = this.createCreateDomainAction(domainText, withSuffix);
            workAction.setEnabled(this.getSelection(this.viewer).size() == 1);
            manager.add((IAction)workAction);
            manager.add((IContributionItem)new Separator());
            workAction = this.createCreateAccessPermissionAction(domain, null);
            workAction.setEnabled(this.getSelection(this.viewer).size() == 1);
            manager.add((IAction)workAction);
            manager.add((IContributionItem)new Separator());
            super.menuAboutToShow(manager);
        }
    }

    private class ColoringDialogObserver
    implements Observer {
        private ColoringDialogObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            DomainPolicyPage.this.domainViewer.refresh();
        }
    }

    private class AccessPermissionOutlineMenuListener
    extends PolicyOutlineMenuListener {
        public AccessPermissionOutlineMenuListener(IProject project, StructuredViewer viewer) {
            super(project, viewer);
        }

        @Override
        public void menuAboutToShow(IMenuManager manager) {
            Domain domain = null;
            IStructuredSelection domainSelection = this.getSelection((StructuredViewer)DomainPolicyPage.this.domainViewer);
            IStructuredSelection accessSelection = this.getSelection(this.viewer);
            if (accessSelection.isEmpty()) {
                if (domainSelection.getFirstElement() instanceof Domain) {
                    domain = (Domain)domainSelection.getFirstElement();
                    manager.add((IAction)this.createCreateAccessPermissionAction(domain, null));
                    manager.add((IContributionItem)new Separator());
                }
            } else if (accessSelection.getFirstElement() instanceof AccessPermission) {
                AccessPermission access = (AccessPermission)accessSelection.getFirstElement();
                if (access.getParent() instanceof Domain) {
                    domain = (Domain)access.getParent();
                }
                manager.add((IAction)this.createCreateAccessPermissionAction(domain, access.getText()));
                manager.add((IContributionItem)new Separator());
            } else if (accessSelection.getFirstElement() instanceof PolicyElementDefinition) {
                PolicyElementDefinition definition = (PolicyElementDefinition)accessSelection.getFirstElement();
                if (domainSelection.getFirstElement() instanceof Domain) {
                    domain = (Domain)domainSelection.getFirstElement();
                    manager.add((IAction)this.createCreateAccessPermissionAction(domain, definition.getDirectiveName()));
                    manager.add((IContributionItem)new Separator());
                }
            }
            super.menuAboutToShow(manager);
        }
    }

    private class AccessControlSorter
    extends ViewerSorter
    implements Comparator<Object> {
        private boolean elementOrder = false;
        private boolean ascend = false;

        public void setElementOrder(boolean b) {
            this.elementOrder = b;
        }

        public void setOrientation(boolean b) {
            this.ascend = b;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.compare(e1, e2);
        }

        @Override
        public int compare(Object e1, Object e2) {
            String text2;
            String text1;
            if (e1 instanceof Profile) {
                return 1;
            }
            if (e2 instanceof Profile) {
                return -1;
            }
            if (e1 instanceof PolicyElementDefinition) {
                PolicyElementDefinition def1 = (PolicyElementDefinition)e1;
                PolicyElementDefinition def2 = (PolicyElementDefinition)e2;
                String text12 = def1.getDirectiveName();
                String text22 = def2.getDirectiveName();
                return text12.compareTo(text22);
            }
            if (e1 instanceof PolicyElement) {
                PolicyElement element1 = (PolicyElement)e1;
                PolicyElement element2 = (PolicyElement)e2;
                if (this.elementOrder) {
                    text1 = element1.getText();
                    text2 = element2.getText();
                } else {
                    text1 = element1.getTextFrom(1);
                    text2 = element2.getTextFrom(1);
                }
            } else {
                return 0;
            }
            if (this.ascend) {
                return text1.compareTo(text2);
            }
            return text2.compareTo(text1);
        }
    }

    public class AccessControlViewerContentProvider
    implements ITreeContentProvider {
        private boolean deletedVisible = false;
        private boolean treeStyle = false;
        private Object newInput;

        public void setDeletedVisible(boolean b) {
            this.deletedVisible = b;
        }

        public void setTreeStyle(boolean b) {
            this.treeStyle = b;
        }

        public Object[] getChildren(Object parent) {
            if (this.treeStyle) {
                return this.getChildren_treeStyle(parent);
            }
            return this.getChildren_textStyle(parent);
        }

        protected Object[] getChildren_treeStyle(Object parent) {
            PolicyElement child;
            int cnt;
            ArrayList<Object> children = new ArrayList<Object>();
            if (parent instanceof Domain) {
                Domain domain = (Domain)parent;
                Hashtable<String, PolicyElementDefinition> definitionTable = new Hashtable<String, PolicyElementDefinition>();
                cnt = 0;
                while (cnt < domain.getChildrenCount()) {
                    String directive;
                    child = domain.getChild(cnt);
                    if (!child.isDeleted() && !(child instanceof Profile) && definitionTable.get(directive = child.getDirective()) == null) {
                        definitionTable.put(directive, DomainPolicyPage.this.getLocalResource().getModel().getDefinitionByDirective(directive));
                    }
                    ++cnt;
                }
                children.addAll(definitionTable.values());
            }
            if (parent instanceof PolicyElementDefinition) {
                PolicyElementDefinition definition = (PolicyElementDefinition)parent;
                if (this.newInput instanceof Domain) {
                    Domain domain = (Domain)this.newInput;
                    cnt = 0;
                    while (cnt < domain.getChildrenCount()) {
                        child = domain.getChild(cnt);
                        if (definition.isInstance(child)) {
                            if (child.isDeleted()) {
                                if (this.deletedVisible) {
                                    children.add(child);
                                }
                            } else {
                                children.add(child);
                            }
                        }
                        ++cnt;
                    }
                }
            }
            return children.toArray();
        }

        protected Object[] getChildren_textStyle(Object parent) {
            ArrayList<PolicyElement> children = new ArrayList<PolicyElement>();
            if (parent instanceof PolicyElement) {
                PolicyElement element = (PolicyElement)parent;
                int cnt = 0;
                while (cnt < element.getChildrenCount()) {
                    PolicyElement child = element.getChild(cnt);
                    if (!child.isDeleted()) {
                        children.add(child);
                    } else if (this.deletedVisible) {
                        children.add(child);
                    }
                    ++cnt;
                }
            }
            return children.toArray();
        }

        public boolean hasChildren(Object obj) {
            return this.getChildren(obj).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object obj) {
            if (obj instanceof PolicyElement) {
                PolicyElement element = (PolicyElement)obj;
                return element.getParent();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.newInput = newInput;
        }
    }

    private class AccessViewerLabelProvider
    extends DomainPolicyOutlineLabelProvider {
        private Domain inputDomain;
        private boolean showChildACLCount;

        public AccessViewerLabelProvider(IProject project) {
            super(project);
            this.showChildACLCount = false;
        }

        @Override
        public String getText(Object object) {
            if (object instanceof PolicyElementDefinition) {
                PolicyElementDefinition definition = (PolicyElementDefinition)object;
                int count = PolicyCacheManager.getInstance().count(this.project, this.inputDomain, definition.getElementClass(), false);
                String directiveName = definition.getDirectiveName();
                if (this.showChildACLCount) {
                    return String.valueOf(directiveName) + " " + "(" + count + ")";
                }
                return directiveName;
            }
            return super.getText(object);
        }

        public void inputChanged(Domain inputDomain) {
            this.inputDomain = inputDomain;
        }

        public void showChildACLCount(boolean b) {
            this.showChildACLCount = b;
        }
    }
}

