/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.form.domain;

import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.MimicCUIEditorKeyListener;
import jp.sourceforge.tomoyo.ui.editor.dialog.NewAccessPermissionDialog;
import jp.sourceforge.tomoyo.ui.editor.form.domain.DomainSearchDialog;
import jp.sourceforge.tomoyo.ui.editor.form.domain.DomainSearchDialogObserver;
import jp.sourceforge.tomoyo.ui.editor.form.domain.Messages;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyActions;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;

public class DomainPolicyViewerKeyListener
extends MimicCUIEditorKeyListener {
    private TreeViewer domainViewer;
    private TreeViewer accessViewer;
    private DomainSearchDialog dialog;
    private DomainSearchDialogObserver observer;

    public DomainPolicyViewerKeyListener(IProject project, TreeViewer domainViewer, TreeViewer accessViewer, DomainSearchDialogObserver observer) {
        super(project);
        this.domainViewer = domainViewer;
        this.accessViewer = accessViewer;
        this.observer = observer;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        if ((e.keyCode == 0x100000B || (e.stateMask & 0x40000) != 0 && e.keyCode == 102) && this.observer != null) {
            this.dialog = DomainSearchDialog.getInstance(Activator.getStandardDisplay().getActiveShell());
            this.observer.setDialog(this.dialog);
            this.observer.setViewer(this.domainViewer);
            this.dialog.open();
        }
        if (e.keyCode == 0x100000C && this.observer != null) {
            this.observer.notifySearchConditionChanged(true);
        }
        if (e.keyCode == 0x100000D && this.observer != null) {
            this.observer.notifySearchConditionChanged(false);
        }
        int cfr_ignored_0 = e.keyCode;
        if (e.keyCode == 13) {
            this.handleEnter();
        }
    }

    private boolean isDomainViewer() {
        return this.domainViewer != null && this.accessViewer == null;
    }

    private boolean isAccessViewer() {
        return this.domainViewer != null && this.accessViewer != null && this.domainViewer != this.accessViewer;
    }

    private boolean isCustomViewer() {
        return this.domainViewer != null && this.accessViewer != null && this.domainViewer == this.accessViewer;
    }

    @Override
    protected void handleAdd() {
        NewAccessPermissionDialog dialog;
        Domain domain;
        AccessPermission accessPermission;
        if (this.isDomainViewer() && this.isDomainOnly(this.getSelection((StructuredViewer)this.domainViewer))) {
            this._addAccessPermission();
        }
        if (this.isAccessViewer()) {
            if (this.isAccessPermissionOnly(this.getSelection((StructuredViewer)this.accessViewer))) {
                accessPermission = (AccessPermission)this.getSelection((StructuredViewer)this.accessViewer).getFirstElement();
                if (accessPermission == null) {
                    return;
                }
                domain = (Domain)accessPermission.getParent();
                if (domain == null) {
                    return;
                }
                dialog = new NewAccessPermissionDialog(Activator.getStandardDisplay().getActiveShell(), this.project, domain, String.valueOf(accessPermission.getDirective()) + " ");
                dialog.open();
            }
            if (this.getSelection((StructuredViewer)this.accessViewer).isEmpty()) {
                this._addAccessPermission();
            }
        }
        if (this.isCustomViewer()) {
            if (this.isDomainOnly(this.getSelection((StructuredViewer)this.accessViewer))) {
                Domain domain2 = (Domain)this.getSelection((StructuredViewer)this.accessViewer).getFirstElement();
                NewAccessPermissionDialog dialog2 = new NewAccessPermissionDialog(Activator.getStandardDisplay().getActiveShell(), this.project, domain2, null);
                dialog2.open();
            }
            if (this.isAccessPermissionOnly(this.getSelection((StructuredViewer)this.accessViewer))) {
                accessPermission = (AccessPermission)this.getSelection((StructuredViewer)this.accessViewer).getFirstElement();
                if (accessPermission == null) {
                    return;
                }
                domain = (Domain)accessPermission.getParent();
                if (domain == null) {
                    return;
                }
                dialog = new NewAccessPermissionDialog(Activator.getStandardDisplay().getActiveShell(), this.project, domain, String.valueOf(accessPermission.getDirective()) + " ");
                dialog.open();
            }
        }
    }

    private void _addAccessPermission() {
        IStructuredSelection selection = this.getSelection((StructuredViewer)this.domainViewer);
        if (selection.size() == 1 && selection.getFirstElement() instanceof Domain) {
            Domain domain = (Domain)selection.getFirstElement();
            this.createCreateAccessPermissionAction(domain, null).run();
        }
    }

    @Override
    protected void handleDelete() {
        if (this.isDomainViewer()) {
            this._deleteDomain();
        }
        if (this.isAccessViewer()) {
            this._deleteAccess();
        }
        if (this.isCustomViewer()) {
            this._deleteDomain();
            this._deleteAccess();
        }
    }

    private void _deleteDomain() {
        IStructuredSelection selection = this.getSelection((StructuredViewer)this.domainViewer);
        if (this.areDomainsOnly(selection)) {
            this.createDeleteDomainAction(this.toDomainArray(selection)).run();
        }
    }

    private void _deleteAccess() {
        if (this.areAccessPermissionsOnly(this.getSelection((StructuredViewer)this.accessViewer), true)) {
            AccessPermission[] apArray = this.toAccessPermissionArray(this.getSelection((StructuredViewer)this.accessViewer));
            boolean b = MessageDialog.openQuestion((Shell)Activator.getStandardDisplay().getActiveShell(), (String)Messages.DomainPolicyPage_DeleteAPConfirmTitle, (String)Messages.DomainPolicyPage_DeleteAPConfirmMessage);
            if (b) {
                (PolicyActions)this.new PolicyActions.DeleteAccessPermissionAction((PolicyElement[])apArray).run();
            }
        }
    }

    @Override
    protected void handleInsert() {
        if (this.isDomainViewer() && this.isDomainOnly(this.getSelection((StructuredViewer)this.domainViewer))) {
            this._addDomain(false, true);
        }
        if (this.isAccessViewer()) {
            if (this.isAccessPermissionOnly(this.getSelection((StructuredViewer)this.accessViewer))) {
                this.handleAdd();
            }
            if (this.getSelection((StructuredViewer)this.accessViewer).isEmpty()) {
                this._addAccessPermission();
            }
        }
        if (this.isCustomViewer()) {
            if (this.isDomainOnly(this.getSelection((StructuredViewer)this.accessViewer))) {
                this._addDomain(false, true);
            }
            if (this.isAccessPermissionOnly(this.getSelection((StructuredViewer)this.accessViewer))) {
                this.handleAdd();
            }
        }
    }

    @Override
    protected void handleCopy() {
        if (this.isDomainViewer() && this.isDomainOnly(this.getSelection((StructuredViewer)this.domainViewer))) {
            this._addDomain(true, false);
        }
        if (this.isAccessViewer()) {
            this._copy();
        }
        if (this.isCustomViewer()) {
            if (this.isDomainOnly(this.getSelection((StructuredViewer)this.accessViewer))) {
                this._addDomain(true, false);
            }
            if (this.isAccessPermissionOnly(this.getSelection((StructuredViewer)this.accessViewer))) {
                this._copy();
            }
        }
    }

    private void _copy() {
        if (this.isAccessPermissionOnly(this.getSelection((StructuredViewer)this.accessViewer))) {
            AccessPermission accessPermission = (AccessPermission)this.getSelection((StructuredViewer)this.accessViewer).getFirstElement();
            if (accessPermission == null) {
                return;
            }
            Domain domain = (Domain)accessPermission.getParent();
            if (domain == null) {
                return;
            }
            NewAccessPermissionDialog dialog = new NewAccessPermissionDialog(Activator.getStandardDisplay().getActiveShell(), this.project, domain, accessPermission.getText());
            dialog.open();
        }
    }

    private void _addDomain(boolean isSelectedBased, boolean withSuffix) {
        String argDomainText = null;
        IStructuredSelection selection = this.getSelection((StructuredViewer)this.domainViewer);
        if (selection.getFirstElement() instanceof Domain) {
            Domain domain = (Domain)selection.getFirstElement();
            argDomainText = isSelectedBased ? domain.getText() : domain.getText2(domain.getDepth() - 1);
        }
        this.createCreateDomainAction(argDomainText, withSuffix).run();
    }

    @Override
    protected void handleSetProfile() {
        IStructuredSelection selection = this.getSelection((StructuredViewer)this.domainViewer);
        if (this.areDomainsOnly(selection)) {
            Domain[] domainArray = this.toDomainArray(selection);
            this.createChangeProfileAction(domainArray).run();
        }
    }

    @Override
    protected void handleRefresh() {
        DomainPolicy localResource = ProcResourceManager.getInstance().getProcResourceSet(this.project).getDomainPolicy();
        boolean syncOK = ProcResourceManager.getInstance().synchronize(this.project, (LocalResource)localResource);
        if (syncOK) {
            // empty if block
        }
    }

    @Override
    protected LocalResource _getRefreshingLocalResource() {
        DomainPolicy localResource = ProcResourceManager.getInstance().getProcResourceSet(this.project).getDomainPolicy();
        return localResource;
    }

    @Override
    protected void handleFindNext() {
        if (this.observer != null) {
            this.observer.notifySearchConditionChanged(true);
        }
    }

    @Override
    protected void handleFindPrevious() {
        if (this.observer != null) {
            this.observer.notifySearchConditionChanged(false);
        }
    }

    private void handleEnter() {
        AccessPermission permission;
        if (this.isInitializingOnly(this.getSelection((StructuredViewer)this.domainViewer)) && (permission = (AccessPermission)this.getSelection((StructuredViewer)this.domainViewer).getFirstElement()).isInitializedSource()) {
            String processName = permission.getContents();
            Domain foundDomain = PolicyCacheManager.getInstance().getInitializerTarget(this.project, processName);
            if (foundDomain == null) {
                return;
            }
            this.domainViewer.setSelection((ISelection)new StructuredSelection((Object)foundDomain));
        }
    }

    protected boolean isInitializingOnly(IStructuredSelection selection) {
        if (selection.size() == 1 && selection.getFirstElement() instanceof AccessPermission) {
            AccessPermission permission = (AccessPermission)selection.getFirstElement();
            return permission.isInitializedSource();
        }
        return false;
    }
}

