/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.form.domain;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.form.domain.Messages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class DomainSearchDialog
extends TitleAreaDialog
implements ModifyListener,
SelectionListener {
    private static DomainSearchDialog instance;
    private TableViewer historyViewer;
    private Combo searchCombo;
    private Button upwardButton;
    private Button downwardButton;
    private Button matchExecFullPathButton;
    private Button matchExecPathButton;
    private Button includeButton;
    private Hashtable<Object, Button> buttonStore = new Hashtable();
    private Button searchButton;
    private Observable observable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            super.setChanged();
            super.notifyObservers(arg);
        }
    };
    private static final String KEY_SEARCH_TEXT_HISTORY = "search.text2";
    private static final String KEY_SEARCH_TYPE_HISTORY = "search.type2";

    public static DomainSearchDialog getInstance(Shell parentShell) {
        if (instance == null) {
            instance = new DomainSearchDialog(parentShell);
        }
        return instance;
    }

    private DomainSearchDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.DomainSearchDialog_ShellTitle);
    }

    protected int getShellStyle() {
        return 1264;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.DomainSearchDialog_DialogTitle);
        this.setTitleImage(Activator.getImage("search_wiz.gif"));
        this.setMessage(Messages.DomainSearchDialog_DialogMessage);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setLayout((Layout)new GridLayout());
        innerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createRegularSearchComposite(innerComposite);
        this.createHistorySearchComposite(innerComposite);
        this.restoreDefault();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "jp.sourceforge.tomoyo.doc.open_search_domain");
        return composite;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            return super.createButton(parent, id, Messages.DomainSearchDialog_CloseButtonText, defaultButton);
        }
        return null;
    }

    protected Control createRegularSearchComposite(Composite parent) {
        Group container = new Group(parent, 0);
        container.setText(Messages.DomainSearchDialog_NormalSearchSectionTitle);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createSearchCombo((Composite)container);
        this.createGroups((Composite)container);
        this.createSearchButton((Composite)container);
        return container;
    }

    private Control createHistorySearchComposite(Composite parent) {
        Group container = new Group(parent, 0);
        container.setText(Messages.DomainSearchDialog_HistorySearchSectionTitle);
        container.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.historyViewer = new TableViewer((Composite)container, 2048);
        Table table = this.historyViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(Messages.DomainSearchDialog_ColumnSearchKeyword);
        column.setWidth(300);
        column.setAlignment(16384);
        column = new TableColumn(table, 16384);
        column.setText(Messages.DomainSearchDialog_ColumnSearchMethod);
        column.setWidth(200);
        column.setAlignment(16384);
        this.historyViewer.setContentProvider((IContentProvider)new HistoryViewerContentProvider());
        this.historyViewer.setLabelProvider((IBaseLabelProvider)new HistoryViewerLabelProvider());
        this.historyViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DomainSearchDialog.this.handleViewerDoubleClick(event);
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 200;
        this.historyViewer.getControl().setLayoutData((Object)gridData);
        return container;
    }

    private void restoreDefault() {
        this.restoreHistory();
        if (this.searchCombo.getItemCount() > 0) {
            String lastKeyword = this.searchCombo.getItem(0);
            this.searchCombo.setText(lastKeyword);
        }
        this.historyViewer.setInput((Object)this.searchCombo);
        this.downwardButton.setSelection(true);
        this.matchExecFullPathButton.setSelection(true);
        this.searchButton.setFocus();
    }

    public int open() {
        return super.open();
    }

    private void createSearchCombo(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        container.setLayoutData((Object)data);
        Label searchLabel = new Label(container, 0);
        searchLabel.setText(Messages.DomainSearchDialog_SearchLabelText);
        this.searchCombo = new Combo(container, 0);
        this.searchCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.searchCombo.addModifyListener((ModifyListener)this);
    }

    private void createGroups(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        container.setLayoutData((Object)data);
        this.createOrientationGroup(container);
        this.createMatchingStrategyGroup(container);
    }

    private void createOrientationGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.DomainSearchDialog_SearchOrientationGroupText);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        this.upwardButton = new Button((Composite)group, 16);
        this.upwardButton.setText(Messages.DomainSearchDialog_SearchOrientationUpwardText);
        this.downwardButton = new Button((Composite)group, 16);
        this.downwardButton.setText(Messages.DomainSearchDialog_SearchOrientationDownwardText);
    }

    private void createMatchingStrategyGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.DomainSearchDialog_MatchingStrategyGroupText);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        this.matchExecFullPathButton = new Button((Composite)group, 16);
        this.matchExecFullPathButton.setText(Messages.DomainSearchDialog_MatchingStrategyFullPathText);
        this.matchExecFullPathButton.setData((Object)"fullpath");
        this.matchExecPathButton = new Button((Composite)group, 16);
        this.matchExecPathButton.setText(Messages.DomainSearchDialog_MatchingStrategyExecPathText);
        this.matchExecPathButton.setData((Object)"execpath");
        this.includeButton = new Button((Composite)group, 16);
        this.includeButton.setText(Messages.DomainSearchDialog_MatchingStrategyIncludeText);
        this.includeButton.setData((Object)"includes");
        this.buttonStore.put(this.matchExecFullPathButton.getData(), this.matchExecFullPathButton);
        this.buttonStore.put(this.matchExecPathButton.getData(), this.matchExecPathButton);
        this.buttonStore.put(this.includeButton.getData(), this.includeButton);
    }

    private void createSearchButton(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        container.setLayoutData((Object)data);
        Label spacer = new Label(container, 0);
        spacer.setLayoutData((Object)new GridData(4, 4, true, false));
        this.searchButton = new Button(container, 0);
        this.searchButton.setText(Messages.DomainSearchDialog_SearchButtonText);
        GridData layoutData = new GridData();
        layoutData.widthHint = 150;
        this.searchButton.setLayoutData((Object)layoutData);
        this.searchButton.addSelectionListener((SelectionListener)this);
    }

    protected Point getInitialSize() {
        return new Point(600, 500);
    }

    public void addObserver(Observer o) {
        this.observable.addObserver(o);
    }

    public void modifyText(ModifyEvent e) {
        this.searchButton.setEnabled(this.searchCombo.getText().trim().length() > 0);
    }

    private void handleViewerDoubleClick(DoubleClickEvent event) {
        TableViewer viewer = (TableViewer)event.getViewer();
        StructuredSelection selection = (StructuredSelection)viewer.getSelection();
        if (selection.size() == 1) {
            String[] strArr = (String[])selection.getFirstElement();
            Hashtable<String, Object> table = new Hashtable<String, Object>();
            table.put("search", strArr[0]);
            table.put("method", strArr[1]);
            table.put("orient", this.upwardButton.getSelection());
            this.observable.notifyObservers(table);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        String text = this.searchCombo.getText();
        String type = null;
        table.put("search", text);
        if (this.matchExecFullPathButton.getSelection()) {
            type = (String)this.matchExecFullPathButton.getData();
        }
        if (this.matchExecPathButton.getSelection()) {
            type = (String)this.matchExecPathButton.getData();
        }
        if (this.includeButton.getSelection()) {
            type = (String)this.includeButton.getData();
        }
        table.put("method", type);
        table.put("orient", this.upwardButton.getSelection());
        this.observable.notifyObservers(table);
        this.storeHistory(text, type);
        this.historyViewer.setInput((Object)this.searchCombo);
    }

    private void storeHistory(String text, String type) {
        String[] typeDest;
        String[] textDest;
        if (this.hasHistory(text, type)) {
            return;
        }
        String[] textSrc = this.searchCombo.getItems();
        String[] typeSrc = (String[])this.searchCombo.getData();
        if (typeSrc == null) {
            typeSrc = new String[]{};
        }
        if (this.searchCombo.getItemCount() > 9) {
            textDest = new String[10];
            textDest[0] = text;
            System.arraycopy(textSrc, 0, textDest, 1, 9);
            typeDest = new String[10];
            typeDest[0] = type;
            System.arraycopy(typeSrc, 0, typeDest, 1, 9);
        } else {
            textDest = new String[this.searchCombo.getItemCount() + 1];
            textDest[0] = text;
            System.arraycopy(textSrc, 0, textDest, 1, this.searchCombo.getItemCount());
            typeDest = new String[this.searchCombo.getItemCount() + 1];
            typeDest[0] = type;
            System.arraycopy(typeSrc, 0, typeDest, 1, this.searchCombo.getItemCount());
        }
        IDialogSettings settings = Activator.getDefault().getDialogSettings(((Object)((Object)this)).getClass().getName());
        settings.put(KEY_SEARCH_TEXT_HISTORY, textDest);
        settings.put(KEY_SEARCH_TYPE_HISTORY, typeDest);
        this.searchCombo.setItems(textDest);
        this.searchCombo.setText(text);
        this.searchCombo.setData((Object)typeDest);
    }

    private boolean hasHistory(String text, String type) {
        int cnt = 0;
        while (cnt < this.searchCombo.getItemCount()) {
            String[] types = (String[])this.searchCombo.getData();
            if (text.equals(this.searchCombo.getItem(cnt)) && types[cnt].equals(type)) {
                return true;
            }
            ++cnt;
        }
        return false;
    }

    private void restoreHistory() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings(((Object)((Object)this)).getClass().getName());
        if (settings == null) {
            return;
        }
        String[] textArrary = settings.getArray(KEY_SEARCH_TEXT_HISTORY);
        if (textArrary == null) {
            return;
        }
        this.searchCombo.setItems(textArrary);
        String[] typeArrary = settings.getArray(KEY_SEARCH_TYPE_HISTORY);
        if (typeArrary == null) {
            return;
        }
        this.searchCombo.setData((Object)typeArrary);
    }

    public void notifyFound(int count) {
        if (count == 0) {
            this.setMessage(Messages.DomainSearchDialog_TextNotFound, 2);
        } else {
            this.setMessage(String.valueOf(count) + Messages.DomainSearchDialog_MatchFoundMessage_suffix, 1);
        }
    }

    private class HistoryViewerContentProvider
    implements IStructuredContentProvider {
        private Object newInput = null;

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            this.newInput = newInput;
        }

        public void fireFilterChanged() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            Combo combo = (Combo)this.newInput;
            String[] texts = combo.getItems();
            String[] types = (String[])combo.getData();
            ArrayList<String[]> list = new ArrayList<String[]>();
            int cnt = 0;
            while (cnt < texts.length) {
                list.add(new String[]{texts[cnt], types[cnt]});
                ++cnt;
            }
            return list.toArray();
        }
    }

    private class HistoryViewerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private HistoryViewerLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            String[] strArr = (String[])obj;
            if (index == 0) {
                return strArr[index];
            }
            if (index == 1) {
                String typeName = strArr[index];
                Button button = (Button)DomainSearchDialog.this.buttonStore.get(typeName);
                return button.getText();
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }
    }
}

