/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.form.overview;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.ConcreteCommand;
import jp.sourceforge.tomoyo.core.server.ConnectionManager;
import jp.sourceforge.tomoyo.core.server.ConnectionStatus;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.form.PlainFormPage;
import jp.sourceforge.tomoyo.ui.editor.form.overview.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ProjectOverviewPage
extends PlainFormPage
implements Observer {
    public static final String PAGE_ID = "Overview";
    private Action blankAction = new Action("", 1){

        public boolean isEnabled() {
            return false;
        }

        public ImageDescriptor getImageDescriptor() {
            return Activator.getImageDescriptor("blank.gif");
        }

        public ImageDescriptor getDisabledImageDescriptor() {
            return this.getImageDescriptor();
        }
    };

    public ProjectOverviewPage(FormEditor editor) {
        super(editor, PAGE_ID, Messages.ProjectOverviewPage_PageName);
        ConnectionManager.getInstance().addObserver((Observer)this);
    }

    @Override
    protected String getHelpPath() {
        return "/jp.sourceforge.tomoyo.doc/html/page-overview.html";
    }

    @Override
    protected String getFormTitle() {
        return Messages.ProjectOverviewPage_PageName;
    }

    @Override
    protected List<Action> getToolBarActions() {
        List<Action> actionList = super.getToolBarActions();
        actionList.add(0, this.blankAction);
        return actionList;
    }

    @Override
    protected PlainFormPage.Todo[] getTodoList() {
        PlainFormPage.Todo[] todoList = new PlainFormPage.Todo[]{};
        return todoList;
    }

    @Override
    protected void handleTodoLinkEvent(String href) {
    }

    @Override
    protected void createClient(Composite body) {
        Composite composite = new Composite(body, 0);
        GridLayout layout = new GridLayout(2, true);
        composite.setBackground(body.getBackground());
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createGeneralSection(composite);
        this.createTOMOYOSection(composite);
        this.createConnectionSettingSection(composite);
        this.createOperateSection(composite);
    }

    @Override
    protected void restoreDefault() {
        super.restoreDefault();
    }

    private Section createGeneralSection(Composite parent) {
        Section section = this.getManagedForm().getToolkit().createSection(parent, 384);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        section.setText(Messages.ProjectOverviewPage_GeneralSectionTitle);
        section.setDescription(Messages.ProjectOverviewPage_GeneralSectionDescription);
        Composite container = this.getManagedForm().getToolkit().createComposite((Composite)section);
        container.setBackground(parent.getBackground());
        container.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData(4, 4, true, false, 1, 1);
        container.setLayoutData((Object)data);
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(this.getProject());
        String hostname = properties.getProperty(PersistentPropertyManager.PROPERTY_SERVER_HOSTNAME);
        this.createKeyValueComposite(container, Messages.ProjectOverviewPage_GeneralSectionItem_HostTitle, hostname);
        String projnama = this.getProject().getName();
        this.createKeyValueComposite(container, Messages.ProjectOverviewPage_GeneralSectionItem_ProjectTitle, projnama);
        section.setTextClient((Control)this.createToolbar(section));
        this.getManagedForm().getToolkit().paintBordersFor(container);
        section.setClient((Control)container);
        return section;
    }

    private Section createTOMOYOSection(Composite parent) {
        Section section = this.getManagedForm().getToolkit().createSection(parent, 384);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        section.setText(Messages.ProjectOverviewPage_TOMOYOSectionTitle);
        section.setDescription(Messages.ProjectOverviewPage_TOMOYOSectionDescription);
        Composite container = this.getManagedForm().getToolkit().createComposite((Composite)section);
        container.setBackground(parent.getBackground());
        container.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData(4, 4, true, false, 1, 1);
        container.setLayoutData((Object)data);
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(this.getProject());
        String version = properties.getProperty(PersistentPropertyManager.PROPERTY_VERSION);
        this.createKeyValueComposite(container, Messages.ProjectOverviewPage_TOMOYOVersionLabelTitle, version);
        section.setTextClient((Control)this.createToolbar(section));
        this.getManagedForm().getToolkit().paintBordersFor(container);
        section.setClient((Control)container);
        return section;
    }

    private Section createConnectionSettingSection(Composite parent) {
        Section section = this.getManagedForm().getToolkit().createSection(parent, 384);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        section.setText(Messages.ProjectOverviewPage_ConnectionSettingSectionTitle);
        section.setDescription(Messages.ProjectOverviewPage_ConnectionSettingSectionDescription);
        Composite container = this.getManagedForm().getToolkit().createComposite((Composite)section);
        container.setBackground(parent.getBackground());
        ConnectionManager.getInstance().createSettingComposite(this.getProject(), container);
        section.setTextClient((Control)this.createToolbar(section));
        this.getManagedForm().getToolkit().paintBordersFor(container);
        section.setClient((Control)container);
        return section;
    }

    private Section createOperateSection(Composite parent) {
        Section section = this.getManagedForm().getToolkit().createSection(parent, 384);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        section.setText(Messages.ProjectOverviewPage_OperateSectionTitle);
        section.setDescription(Messages.ProjectOverviewPage_OperateSectionDescription);
        Composite container = this.getManagedForm().getToolkit().createComposite((Composite)section, 0);
        TableWrapLayout containerLayout = new TableWrapLayout();
        container.setLayout((Layout)containerLayout);
        container.setLayoutData((Object)new TableWrapData(256, 128));
        String[] hrefs = new String[]{"save.policy", "load.policy", "save.profile"};
        String[] names = new String[]{Messages.ProjectOverviewPage_SavePolicy, Messages.ProjectOverviewPage_LoadPolicy, Messages.ProjectOverviewPage_SaveProfile};
        String[] descs = new String[]{Messages.ProjectOverviewPage_SavePolicyDescription, Messages.ProjectOverviewPage_LoadPolicyDescription, Messages.ProjectOverviewPage_SaveProfileDescription};
        Image[] imgs = new Image[]{Activator.getImage("save.gif"), Activator.getImage("loadpolicy.gif"), Activator.getImage("save.gif")};
        StringBuffer formHTML = new StringBuffer();
        formHTML.append("<form>");
        int cnt = 0;
        while (cnt < names.length) {
            formHTML.append("<li style=\"image\" value=\"" + cnt + "\" bindent=\"5\">");
            formHTML.append("<a href=\"" + hrefs[cnt] + "\">");
            formHTML.append(names[cnt]);
            formHTML.append("</a>");
            formHTML.append(" : ");
            formHTML.append(descs[cnt]);
            formHTML.append("</li>");
            ++cnt;
        }
        formHTML.append("</form>");
        FormText compileFormText = this.createClient(container, formHTML.toString(), this.getManagedForm().getToolkit());
        int cnt2 = 0;
        while (cnt2 < names.length) {
            compileFormText.setImage(String.valueOf(cnt2), imgs[cnt2]);
            ++cnt2;
        }
        compileFormText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ConcreteCommand command;
                String href = e.getHref().toString();
                if (href.equals(hrefs[0])) {
                    TomoyoCorePlugin.getDefault().setStatusMessage(ProjectOverviewPage.access$0(), true);
                    command = CommandManager.getInstance().exec(ProjectOverviewPage.this.getProject(), CommandManager.createCCSToolPath((IProject)ProjectOverviewPage.this.getProject(), (String)"savepolicy"));
                    if (command.isSuccessful()) {
                        TomoyoCorePlugin.getDefault().setStatusMessage(ProjectOverviewPage.access$2(), true);
                    } else {
                        TomoyoCorePlugin.getDefault().setStatusErrorMessage(ProjectOverviewPage.access$3());
                    }
                }
                if (href.equals(hrefs[1])) {
                    TomoyoCorePlugin.getDefault().setStatusMessage(ProjectOverviewPage.access$4(), true);
                    command = CommandManager.getInstance().exec(ProjectOverviewPage.this.getProject(), CommandManager.createCCSToolPath((IProject)ProjectOverviewPage.this.getProject(), (String)"loadpolicy"), new String[]{"AF"}, null);
                    if (command.isSuccessful()) {
                        TomoyoCorePlugin.getDefault().setStatusMessage(ProjectOverviewPage.access$5(), true);
                    } else {
                        TomoyoCorePlugin.getDefault().setStatusErrorMessage(ProjectOverviewPage.access$3());
                    }
                }
                if (href.equals(hrefs[2])) {
                    if (Utilities.saveStatus((IProject)ProjectOverviewPage.this.getProject())) {
                        TomoyoCorePlugin.getDefault().setStatusMessage(ProjectOverviewPage.access$2());
                    } else {
                        TomoyoCorePlugin.getDefault().setStatusErrorMessage(ProjectOverviewPage.access$3());
                    }
                }
            }
        });
        section.setTextClient((Control)this.createToolbar(section));
        this.getManagedForm().getToolkit().paintBordersFor(container);
        section.setClient((Control)container);
        return section;
    }

    protected FormText createClient(Composite section, String content, FormToolkit toolkit) {
        FormText text = toolkit.createFormText(section, true);
        try {
            text.setText(content, true, false);
        }
        catch (SWTException e) {
            text.setText(e.getMessage(), false, false);
        }
        section.setLayoutData((Object)new TableWrapData(256));
        return text;
    }

    protected Composite createKeyValueComposite(Composite parent, String title, String value) {
        Composite composite = new Composite(parent, 0);
        FormToolkit toolkit = this.getToolKit();
        composite.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label titleLabel = toolkit.createLabel(composite, String.valueOf(title) + " :");
        titleLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        titleLabel.setLayoutData((Object)new GridData(1, 2, true, false, 1, 1));
        Label valueLabel = toolkit.createLabel(composite, value == null ? "" : value, 0);
        valueLabel.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        return composite;
    }

    @Override
    public void update(Observable o, Object arg) {
        ConnectionStatus status;
        if (o instanceof ConnectionManager && (status = (ConnectionStatus)arg).getProject().equals((Object)this.getProject())) {
            if (status.isConnected()) {
                if (!status.wasConnected()) {
                    TomoyoCorePlugin.getDefault().setStatusMessage(STATUS_MSG_CONNECTED, Activator.getImage("connected.gif"), true);
                }
            } else if (status.wasConnected()) {
                TomoyoCorePlugin.getDefault().setStatusMessage(STATUS_MSG_DISCONNECTED);
            } else {
                TomoyoCorePlugin.getDefault().setStatusErrorMessage(STATUS_MSG_CANT_CONNECTED);
            }
        }
    }

    @Override
    protected void notifyProfileUpdated(IProject project) {
    }

    @Override
    protected void notifyPolicyUpdated(IProject project, LocalResource localResource) {
    }

    @Override
    public void notifyPageChanged(PlainFormPage editorPage) {
        super.notifyPageChanged(editorPage);
        if (editorPage == this) {
            this.back2homeAction.setEnabled(false);
        }
    }

    static /* synthetic */ String access$0() {
        return PlainFormPage.STATUS_MSG_SAVING;
    }

    static /* synthetic */ String access$2() {
        return PlainFormPage.STATUS_MSG_SAVED;
    }

    static /* synthetic */ String access$3() {
        return PlainFormPage.STATUS_MSG_ERROR;
    }

    static /* synthetic */ String access$4() {
        return PlainFormPage.STATUS_MSG_LOADING;
    }

    static /* synthetic */ String access$5() {
        return PlainFormPage.STATUS_MSG_LOADED;
    }
}

