/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.text.domain;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.ui.editor.CoreEditor;
import jp.sourceforge.tomoyo.ui.editor.text.PolicyEditor;
import jp.sourceforge.tomoyo.ui.editor.text.domain.DomainPolicyOutlinePage;
import jp.sourceforge.tomoyo.ui.editor.text.domain.DomainPolicySourceViewerConfiguration;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlinePage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;

public class DomainPolicyEditor
extends PolicyEditor {
    private ProjectionSupport projectionSupport;
    private ProjectionAnnotationModel annotationModel;
    private Annotation[] oldAnnotations;

    public DomainPolicyEditor(CoreEditor editor) {
        super(editor);
        this.setSourceViewerConfiguration(new DomainPolicySourceViewerConfiguration(this));
    }

    @Override
    protected PolicyOutlinePage getContentOutline() {
        if (this.outline == null) {
            this.outline = new DomainPolicyOutlinePage(this);
        }
        return this.outline;
    }

    @Override
    public IAdaptable getDocumentModel() {
        DomainPolicy domainPolicy = ProcResourceManager.getInstance().getProcResourceSet(this.getProject()).getDomainPolicy();
        return domainPolicy.getModel();
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    @Override
    public void updateFoldingStructure(Hashtable<Domain, Position> positions) {
        Annotation[] annotations = new Annotation[positions.size()];
        HashMap<DomainAnnotation, Position> newAnnotations = new HashMap<DomainAnnotation, Position>();
        Iterator<Domain> it = positions.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Domain domain = it.next();
            Position position = positions.get(domain);
            DomainAnnotation annotation = new DomainAnnotation(domain);
            annotation.markCollapsed();
            newAnnotations.put(annotation, position);
            annotations[i] = annotation;
            ++i;
        }
        if (this.oldAnnotations == null) {
            this.annotationModel.modifyAnnotations(this.oldAnnotations, newAnnotations, null);
        } else {
            this.annotationModel.modifyAnnotations(this.oldAnnotations, newAnnotations, null);
        }
        this.oldAnnotations = annotations;
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
    }

    private class DomainAnnotation
    extends ProjectionAnnotation {
        private Domain domain = null;

        public DomainAnnotation(Domain domain) {
            this.domain = domain;
        }

        public Domain getDomain() {
            return this.domain;
        }
    }
}

