/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.text.domain;

import jp.sourceforge.tomoyo.ui.editor.text.PolicyEditor;
import jp.sourceforge.tomoyo.ui.editor.text.PolicySourceViewerConfiguration;
import jp.sourceforge.tomoyo.ui.editor.text.domain.DomainPolicyKeywordScanner;
import jp.sourceforge.tomoyo.ui.editor.text.domain.DomainPolicyReconcilingStrategy;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.FileEditorInput;

public class DomainPolicySourceViewerConfiguration
extends PolicySourceViewerConfiguration {
    public DomainPolicySourceViewerConfiguration(PolicyEditor editor) {
        super(editor);
    }

    @Override
    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type"};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new DomainPolicyKeywordScanner(((FileEditorInput)this.getEditor().getEditorInput()).getFile().getProject()));
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.enableAutoInsert(true);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setContextInformationPopupBackground(Display.getCurrent().getSystemColor(1));
        return assistant;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        DomainPolicyReconcilingStrategy strategy = new DomainPolicyReconcilingStrategy();
        strategy.setEditor(this.getEditor());
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        return reconciler;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new TEAnnotationHover();
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        return new PolicyTextHover();
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new PolicyTextHover();
    }

    public class PolicyTextHover
    implements ITextHover {
        public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
            return new Region(offset, 0);
        }

        public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
            StringBuffer message = new StringBuffer();
            if (hoverRegion != null) {
                return message.toString();
            }
            return "Can't locate definition. Sorry. --;";
        }
    }

    private class TEAnnotationHover
    implements IAnnotationHover {
        private TEAnnotationHover() {
        }

        public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
            IDocument document = sourceViewer.getDocument();
            try {
                IRegion info = document.getLineInformation(lineNumber);
                return document.get(info.getOffset(), info.getLength());
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
    }
}

