/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.text.outline;

import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.CoreEditorOutlineLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ExceptPolicyOutlineLabelProvider
extends CoreEditorOutlineLabelProvider
implements IColorProvider {
    protected IProject project;
    private boolean deletedColoring = false;
    private boolean directiveVerbose = false;

    public ExceptPolicyOutlineLabelProvider(IProject project) {
        this.project = project;
    }

    @Override
    public String getText(Object element) {
        if (element instanceof PolicyElementDefinition) {
            PolicyElementDefinition definition = (PolicyElementDefinition)element;
            return String.valueOf(definition.getCaption()) + " (" + PolicyCacheManager.getInstance().count(this.project, definition.getElementClass(), false) + ")";
        }
        if (element instanceof PolicyElement) {
            PolicyElement policyElement = (PolicyElement)element;
            if (this.directiveVerbose) {
                return policyElement.getText();
            }
            return policyElement.getContents();
        }
        return element.toString();
    }

    @Override
    public Image getImage(Object element) {
        if (element instanceof PolicyElement) {
            return Activator.getImage("define_element.gif");
        }
        if (element instanceof PolicyElementDefinition) {
            PolicyElementDefinition definition = (PolicyElementDefinition)element;
            return definition.getImage();
        }
        return null;
    }

    public Color getBackground(Object element) {
        if (element instanceof PolicyElement) {
            PolicyElement policyElement = (PolicyElement)element;
            if (policyElement.isDeleted() && this.deletedColoring) {
                return Utilities.getDeletedColor();
            }
            if (policyElement.isCreated()) {
                return Utilities.getCreatedColor();
            }
            return null;
        }
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public void setDeletetedColoring(boolean b) {
        this.deletedColoring = b;
    }

    public void setDirectiveVerbose(boolean b) {
        this.directiveVerbose = b;
    }
}

