/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.text.outline;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tomoyo.core.local.model.AbstractPolicyModel;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.CoreEditorOutlineMouseListener;
import jp.sourceforge.tomoyo.ui.editor.ICoreEditorOutlilePage;
import jp.sourceforge.tomoyo.ui.editor.ViewerExpandCollapseKeyListener;
import jp.sourceforge.tomoyo.ui.editor.text.PolicyEditor;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlineContentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public abstract class PolicyOutlinePage
extends ContentOutlinePage
implements ICoreEditorOutlilePage {
    protected PolicyEditor editor;
    private List<Action> actionList = null;
    private boolean ignoreSelectionChanged = false;
    protected Action expandAction = new Action("Expand all", 1){

        public ImageDescriptor getImageDescriptor() {
            return Activator.getImageDescriptor("expandall.gif");
        }

        public void run() {
            TreeViewer viewer = PolicyOutlinePage.this.getTreeViewer();
            viewer.getTree().setRedraw(false);
            viewer.expandAll();
            viewer.getTree().setRedraw(true);
        }
    };
    protected Action collapseAction = new Action("Collapse all", 1){

        public ImageDescriptor getImageDescriptor() {
            return Activator.getImageDescriptor("collapseall.gif");
        }

        public void run() {
            TreeViewer viewer = PolicyOutlinePage.this.getTreeViewer();
            viewer.getTree().setRedraw(false);
            viewer.collapseAll();
            viewer.getTree().setRedraw(true);
        }
    };

    public PolicyOutlinePage(PolicyEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setupViewer();
        this.setupViewerPoupuMenu();
        this.getControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                PolicyOutlinePage.this.bring2TopPropertySheet();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.getTreeViewer().setInput(this.getModel());
        this.restoreUserPreference();
    }

    @Override
    public List<Action> getToolBarActions() {
        if (this.actionList == null) {
            this.actionList = new ArrayList<Action>();
            this.actionList.add(this.expandAction);
            this.actionList.add(this.collapseAction);
        }
        return this.actionList;
    }

    protected void setupViewer() {
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)this.createContentProvider());
        viewer.setLabelProvider(this.createLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.getControl().addKeyListener((KeyListener)new ViewerExpandCollapseKeyListener(viewer));
        viewer.getControl().addMouseListener((MouseListener)new CoreEditorOutlineMouseListener(viewer));
        viewer.getControl().addFocusListener((FocusListener)new TreeFocusAdapter(viewer));
    }

    private void setupViewerPoupuMenu() {
        TreeViewer viewer = this.getTreeViewer();
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        this.setupMenuBar(menuManager);
        Menu menu = menuManager.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(menu);
    }

    protected void refreshViewer() {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null || viewer.getTree().isDisposed()) {
            return;
        }
        viewer.refresh(true);
    }

    private void setupMenuBar(MenuManager menuManager) {
        IMenuListener menuListener = this.createMenuListener();
        if (menuListener != null) {
            menuManager.addMenuListener(menuListener);
        }
    }

    protected abstract IMenuListener createMenuListener();

    protected void restoreUserPreference() {
    }

    private void bring2TopPropertySheet() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("org.eclipse.ui.views.PropertySheet", null, 2);
        }
        catch (PartInitException e) {
            Activator.logException(e);
        }
    }

    protected abstract PolicyOutlineContentProvider createContentProvider();

    protected abstract IBaseLabelProvider createLabelProvider();

    private Object getModel() {
        return this.editor.getDocumentModel();
    }

    public void notifyPolicyUpdated() {
        Control control = this.getTreeViewer().getControl();
        if (control != null && !control.isDisposed()) {
            this.getTreeViewer().refresh();
        }
    }

    public void updateCursor(int offset) {
        try {
            AbstractPolicyModel document;
            PolicyElement element;
            this.ignoreSelectionChanged = true;
            Object model = this.getModel();
            if (model instanceof AbstractPolicyModel && (element = (document = (AbstractPolicyModel)model).within(offset)) != null) {
                StructuredSelection currentSelection = (StructuredSelection)this.getTreeViewer().getSelection();
                if (currentSelection.size() > 1) {
                    return;
                }
                StructuredSelection newSelection = new StructuredSelection((Object)element);
                this.getTreeViewer().setSelection((ISelection)newSelection);
            }
        }
        finally {
            this.ignoreSelectionChanged = false;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        if (this.ignoreSelectionChanged) {
            return;
        }
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.editor.resetHighlightRange();
            return;
        }
        if (selection instanceof StructuredSelection) {
            StructuredSelection structured = (StructuredSelection)selection;
            for (Object obj : structured) {
                Domain domain;
                PolicyElement element;
                if (!(obj instanceof PolicyElement) || (element = (PolicyElement)obj) instanceof Domain && (domain = (Domain)element).isSkelton()) continue;
                this.editor.getSelectionProvider().setSelection((ISelection)new TextSelection(element.getOffset(), element.length()));
                this.editor.selectAndReveal(element.getOffset(), element.length());
            }
        }
    }

    protected IFile getFile() {
        return ((FileEditorInput)this.editor.getEditorInput()).getFile();
    }

    protected IProject getProject() {
        return this.getFile().getProject();
    }

    protected class TreeFocusAdapter
    extends FocusAdapter {
        private TreeViewer viewer;

        public TreeFocusAdapter(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public void focusGained(FocusEvent e) {
            this.updateSelectionProvider(this.viewer);
        }

        private void updateSelectionProvider(TreeViewer viewer) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().setSelectionProvider((ISelectionProvider)viewer);
        }
    }
}

