/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.text.system;

import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class SystemPolicyKeywordScanner
extends RuleBasedScanner {
    private static Color defaultColor = Display.getCurrent().getSystemColor(2);
    private static Color keywordColor = Display.getCurrent().getSystemColor(12);
    private static Color reserveColor = Display.getCurrent().getSystemColor(10);
    private static final String[] reserveds = new String[]{"none", "any", "sunrpc", "selinuxfs", "usbfs", "sysfs", "ext2", "ext3", "devpts", "tmpfs", "binfmt_misc", "rpc_pipefs"};

    public SystemPolicyKeywordScanner(IProject project) {
        Token defaultToken = new Token((Object)new TextAttribute(defaultColor));
        Token keywordToken = new Token((Object)new TextAttribute(keywordColor, null, 2));
        Token reserveToken = new Token((Object)new TextAttribute(reserveColor, null, 2));
        WordRule keywordRule = new WordRule((IWordDetector)new PolicyKeywordDetector(), (IToken)defaultToken);
        int i = 0;
        while (i < reserveds.length) {
            keywordRule.addWord(reserveds[i], (IToken)reserveToken);
            ++i;
        }
        String[] systemDirectives = ProcResourceManager.getInstance().getProcResourceSet(project).getSystemPolicy().getModel().listSupportedDirectives();
        int i2 = 0;
        while (i2 < systemDirectives.length) {
            keywordRule.addWord(systemDirectives[i2], (IToken)keywordToken);
            ++i2;
        }
        IRule[] rules = new IRule[]{new WhitespaceRule((IWhitespaceDetector)new PolicyWhitespaceDetector()), keywordRule};
        this.setRules(rules);
    }

    static class PolicyKeywordDetector
    implements IWordDetector {
        PolicyKeywordDetector() {
        }

        public boolean isWordPart(char character) {
            return Character.isDigit(character) | Character.isLetter(character) | character == '_';
        }

        public boolean isWordStart(char character) {
            return Character.isDigit(character) | Character.isLetter(character);
        }
    }

    static class PolicyWhitespaceDetector
    implements IWhitespaceDetector {
        PolicyWhitespaceDetector() {
        }

        public boolean isWhitespace(char character) {
            return Character.isWhitespace(character);
        }
    }
}

