/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core;

import java.util.Hashtable;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import org.eclipse.core.resources.IProject;

public class ProjectPropertyManager {
    private static ProjectPropertyManager instance;
    private static Hashtable<String, ProjectProperty> cache;

    static {
        cache = new Hashtable();
    }

    private ProjectPropertyManager() {
    }

    public static ProjectPropertyManager getInstance() {
        if (instance == null) {
            instance = new ProjectPropertyManager();
        }
        return instance;
    }

    public ProjectProperty getProperty(IProject project) {
        if (project == null || !project.isOpen()) {
            return null;
        }
        if (cache.get(project.getName()) == null) {
            ProjectProperty property = new ProjectProperty(project);
            cache.put(project.getName(), property);
        }
        return (ProjectProperty)cache.get(project.getName());
    }

    public void removeCache(IProject project) {
        if (project == null) {
            return;
        }
        cache.remove(project.getName());
    }
}

