/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import jp.sourceforge.tomoyo.core.Messages;
import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.extensions.IConnectionAdapter;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.except.KeepDomain;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.local.resource.Status;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.ConcreteCommand;
import jp.sourceforge.tomoyo.core.server.ReadCommand;
import jp.sourceforge.tomoyo.core.server.WriteCommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorPart;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utilities {
    public static final String T_VER_12B = Messages.Utilities_12AndBelow;
    public static final String T_VER_130 = "1.3.0";
    public static final String T_VER_131 = "1.3.1";
    public static final String T_VER_132 = "1.3.2";
    public static final String T_VER_140 = "1.4";
    public static final String T_VER_141 = "1.4.1";
    public static final String T_VER_20 = "2.0";
    public static final String[] T_VER_ALL = new String[]{T_VER_12B, "1.3.0", "1.3.1", "1.3.2", "1.4", "1.4.1", "2.0"};
    public static final String[] T_VER_1x = new String[]{T_VER_12B, "1.3.0", "1.3.1", "1.3.2", "1.4", "1.4.1"};
    public static final String[] T_VER_2x = new String[]{"2.0"};
    private static final String[] SUPPORTED_VERSIONS = new String[]{"1.4", "1.4.1", "2.0"};

    public static SimpleDateFormat getCommonDateFormat() {
        return new SimpleDateFormat("MM/dd HH:mm:ss");
    }

    public static String getCurrentDateTime() {
        return Utilities.getCommonDateFormat().format(new Date(System.currentTimeMillis()));
    }

    public static String concatServerPath(String directory, String file) {
        if (directory == null) {
            throw new IllegalArgumentException("Argment directory is null.");
        }
        if (directory.endsWith("/")) {
            return String.valueOf(directory) + file;
        }
        return String.valueOf(directory) + "/" + file;
    }

    public static String getCCSToolPath(IProject project, String toolname) {
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(project);
        return Utilities.concatServerPath((String)properties.getProperty(PersistentPropertyManager.PROPERTY_CCS_TOOL_DIRECTORY), (String)toolname);
    }

    public static String getCCSDataDirectory(IProject project) {
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(project);
        return properties.getProperty(PersistentPropertyManager.PROPERTY_CCS_DATA_DIRECTORY);
    }

    public static String getCCSDataPath(IProject project, String filename) {
        return Utilities.concatServerPath((String)Utilities.getCCSDataDirectory((IProject)project), (String)filename);
    }

    public static String getCCSProcPath(IProject project, String file) {
        IPreferenceStore store = TomoyoCorePlugin.getDefault().getPreferenceStore();
        String wkdir = store.getString("ccs.proc.path");
        return Utilities.concatServerPath((String)wkdir, (String)file);
    }

    public static String getCCSProcPath(IProject project, String dir, String file) {
        IPreferenceStore store = TomoyoCorePlugin.getDefault().getPreferenceStore();
        String wkdir = Utilities.concatServerPath((String)store.getString("ccs.proc.path"), (String)dir);
        return Utilities.concatServerPath((String)wkdir, (String)file);
    }

    public static boolean isPoilcy(IResource resource) {
        if (resource == null) {
            return false;
        }
        if (!(resource.getParent() instanceof IFolder)) {
            return false;
        }
        if (!(resource.getParent().getParent() instanceof IProject)) {
            return false;
        }
        if (((IFolder)resource.getParent()).getName().equals("policy")) {
            return resource.getName().equals("domain_policy") || resource.getName().equals("exception_policy") || resource.getName().equals("system_policy");
        }
        return false;
    }

    public static Color getCreatedColor() {
        return TomoyoCorePlugin.getStandardDisplay().getSystemColor(7);
    }

    public static Color getDeletedColor() {
        return TomoyoCorePlugin.getStandardDisplay().getSystemColor(15);
    }

    public static String getConnectionAdapterID(IProject project) {
        ProjectProperty property = ProjectPropertyManager.getInstance().getProperty(project);
        if (property == null) {
            return null;
        }
        return property.getProperty(PersistentPropertyManager.PROPERTY_CONNECTION_ADAPTER);
    }

    public static IConnectionAdapter getConnectionAdapter(IProject project) {
        String adapterID = Utilities.getConnectionAdapterID((IProject)project);
        return TomoyoCorePlugin.getDefault().getConnectionAdapter(adapterID);
    }

    public static IEditorPart openEditor(IFile file) {
        IEditorPart editor = Utilities.findEditor((IFile)file);
        Utilities.activateEditor((IEditorPart)editor);
        return editor;
    }

    public static void activateEditor(IEditorPart editor) {
        TomoyoCorePlugin.getStandardDisplay().syncExec((Runnable)new ActivateEditorThread(editor));
    }

    public static IEditorPart findEditor(IFile file) {
        OpenEditorThread thread = new OpenEditorThread(file);
        TomoyoCorePlugin.getStandardDisplay().syncExec((Runnable)thread);
        return thread.getEditor();
    }

    public static String distinctVersion(IProject project) {
        Status status = ProcResourceManager.getInstance().getProcResourceSet(project).getStatus();
        ReadCommand rCommand = CommandManager.getInstance().read(project, (LocalResource)status);
        if (rCommand.isSuccessful()) {
            if (!Utilities.isProfileAvailable((ReadCommand)rCommand, (String)"MAC_FOR_NETWORK")) {
                return "2.0";
            }
            if (Utilities.isProfileAvailable((ReadCommand)rCommand, (String)"RESTRICT_PIVOT_ROOT")) {
                return "1.4";
            }
            if (Utilities.isProfileAvailable((ReadCommand)rCommand, (String)"ALLOW_ENFORCE_GRACE")) {
                return "1.3.1" + Messages.Utilities_Or + "1.3.2";
            }
            if (Utilities.isProfileAvailable((ReadCommand)rCommand, (String)"MAX_ENFORCE_GRACE")) {
                return "1.3.0";
            }
            return T_VER_12B;
        }
        return Messages.Utilities_VersionCantSpecified;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isProfileAvailable(ReadCommand command, String checkProfileName) {
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(command.getSTDOut().getBytes())));
        try {
            int index;
            String profileName;
            String line = null;
            do {
                if ((line = br.readLine()) != null) continue;
                return false;
            } while (!(profileName = line.substring((index = line.indexOf("-")) + 1)).startsWith(checkProfileName));
            return true;
        }
        catch (IOException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
        return false;
    }

    public static String getTomoyoVersion(IProject project) {
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(project);
        if (properties == null) {
            return null;
        }
        String version = properties.getProperty(PersistentPropertyManager.PROPERTY_VERSION);
        return version;
    }

    public static boolean is20(IProject project) {
        String version = Utilities.getTomoyoVersion((IProject)project);
        return version != null && version.equals("2.0");
    }

    public static boolean isSupportedVersion(String strVersion) {
        int cnt = 0;
        while (cnt < SUPPORTED_VERSIONS.length) {
            if (SUPPORTED_VERSIONS[cnt].equals(strVersion)) {
                return true;
            }
            ++cnt;
        }
        return false;
    }

    public static boolean installManagerDomain(IProject project, String domainOrProgram) {
        ConcreteCommand cCommand1 = CommandManager.getInstance().exec(project, Utilities.getInstallMgrCommand1((IProject)project));
        if (!cCommand1.isSuccessful()) {
            return false;
        }
        WriteCommand wCommand = CommandManager.getInstance().write(project, CommandManager.createCCSDataPath((IProject)project, (String)"manager.txt"), Utilities.getInputText((String)domainOrProgram), true, CommandManager.createCCSToolPath((IProject)project, (String)"editpolicy"));
        if (!wCommand.isSuccessful()) {
            return false;
        }
        ConcreteCommand cCommand3 = CommandManager.getInstance().exec(project, Utilities.getInstallMgrCommand3((IProject)project));
        if (!cCommand3.isSuccessful()) {
            return false;
        }
        ReadCommand rCommand = CommandManager.getInstance().read(project, "/proc/ccs/policy/manager");
        if (rCommand.isSuccessful()) {
            return Utilities.containsLine((ReadCommand)rCommand, (String)domainOrProgram);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean containsLine(ReadCommand command, String domainOrProgram) {
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(command.getSTDOut().getBytes())));
        try {
            String line = null;
            do {
                if ((line = br.readLine()) != null) continue;
                return false;
            } while (!line.equals(domainOrProgram));
            return true;
        }
        catch (IOException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
        return false;
    }

    public static String getInputText(String domainOrProgram) {
        StringBuffer input = new StringBuffer();
        input.append("\n");
        input.append(domainOrProgram);
        input.append("\n");
        return input.toString();
    }

    public static String getInstallMgrCommand1(IProject project) {
        String editpolicy = CommandManager.createCCSToolPath((IProject)project, (String)"editpolicy");
        String editpolicyBak = editpolicy.concat(".bak");
        StringBuffer command = new StringBuffer();
        command.append("/bin/mv");
        command.append(" ");
        command.append(editpolicy);
        command.append(" ");
        command.append(editpolicyBak);
        command.append(" && ");
        command.append("/bin/cp");
        command.append(" ");
        command.append("/bin/cat");
        command.append(" ");
        command.append(editpolicy);
        return command.toString();
    }

    public static String getInstallMgrCommand3(IProject project) {
        String editpolicy = CommandManager.createCCSToolPath((IProject)project, (String)"editpolicy");
        String editpolicyBak = editpolicy.concat(".bak");
        StringBuffer command = new StringBuffer();
        command.append(editpolicy);
        command.append(" ");
        command.append(CommandManager.createCCSDataPath((IProject)project, (String)"manager.txt"));
        command.append(" > ");
        command.append("/proc/ccs/policy/manager");
        command.append(" && ");
        command.append("/bin/mv");
        command.append(" ");
        command.append(editpolicyBak);
        command.append(" ");
        command.append(editpolicy);
        return command.toString();
    }

    public static String getNeedToBeManagerDomain(IProject project) {
        String selfDomain = Utilities.getSelfDomainText((IProject)project);
        boolean isKeepDomain = Utilities.isKeepDomain((IProject)project, (String)selfDomain);
        if (isKeepDomain) {
            return selfDomain;
        }
        return String.valueOf(selfDomain) + " " + "/bin/cat";
    }

    private static String getSelfDomainText(IProject project) {
        return CommandManager.getInstance().getSelfDomain(project);
    }

    private static boolean isKeepDomain(IProject project, String strDomain) {
        PolicyElement[] elements = PolicyCacheManager.getInstance().findElements(project, KeepDomain.class);
        int cnt = 0;
        while (cnt < elements.length) {
            KeepDomain element = (KeepDomain)elements[cnt];
            if (element.getTarget().equals(strDomain)) {
                return true;
            }
            ++cnt;
        }
        return false;
    }

    public static boolean isRegisterdAsManager(IProject project, String checkDomainOrProgram) {
        ArrayList managers = Utilities.getManagers((IProject)project);
        Iterator it = managers.iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).equals(checkDomainOrProgram)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<String> getManagers(IProject project) {
        ArrayList<String> managerList = new ArrayList<String>();
        ReadCommand command = CommandManager.getInstance().read(project, "/proc/ccs/policy/manager");
        if (command.isSuccessful()) {
            String stdout = command.getSTDOut();
            if (stdout == null) {
                return managerList;
            }
            StringReader reader = new StringReader(stdout);
            BufferedReader bufferdReader = new BufferedReader(reader);
            try {
                String line;
                while ((line = bufferdReader.readLine()) != null) {
                    managerList.add(line);
                }
            }
            catch (IOException e) {
                TomoyoCorePlugin.logException((Throwable)e);
            }
        }
        return managerList;
    }

    public static boolean saveStatus(IProject project) {
        Status status = ProcResourceManager.getInstance().getProcResourceSet(project).getStatus();
        ReadCommand rCommand = CommandManager.getInstance().read(project, (LocalResource)status);
        if (rCommand.isSuccessful()) {
            String formatTime = new SimpleDateFormat("yy-MM-dd.HH:mm:ss").format(new Date(System.currentTimeMillis()));
            String source = status.getRemoteLocation();
            String target = String.valueOf(Utilities.removeExtension((String)source)) + "." + formatTime + ".txt";
            WriteCommand wCommand = CommandManager.getInstance().write(project, target, rCommand.getSTDOut());
            if (wCommand.isSuccessful()) {
                ConcreteCommand cCommand2;
                int[] nArray = new int[2];
                nArray[1] = 1;
                ConcreteCommand cCommand1 = CommandManager.getInstance().exec(project, "unlink", null, new String[]{source}, nArray);
                if (cCommand1.isSuccessful() && (cCommand2 = CommandManager.getInstance().exec(project, "ln", new String[]{"-s"}, new String[]{target, source})).isSuccessful()) {
                    return true;
                }
            }
        }
        return false;
    }

    private static String removeExtension(String source) {
        if (source == null) {
            return source;
        }
        int index = source.lastIndexOf(".");
        return source.substring(0, index);
    }
}

