/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.model;

import java.util.ArrayList;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractPolicyModel
extends PolicyElement {
    private IProject project;
    private boolean valid = false;
    private int size;

    public AbstractPolicyModel(IProject project) {
        super(null, 0, 0);
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean b) {
        this.valid = b;
    }

    public void initialize() {
        this.traverse((PolicyElement)this);
    }

    protected void traverse(PolicyElement element) {
        element.hookTraverse();
        int cnt = 0;
        while (cnt < element.getChildrenCount()) {
            PolicyElement child = element.getChild(cnt);
            this.traverse(child);
            ++cnt;
        }
    }

    public PolicyElement[] getElementArray() {
        ArrayList list = new ArrayList();
        this._getElementArray(list, (PolicyElement)this);
        return list.toArray(new PolicyElement[list.size()]);
    }

    public void _getElementArray(ArrayList<PolicyElement> list, PolicyElement element) {
        int cnt = 0;
        while (cnt < element.getChildrenCount()) {
            PolicyElement child = element.getChild(cnt);
            list.add(child);
            this._getElementArray(list, child);
            ++cnt;
        }
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public abstract String getPolicyModelName();

    public abstract ArrayList<PolicyElementDefinition> listElementDefinitions();

    public ArrayList<PolicyElementDefinition> listElementDefinitions(boolean filterOnlySupported) {
        if (filterOnlySupported) {
            ArrayList<PolicyElementDefinition> filterdList = new ArrayList<PolicyElementDefinition>();
            ArrayList definitions = this.listElementDefinitions();
            int cnt = 0;
            while (cnt < definitions.size()) {
                PolicyElementDefinition definition = (PolicyElementDefinition)definitions.get(cnt);
                if (definition.isAvailableVersion(this.project)) {
                    filterdList.add(definition);
                }
                ++cnt;
            }
            return filterdList;
        }
        return this.listElementDefinitions();
    }

    public String[] listSupportedDirectives() {
        ArrayList<String> directiveNames = new ArrayList<String>();
        ArrayList definitions = this.listElementDefinitions(true);
        int cnt = 0;
        while (cnt < definitions.size()) {
            PolicyElementDefinition definition = (PolicyElementDefinition)definitions.get(cnt);
            directiveNames.add(definition.getDirectiveName());
            ++cnt;
        }
        return directiveNames.toArray(new String[directiveNames.size()]);
    }

    public boolean isDirectiveSupported(String directive) {
        String[] directives = this.listSupportedDirectives();
        int cnt = 0;
        while (cnt < directives.length) {
            if (directives[cnt].equals(directive)) {
                return true;
            }
            ++cnt;
        }
        return false;
    }

    public PolicyElementDefinition findDefinition(Class elementClass) {
        ArrayList definitions = this.listElementDefinitions();
        int cnt = 0;
        while (cnt < definitions.size()) {
            PolicyElementDefinition definition = (PolicyElementDefinition)definitions.get(cnt);
            if (elementClass.equals(definition.getElementClass())) {
                return definition;
            }
            ++cnt;
        }
        return null;
    }

    public PolicyElementDefinition getDefinitionByDirective(String directive) {
        ArrayList definitions = this.listElementDefinitions();
        int cnt = 0;
        while (cnt < definitions.size()) {
            PolicyElementDefinition definition = (PolicyElementDefinition)definitions.get(cnt);
            if (directive.equals(definition.getDirectiveName())) {
                return definition;
            }
            ++cnt;
        }
        return null;
    }

    public String getDirectiveByElementClass(Class elementClass) {
        ArrayList definitions = this.listElementDefinitions();
        int cnt = 0;
        while (cnt < definitions.size()) {
            PolicyElementDefinition definition = (PolicyElementDefinition)definitions.get(cnt);
            if (elementClass.equals(definition.getElementClass())) {
                return definition.getDirectiveName();
            }
            ++cnt;
        }
        return null;
    }

    public Image getElementImage(Class elementClass) {
        ArrayList definitions = this.listElementDefinitions();
        int cnt = 0;
        while (cnt < definitions.size()) {
            PolicyElementDefinition definition = (PolicyElementDefinition)definitions.get(cnt);
            if (elementClass.equals(definition.getElementClass())) {
                return definition.getImage();
            }
            ++cnt;
        }
        return null;
    }

    public abstract Image getImage();
}

