/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.model;

import java.util.List;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.model.domain.IAccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Profile;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileGroup;
import org.eclipse.core.resources.IProject;

public class PolicyCacheManager {
    private static PolicyCacheManager instance;
    private DomainTransitionCache domainTransitionCache = new DomainTransitionCache(this, null);
    private InitializerCache initializerCache = new InitializerCache(this, null);
    private ProjectCache projectCache = new ProjectCache(this, null);

    public static PolicyCacheManager getInstance() {
        if (instance == null) {
            instance = new PolicyCacheManager();
        }
        return instance;
    }

    public void clear(IProject project) {
        this.domainTransitionCache.clear(project);
        this.initializerCache.clear(project);
        this.projectCache.clear(project);
    }

    public void createDomainTranstion(IProject project) {
        this.domainTransitionCache.createDomainTranstion(project);
    }

    public int countDomains(IProject project, boolean includeSkelton) {
        if (includeSkelton) {
            return this.domainTransitionCache.count(project);
        }
        return this.findElementList(project, Domain.class).size();
    }

    public List<Domain> listChildDomains(IProject project, Domain domain) {
        return this.domainTransitionCache.listChildDomains(project, domain);
    }

    public List<Domain> listDecendantDomains(IProject project, Domain domain) {
        return this.domainTransitionCache.listDecendantDomains(project, domain);
    }

    public int listDecendantDomainCount(IProject project, Domain domain) {
        return this.listDecendantDomains(project, domain).size();
    }

    public Domain getParentDomain(IProject project, Domain domain) {
        return this.domainTransitionCache.getParentDomain(project, domain);
    }

    public void addInitializerTarget(IProject project, Domain domain) {
        this.initializerCache.addInitializerTarget(project, domain);
    }

    public Domain getInitializerTarget(IProject project, String executableName) {
        return this.initializerCache.getInitializerTarget(project, executableName);
    }

    public int countInitializerTarget(IProject project) {
        return this.initializerCache.count(project);
    }

    public void addElement(IProject project, PolicyElement cacheElement) {
        this.projectCache.addElement(project, cacheElement);
    }

    public boolean exists(IProject project, PolicyElement policyElement) {
        return this.projectCache.exists(project, policyElement);
    }

    public boolean exists(IProject project, Domain domain, AccessPermission accessPermission) {
        return this.projectCache.exists(project, domain, accessPermission);
    }

    public PolicyElement findElement(IProject project, Class cacheClass, String text) {
        return this.projectCache.findElement(project, cacheClass, text, false);
    }

    public PolicyElement findElement(IProject project, PolicyElement element) {
        return this.projectCache.findElement(project, element, false);
    }

    public PolicyElement[] findElements(IProject project, Class cacheClass) {
        return this.projectCache.findElements(project, cacheClass);
    }

    public PolicyElement[] findElements(IProject project, Class[] cacheClasses) {
        return this.projectCache.findElements(project, cacheClasses);
    }

    public List<PolicyElement> findElementList(IProject project, Class cacheClass) {
        return this.projectCache.findElementList(project, cacheClass);
    }

    public Domain findDomain(IProject project, String domain) {
        PolicyElement[] elements = this.projectCache.findElements(project, Domain.class);
        if (elements == null) {
            return null;
        }
        int cnt = 0;
        while (cnt < elements.length) {
            if (elements[cnt].getText().equals(domain)) {
                return (Domain)elements[cnt];
            }
            ++cnt;
        }
        return null;
    }

    public AccessPermission findAccessPermission(IProject project, Domain domain, String strAccessPermission) {
        Domain foundDomain = this.findDomain(project, domain.getText());
        if (foundDomain == null) {
            return null;
        }
        int cnt = 0;
        while (cnt < foundDomain.getChildrenCount()) {
            AccessPermission permission;
            PolicyElement element = foundDomain.getChild(cnt);
            if (element instanceof IAccessPermission && (permission = (AccessPermission)element).getText().equals(strAccessPermission)) {
                return permission;
            }
            ++cnt;
        }
        return null;
    }

    public AccessPermission findAccessPermission(IProject project, String strDomain, String strPermission, String strPath) {
        Domain foundDomain = this.findDomain(project, strDomain);
        if (foundDomain == null) {
            return null;
        }
        int cnt = 0;
        while (cnt < foundDomain.getChildrenCount()) {
            AccessPermission permission;
            PolicyElement element = foundDomain.getChild(cnt);
            if (element instanceof IAccessPermission && (permission = (AccessPermission)element).getDeclaredPermission().equals(strPermission) && permission.getPermission().equals(strPath)) {
                return permission;
            }
            ++cnt;
        }
        return null;
    }

    public int countDomain(IProject project, ProfileGroup group) {
        int count = 0;
        PolicyElement[] elements = this.findElements(project, Domain.class);
        int cnt = 0;
        while (cnt < elements.length) {
            Profile useProfile;
            Domain domain = (Domain)elements[cnt];
            if (!domain.isDeleted() && (useProfile = domain.getProfile()) != null && useProfile.getNo().equals(String.valueOf(group.getNo()))) {
                ++count;
            }
            ++cnt;
        }
        return count;
    }

    public int count(IProject project, Class cacheClass, boolean includeDeleted) {
        if (includeDeleted) {
            return this.findElements(project, cacheClass).length;
        }
        PolicyElement[] elements = this.findElements(project, cacheClass);
        if (elements == null) {
            return 0;
        }
        int count = 0;
        int cnt = 0;
        while (cnt < elements.length) {
            if (!elements[cnt].isDeleted()) {
                ++count;
            }
            ++cnt;
        }
        return count;
    }

    public int count(IProject project, Domain domain, Class cacheClass, boolean includeDeleted) {
        PolicyElement[] elements = this.findElements(project, cacheClass);
        int count = 0;
        int cnt = 0;
        while (cnt < elements.length) {
            Domain parentDomain;
            AccessPermission access;
            if (elements[cnt] instanceof AccessPermission && (!(access = (AccessPermission)elements[cnt]).isDeleted() || includeDeleted) && (parentDomain = (Domain)access.getParent()).getText() != null && domain.getText() != null && parentDomain.getText().equals(domain.getText())) {
                ++count;
            }
            ++cnt;
        }
        return count;
    }

    public void clear(IProject project, Class cacheClass) {
        this.projectCache.clear(project, cacheClass);
    }
}

