/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class PolicyElement
implements IAdaptable {
    private PolicyElement parent = null;
    private List<PolicyElement> children = null;
    private String text = null;
    private int line = -1;
    private int offset = -1;
    public static final int NOTE_NONE = 0;
    public static final int NOTE_INFO = 1;
    public static final int NOTE_WARNNING = 2;
    public static final int NOTE_ERROR = 3;
    protected int noteID = 0;
    protected String note = null;
    protected int noteOffset = -1;
    protected int noteOffsetLength = -1;
    private String[] splited;
    protected IPropertySource propertySource;
    private boolean created = false;
    private boolean checked = false;
    private boolean deleted = false;

    public PolicyElement(String text, int line, int offset) {
        this.text = text;
        this.line = line;
        this.offset = offset;
        this.validate();
    }

    protected void validate() {
    }

    public int getNoteID() {
        return this.noteID;
    }

    public int getNoteOffset() {
        return this.noteOffset;
    }

    public int getNoteOffsetLength() {
        return this.noteOffsetLength;
    }

    public boolean hasNote() {
        return this.noteID != 0;
    }

    public String getNote() {
        return this.note;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int column) {
        this.offset = column;
    }

    public int length() {
        return this.getText() == null ? 0 : this.getText().length();
    }

    public int getLine() {
        return this.line;
    }

    public void setLineno(int line) {
        this.line = line;
    }

    public String getText() {
        return this.text;
    }

    private String[] splitText() {
        if (this.splited == null) {
            this.splited = this.getText().split("[\\s]+");
        }
        return this.splited;
    }

    public String getText(int idx) {
        String[] strs = this.splitText();
        return strs[idx];
    }

    public String getContents() {
        return this.getTextFrom(1);
    }

    public String[] getTransitionTextArray() {
        String[] strs = this.splitText();
        return strs;
    }

    public String getTextFrom(int idx) {
        String[] strs = this.splitText();
        StringBuffer buffer = new StringBuffer();
        int cnt = idx;
        while (cnt < strs.length) {
            buffer.append(strs[cnt]);
            buffer.append(" ");
            ++cnt;
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public String getText(int from, int to) {
        String[] strs = this.splitText();
        StringBuffer buffer = new StringBuffer();
        int cnt = from;
        while (cnt < to - from) {
            buffer.append(strs[cnt]);
            buffer.append(" ");
            ++cnt;
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public String getText2() {
        String[] strs = this.splitText();
        StringBuffer buffer = new StringBuffer();
        int cnt = 0;
        while (cnt < strs.length - 1) {
            buffer.append(strs[cnt]);
            buffer.append(" ");
            ++cnt;
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public String getText2(int idx) {
        String[] strs = this.splitText();
        StringBuffer buffer = new StringBuffer();
        int len = strs.length < idx ? strs.length : idx;
        int cnt = 0;
        while (cnt < len) {
            buffer.append(strs[cnt]);
            buffer.append(" ");
            ++cnt;
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public int getTextFieldCount() {
        String[] strs = this.splitText();
        return strs.length;
    }

    public void setText(String name) {
        this.text = name;
    }

    public String[] toArray() {
        String[] strs = this.splitText();
        return strs;
    }

    public void setParent(PolicyElement e) {
        this.parent = e;
    }

    public PolicyElement getParent() {
        return this.parent;
    }

    public void addChild(PolicyElement e) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(e);
        e.setParent(this);
    }

    public void addChildren(PolicyElement[] childArray) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        int cnt = 0;
        while (cnt < childArray.length) {
            this.addChild(childArray[cnt]);
            ++cnt;
        }
    }

    public PolicyElement getChild(int i) {
        if (this.children == null) {
            return null;
        }
        return (PolicyElement)this.children.get(i);
    }

    public void setChild(int i, PolicyElement element) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.set(i, element);
        element.setParent(this);
    }

    public int getChildrenCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public List<PolicyElement> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    public PolicyElement within(int pos) {
        if (this.getOffset() <= pos && pos <= this.getOffset() + this.length()) {
            return this;
        }
        if (this.getOffset() > pos) {
            return null;
        }
        int cnt = 0;
        while (cnt < this.getChildrenCount()) {
            PolicyElement ret = this.getChild(cnt).within(pos);
            if (ret != null) {
                return ret;
            }
            ++cnt;
        }
        return null;
    }

    public void dump(int level) {
        StringBuffer suffix = new StringBuffer();
        int cnt = 0;
        while (cnt < level) {
            suffix.append(" ");
            ++cnt;
        }
        cnt = 0;
        while (cnt < this.getChildrenCount()) {
            this.getChild(cnt).dump(level + 1);
            ++cnt;
        }
    }

    public String toString() {
        return "class = " + this.getClass().getName() + ", name = " + this.getText() + ", child = " + this.getChildrenCount();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPropertySource.class)) {
            return this.getPropertySource();
        }
        return null;
    }

    public IPropertySource getPropertySource() {
        if (this.propertySource == null) {
            this.propertySource = this.createPropertySource();
        }
        return this.propertySource;
    }

    protected abstract IPropertySource createPropertySource();

    public String getDirective() {
        return this.getText(0);
    }

    public void setCreated(boolean b) {
        this.created = b;
        if (b) {
            this.deleted = !b;
        }
    }

    public boolean isCreated() {
        return this.created;
    }

    public void setChecked(boolean b) {
        this.checked = b;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setDeleted(boolean b) {
        this.deleted = b;
        if (b) {
            this.created = !b;
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    protected void _initialize() {
        this.setCreated(false);
        this.setChecked(false);
        this.setDeleted(false);
    }

    public void hookTraverse() {
        this._initialize();
    }
}

