/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

public class PolicyElementDefinition {
    private String directiveName;
    private Class<?> elementClass;
    private String caption;
    private Image image;
    private Class<?> propertySourceClass;
    private String[] versions;

    public PolicyElementDefinition(String directiveName, Class<?> elementClass, String caption, Image image, String[] versions) {
        this(directiveName, elementClass, caption, image, null, versions);
    }

    public PolicyElementDefinition(String directiveName, Class<?> elementClass, String caption, Image image, Class<?> propertySourceClass, String[] versions) {
        this.directiveName = directiveName;
        this.elementClass = elementClass;
        this.caption = caption;
        this.image = image;
        this.propertySourceClass = propertySourceClass;
        this.versions = versions;
    }

    public String getDirectiveName() {
        return this.directiveName;
    }

    public Class<?> getElementClass() {
        return this.elementClass;
    }

    public String getCaption() {
        return this.caption;
    }

    public Image getImage() {
        return this.image;
    }

    public Class<?> getPropertySourceClass() {
        return this.propertySourceClass;
    }

    public boolean isAvailableVersion(IProject project) {
        if (this.versions == null) {
            return false;
        }
        String checkVersion = Utilities.getTomoyoVersion((IProject)project);
        int cnt = 0;
        while (cnt < this.versions.length) {
            if (this.versions[cnt] != null && this.versions[cnt].equals(checkVersion)) {
                return true;
            }
            ++cnt;
        }
        return false;
    }

    public PolicyElement createElement(String strPerm, String line, int lineno, int column) {
        try {
            Constructor cunstructor = this.elementClass.getConstructor(String.class, Integer.TYPE, Integer.TYPE);
            return (PolicyElement)cunstructor.newInstance(line, new Integer(lineno), new Integer(column));
        }
        catch (SecurityException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
        catch (InstantiationException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
        return null;
    }

    public IPropertySource createPropertySource(PolicyElement element) {
        try {
            Constructor cunstructor = this.propertySourceClass.getConstructor(PolicyElement.class);
            return (IPropertySource)cunstructor.newInstance(element);
        }
        catch (SecurityException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
        catch (InstantiationException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
        return null;
    }

    public boolean isInstance(PolicyElement child) {
        if (child == null) {
            return false;
        }
        return this.elementClass.equals(child.getClass());
    }
}

