/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.model.domain;

import java.util.ArrayList;
import jp.sourceforge.tomoyo.core.local.model.AbstractDomainPolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Profile;
import jp.sourceforge.tomoyo.core.local.model.except.AbstractKeepDomainElement;
import jp.sourceforge.tomoyo.core.local.model.except.ConditionalElement;
import jp.sourceforge.tomoyo.core.ui.propertysheet.domain.DomainPropertySource;
import org.eclipse.ui.views.properties.IPropertySource;

public class Domain
extends AbstractDomainPolicyElement {
    private Profile profile;
    private ConditionalElement initializerTarget = null;
    private ConditionalElement initializerSource = null;
    private ArrayList<AccessPermission> initializerExecutables = new ArrayList();
    private ArrayList<AbstractKeepDomainElement> keepDomainList = new ArrayList(0);
    public static final int REACHABLE = 0;
    public static final int UNREACHABLE_REASON_NO_PARENTS = 1;
    public static final int UNREACHABLE_REASON_PARENT_UNREACHABLE = 2;
    public static final int UNREACHABLE_REASON_PARENT_KEPTDOMAIN = 3;
    public static final int UNREACHABLE_REASON_PARENT_INITIALIZED = 4;
    public static final int UNREACHABLE_REASON_INITIALIZED = 5;
    private int unreachableReason;
    private boolean skelton = false;
    private boolean initialized = false;

    public Domain(String name, int line, int column) {
        super(name, line, column);
    }

    public Profile getProfile() {
        return this.profile;
    }

    public int getDepth() {
        return this.getTextFieldCount();
    }

    public String getDomain(int depth) {
        if (depth < 1 || depth > this.getDepth()) {
            throw new IllegalArgumentException("Specified depth " + depth + " is out of bounds.");
        }
        StringBuffer buffer = new StringBuffer();
        int cnt = 0;
        while (cnt < depth) {
            buffer.append(this.getText(cnt));
            if (cnt < depth - 1) {
                buffer.append(" ");
            }
            ++cnt;
        }
        return buffer.toString();
    }

    public String getProcessName() {
        return this.getText(this.getDepth() - 1);
    }

    public boolean hasChildDomain() {
        int cnt = 0;
        while (cnt < this.getChildrenCount()) {
            Domain domain;
            if (this.getChild(cnt) instanceof Domain && !(domain = (Domain)this.getChild(cnt)).isDeleted()) {
                return true;
            }
            ++cnt;
        }
        return false;
    }

    public void addChild(PolicyElement e) {
        if (e instanceof Profile) {
            this.profile = (Profile)e;
            int cnt = 0;
            while (cnt < this.getChildrenCount()) {
                if (this.getChild(cnt) instanceof Profile) {
                    this.setChild(cnt, e);
                    return;
                }
                ++cnt;
            }
        }
        super.addChild(e);
    }

    public void setInitializerTarget(ConditionalElement initializer) {
        this.initializerTarget = initializer;
    }

    public boolean isInitializerTarget() {
        return this.initializerTarget != null;
    }

    public ConditionalElement getInitializerTarget() {
        return this.initializerTarget;
    }

    public boolean isInitializerSource() {
        return this.initializerSource != null;
    }

    public void setInitializerSource(ConditionalElement initializer) {
        this.initializerSource = initializer;
    }

    public void addInitializerExecutable(AccessPermission executable) {
        this.initializerExecutables.add(executable);
    }

    public boolean hasInitializerExecutable() {
        return this.initializerExecutables.size() > 0;
    }

    public ArrayList<AccessPermission> getInitializerExecutables() {
        return this.initializerExecutables;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Domain) {
            Domain target = (Domain)obj;
            String path1 = target.getText();
            String path2 = this.getText();
            if (path1 == null || path2 == null) {
                return false;
            }
            return path1.equals(path2);
        }
        return false;
    }

    public boolean isKernel() {
        return this.getDepth() == 1;
    }

    public void addKeepDomain(AbstractKeepDomainElement keepDomain) {
        this.keepDomainList.add(keepDomain);
    }

    public boolean isKeepDomain() {
        return this.keepDomainList.size() > 0;
    }

    public void clearKeepDomain() {
        this.keepDomainList.clear();
    }

    public ArrayList<AbstractKeepDomainElement> getKeepDomainList() {
        return this.keepDomainList;
    }

    public boolean isReachable() {
        return this.unreachableReason == 0;
    }

    public void setUnreachableReason(int reasonID) {
        this.unreachableReason = reasonID;
    }

    public int getUnreachableReason() {
        return this.unreachableReason;
    }

    protected void _initialize() {
        super._initialize();
        this.setSkelton(false);
        this.initializerExecutables.clear();
        this.setInitializerTarget(null);
        this.clearKeepDomain();
    }

    public boolean isSkelton() {
        return this.skelton;
    }

    public void setSkelton(boolean b) {
        this.skelton = b;
    }

    public void setinitialized(boolean b) {
        this.initialized = b;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected IPropertySource createPropertySource() {
        return new DomainPropertySource((PolicyElement)this);
    }
}

