/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.model.status;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Observable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.local.model.status.Profile;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileDefinition;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileGroup;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileMetaData;
import jp.sourceforge.tomoyo.core.local.model.status.ProjectProfile;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.local.resource.Status;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.ConcreteCommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ProjectProfile
extends Observable {
    private Hashtable<String, ProfileGroup> profileGroups = new Hashtable();
    private IProject project;

    public ProjectProfile(IProject project) {
        this.project = project;
    }

    public void load() {
        this.updateCache();
    }

    private void updateCache() {
        try {
            IFile file = ProcResourceManager.getInstance().getProcResourceSet(this.project).getStatus().getFile();
            this.updateCache(new InputStreamReader(file.getContents()));
        }
        catch (CoreException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
    }

    private void updateCache(String stdout) {
        this.updateCache(new InputStreamReader(new ByteArrayInputStream(stdout.getBytes())));
    }

    private void updateCache(InputStreamReader reader) {
        this.profileGroups.clear();
        BufferedReader br = new BufferedReader(reader);
        try {
            String line = null;
            Pattern pattern = Pattern.compile("^([0-9]+)-([a-zA-Z0-9:_]+)=(.+)$");
            while ((line = br.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.matches()) continue;
                String strGroupNo = matcher.group(1);
                String strProfileName = matcher.group(2);
                String strProfileValue = matcher.group(3);
                ProfileGroup group = (ProfileGroup)this.profileGroups.get(strGroupNo);
                if (group == null) {
                    group = new ProfileGroup(Integer.parseInt(strGroupNo));
                    this.profileGroups.put(strGroupNo, group);
                }
                group.storeProfileValue(strProfileName, strProfileValue);
            }
        }
        catch (IOException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
    }

    public ProfileGroup getGroup(int groupNo) {
        return (ProfileGroup)this.profileGroups.get(String.valueOf(groupNo));
    }

    public ProfileGroup createGroup(int groupNo) {
        ProfileGroup group = (ProfileGroup)this.profileGroups.get(String.valueOf(groupNo));
        if (group == null) {
            group = new ProfileGroup(groupNo);
            this.profileGroups.put(String.valueOf(groupNo), group);
        }
        return group;
    }

    public int getGroupCount() {
        return this.profileGroups.keySet().size();
    }

    public ArrayList<ProfileGroup> toList(boolean sort) {
        ArrayList<ProfileGroup> groupList = new ArrayList<ProfileGroup>();
        groupList.addAll(this.profileGroups.values());
        if (sort) {
            Collections.sort(groupList, new GroupComparator(this, null));
        }
        return groupList;
    }

    public ProfileGroup[] toArray(boolean sort) {
        ArrayList groupList = this.toList(sort);
        return groupList.toArray(new ProfileGroup[groupList.size()]);
    }

    public ProfileGroup getGroupByIndex(int index) {
        return this.toArray(true)[index];
    }

    public boolean save() {
        ProfileGroup[] groups = this.toArray(false);
        ArrayList<String> saveLines = new ArrayList<String>();
        int cnt = 0;
        while (cnt < groups.length) {
            ProfileGroup group = groups[cnt];
            Profile[] profiles = group.listProfile();
            int pcnt = 0;
            while (pcnt < profiles.length) {
                Profile profile = profiles[pcnt];
                if (profile != null && profile.isDirty()) {
                    ProfileMetaData metaData = ProfileDefinition.getMetaData((int)profile.getIndex());
                    if (profile.needQuate()) {
                        saveLines.add(String.valueOf(group.getNo()) + "-" + metaData.getName() + "=" + "\"" + profile.getValue() + "\"");
                    } else {
                        saveLines.add(String.valueOf(group.getNo()) + "-" + metaData.getName() + "=" + profile.getValue());
                    }
                }
                ++pcnt;
            }
            ++cnt;
        }
        if (saveLines.size() == 0) {
            return false;
        }
        boolean isSaved = this.save(saveLines.toArray(new String[saveLines.size()]));
        return isSaved;
    }

    private boolean save(String[] lines) {
        ConcreteCommand command = CommandManager.getInstance().exec(this.project, CommandManager.createCCSToolPath((IProject)this.project, (String)"setlevel"), null, lines);
        if (!command.isSuccessful()) {
            return false;
        }
        Status status = ProcResourceManager.getInstance().getProcResourceSet(this.project).getStatus();
        ProcResourceManager.getInstance().synchronize(this.project, (LocalResource)status);
        this.notifyUpdate();
        this.updateCache(command.getSTDOut());
        return true;
    }

    private void notifyUpdate() {
        this.setChanged();
        this.notifyObservers(this.createNotificationObject());
    }

    private Object createNotificationObject() {
        Hashtable<Class<IProject>, IProject> table = new Hashtable<Class<IProject>, IProject>();
        table.put(IProject.class, this.project);
        return table;
    }

    public void setUpdate() {
        this.notifyUpdate();
    }

    public boolean hasDirty() {
        ProfileGroup[] groups = this.toArray(false);
        int cnt = 0;
        while (cnt < groups.length) {
            ProfileGroup group = groups[cnt];
            Profile[] profiles = group.listProfile();
            int pcnt = 0;
            while (pcnt < profiles.length) {
                Profile profile = profiles[pcnt];
                if (profile != null && profile.isDirty()) {
                    return true;
                }
                ++pcnt;
            }
            ++cnt;
        }
        return false;
    }

    public int getNewGroupNo() {
        int newNo = 0;
        ProfileGroup[] groups = this.toArray(false);
        int cnt = 0;
        while (cnt < groups.length) {
            ProfileGroup group = groups[cnt];
            if (newNo <= group.getNo()) {
                newNo = group.getNo() + 1;
            }
            ++cnt;
        }
        return newNo;
    }

    public void rollback() {
        ProfileGroup[] groups = this.toArray(false);
        int cnt = 0;
        while (cnt < groups.length) {
            ProfileGroup group = groups[cnt];
            Profile[] profiles = group.listProfile();
            int pcnt = 0;
            while (pcnt < profiles.length) {
                Profile profile = profiles[pcnt];
                if (profile != null) {
                    profile.rollback();
                }
                ++pcnt;
            }
            ++cnt;
        }
    }
}

