/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.local.model.AbstractPolicyModel;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.model.domain.Profile;
import jp.sourceforge.tomoyo.core.local.model.domain.Rwx_1;
import jp.sourceforge.tomoyo.core.local.model.domain.Rwx_3;
import jp.sourceforge.tomoyo.core.local.model.domain.Rwx_5;
import jp.sourceforge.tomoyo.core.local.model.domain.Rwx_7;
import jp.sourceforge.tomoyo.core.local.model.except.AbstractKeepDomainElement;
import jp.sourceforge.tomoyo.core.local.model.except.ConditionalElement;
import jp.sourceforge.tomoyo.core.local.model.except.InitializeDomain;
import jp.sourceforge.tomoyo.core.local.model.except.Initializer;
import jp.sourceforge.tomoyo.core.local.model.except.KeepDomain;
import jp.sourceforge.tomoyo.core.local.model.except.NoInitializeDomain;
import jp.sourceforge.tomoyo.core.local.model.except.NoInitializer;
import jp.sourceforge.tomoyo.core.local.model.except.NoKeepDomain;
import jp.sourceforge.tomoyo.core.local.parser.PolicyParser;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import org.eclipse.core.resources.IProject;

public class DomainPolicyParser
extends PolicyParser {
    public static Pattern DomainPattern = Pattern.compile("^<kernel>.*");
    public static Pattern ProfilePattern = Pattern.compile("^use_profile[\\s]+([0-9]+)");
    private Domain cacheParentDomain;

    public DomainPolicyParser(LocalResource localResource) {
        super(localResource);
    }

    protected PolicyElement parseLine(AbstractPolicyModel model, String line, int lineno, int column) {
        Matcher domainMatcher = DomainPattern.matcher(line);
        if (domainMatcher.matches()) {
            this.cacheParentDomain = (Domain)PolicyCacheManager.getInstance().findElement(model.getProject(), Domain.class, line);
            if (this.cacheParentDomain == null) {
                this.cacheParentDomain = new Domain(line, lineno, column);
                this.cacheParentDomain.setCreated(model.isValid());
                model.addChild((PolicyElement)this.cacheParentDomain);
                PolicyCacheManager.getInstance().addElement(model.getProject(), (PolicyElement)this.cacheParentDomain);
            } else {
                this.cacheParentDomain.setLineno(lineno);
                this.cacheParentDomain.setOffset(column);
                this.cacheParentDomain.setCreated(false);
            }
            this.cacheParentDomain.setChecked(true);
            return this.cacheParentDomain;
        }
        Matcher accessMatcher = this.getMatchingPattern().matcher(line);
        if (accessMatcher.matches() && this.cacheParentDomain != null) {
            String directive = accessMatcher.group(1);
            AccessPermission permission = PolicyCacheManager.getInstance().findAccessPermission(model.getProject(), this.cacheParentDomain, line);
            if (permission == null) {
                permission = (AccessPermission)this.getLocalResource().getModel().getDefinitionByDirective(directive).createElement(directive, line, lineno, column);
                permission.setCreated(model.isValid());
                if (permission != null) {
                    this.cacheParentDomain.addChild((PolicyElement)permission);
                    PolicyCacheManager.getInstance().addElement(model.getProject(), (PolicyElement)permission);
                }
                if (permission == null) {
                    TomoyoCorePlugin.logErrorMessage((String)("Unexpacted line:" + line));
                }
            } else {
                permission.setLineno(lineno);
                permission.setOffset(column);
                permission.setCreated(permission.isDeleted());
            }
            permission.setChecked(true);
            return permission;
        }
        Matcher profileMatcher = ProfilePattern.matcher(line);
        if (profileMatcher.matches() && this.cacheParentDomain != null) {
            Profile profile = new Profile(line, lineno, column);
            this.cacheParentDomain.addChild((PolicyElement)profile);
            profile.setChecked(true);
        }
        return null;
    }

    protected void handleParseAboutToStart() {
    }

    protected void handleParseCompleted() {
        IProject project = this.getLocalResource().getProject();
        PolicyCacheManager.getInstance().createDomainTranstion(project);
        this.decorateDomain(project);
    }

    private void decorateDomain(IProject project) {
        PolicyElement[] domains = PolicyCacheManager.getInstance().findElements(project, Domain.class);
        if (domains == null) {
            return;
        }
        this.decorateInitializer(project, domains);
        this.decorateKeepDomain(project, domains);
        this.decorateReachablePossibility(project, domains);
    }

    private void decorateInitializer(IProject project, PolicyElement[] domains) {
        PolicyElement[] no_initializers = PolicyCacheManager.getInstance().findElements(project, new Class[]{NoInitializer.class, NoInitializeDomain.class});
        no_initializers = this.filterUnchecked(no_initializers);
        PolicyElement[] initializers = PolicyCacheManager.getInstance().findElements(project, new Class[]{Initializer.class, InitializeDomain.class});
        initializers = this.filterDuplication(initializers);
        initializers = this.filterUnchecked(initializers);
        initializers = this.filterOverwrides(initializers, no_initializers);
        this.decorateInitializerTarget(project, domains, initializers);
        this.decorateInitializerSource(project, initializers);
    }

    private void decorateKeepDomain(IProject project, PolicyElement[] domains) {
        PolicyElement[] noKeepDomains = PolicyCacheManager.getInstance().findElements(project, NoKeepDomain.class);
        noKeepDomains = this.filterUnchecked(noKeepDomains);
        PolicyElement[] keepDomains = PolicyCacheManager.getInstance().findElements(project, KeepDomain.class);
        keepDomains = this.filterDuplication(keepDomains);
        keepDomains = this.filterUnchecked(keepDomains);
        keepDomains = this.filterOverwrides(keepDomains, noKeepDomains);
        int dcnt = 0;
        while (dcnt < domains.length) {
            Domain domain = (Domain)domains[dcnt];
            domain.clearKeepDomain();
            if (!domain.isDeleted()) {
                String domainText = domain.getText();
                int kcnt = 0;
                while (kcnt < keepDomains.length) {
                    ConditionalElement initializer = (ConditionalElement)keepDomains[kcnt];
                    String strKeepDomain = initializer.getTarget();
                    if (domainText.equals(strKeepDomain)) {
                        if (!initializer.hasCondition()) {
                            domain.addKeepDomain((AbstractKeepDomainElement)initializer);
                            break;
                        }
                        int cnt = 0;
                        while (cnt < domain.getChildrenCount()) {
                            if (domain.getChild(cnt) instanceof AccessPermission) {
                                AccessPermission permission = (AccessPermission)domain.getChild(cnt);
                                if (initializer.getCondition().equals(permission.getContents())) {
                                    domain.addKeepDomain((AbstractKeepDomainElement)initializer);
                                    break;
                                }
                            }
                            ++cnt;
                        }
                    }
                    ++kcnt;
                }
            }
            ++dcnt;
        }
    }

    private void decorateInitializerTarget(IProject project, PolicyElement[] domains, PolicyElement[] initializers) {
        int cnt = 0;
        while (cnt < domains.length) {
            Domain domain = (Domain)domains[cnt];
            if (!domain.isDeleted() && domain.getDepth() <= 2) {
                domain.setInitializerTarget(null);
                if (initializers == null) {
                    return;
                }
                String processName = domain.getProcessName();
                int pcnt = 0;
                while (pcnt < initializers.length) {
                    ConditionalElement initializer = (ConditionalElement)initializers[pcnt];
                    if (processName.equals(initializer.getTarget())) {
                        domain.setInitializerTarget(initializer);
                        PolicyCacheManager.getInstance().addInitializerTarget(project, domain);
                        break;
                    }
                    ++pcnt;
                }
            }
            ++cnt;
        }
    }

    private void decorateInitializerSource(IProject project, PolicyElement[] initializers) {
        PolicyElement[] domains = PolicyCacheManager.getInstance().findElements(project, Domain.class);
        PolicyElement[] executables = PolicyCacheManager.getInstance().findElements(project, new Class[]{Rwx_1.class, Rwx_3.class, Rwx_5.class, Rwx_7.class});
        int cnt = 0;
        while (cnt < initializers.length) {
            ConditionalElement initializer = (ConditionalElement)initializers[cnt];
            int ecnt = 0;
            while (ecnt < executables.length) {
                AccessPermission executable = (AccessPermission)executables[ecnt];
                Domain executableDomain = (Domain)executable.getParent();
                if (this.isInitizlizerSource(executable, initializer)) {
                    executable.setInitializerSource(true);
                    executableDomain.addInitializerExecutable(executable);
                }
                ++ecnt;
            }
            int dcnt = 0;
            while (dcnt < domains.length) {
                Domain domain = (Domain)domains[dcnt];
                if (domain.getDepth() >= 3 && this.isInitizlizerSource(domain, initializer)) {
                    domain.setInitializerSource(initializer);
                }
                ++dcnt;
            }
            ++cnt;
        }
    }

    private boolean isInitizlizerSource(Domain domain, ConditionalElement initializer) {
        String executableText = domain.getProcessName();
        if (executableText.equals(initializer.getTarget())) {
            if (initializer.hasCondition()) {
                String condition = initializer.getCondition();
                if (initializer.isConditionDomain() ? domain.getText().equals(condition) : domain.getProcessName().equals(condition)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean isInitizlizerSource(AccessPermission executable, ConditionalElement initializer) {
        String executableText = executable.getContents();
        Domain executableDomain = (Domain)executable.getParent();
        if (executableText.equals(initializer.getTarget())) {
            if (initializer.hasCondition()) {
                String condition = initializer.getCondition();
                if (initializer.isConditionDomain() ? executableDomain.getText().equals(condition) : executableDomain.getProcessName().equals(condition)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private PolicyElement[] filterDuplication(PolicyElement[] initializers) {
        Hashtable<String, ConditionalElement> table = new Hashtable<String, ConditionalElement>();
        int cnt = 0;
        while (cnt < initializers.length) {
            ConditionalElement initializer = (ConditionalElement)initializers[cnt];
            table.put(initializer.getContents(), initializer);
            ++cnt;
        }
        Collection c = table.values();
        return c.toArray(new PolicyElement[c.size()]);
    }

    private PolicyElement[] filterUnchecked(PolicyElement[] initializers) {
        Hashtable<String, ConditionalElement> table = new Hashtable<String, ConditionalElement>();
        int cnt = 0;
        while (cnt < initializers.length) {
            ConditionalElement initializer = (ConditionalElement)initializers[cnt];
            if (!initializer.isDeleted()) {
                table.put(initializer.getContents(), initializer);
            }
            ++cnt;
        }
        Collection c = table.values();
        return c.toArray(new PolicyElement[c.size()]);
    }

    private PolicyElement[] filterOverwrides(PolicyElement[] initializers, PolicyElement[] no_initializers) {
        Hashtable<String, ConditionalElement> table = new Hashtable<String, ConditionalElement>();
        int cnt = 0;
        while (cnt < initializers.length) {
            ConditionalElement initializer = (ConditionalElement)initializers[cnt];
            if (!this.isOverwrided(initializer, no_initializers)) {
                table.put(initializer.getContents(), initializer);
            }
            ++cnt;
        }
        Collection c = table.values();
        return c.toArray(new PolicyElement[c.size()]);
    }

    private boolean isOverwrided(ConditionalElement initializer, PolicyElement[] no_initializers) {
        int ecnt = 0;
        while (ecnt < no_initializers.length) {
            ConditionalElement no_initializer = (ConditionalElement)no_initializers[ecnt];
            if (no_initializer.hasCondition() ? (no_initializer.isConditionDomain() ? initializer.getCondition().equals(no_initializer.getCondition()) : initializer.getContents().equals(no_initializer.getContents())) : initializer.getTarget().equals(no_initializer.getContents())) {
                return true;
            }
            ++ecnt;
        }
        return false;
    }

    private void decorateReachablePossibility(IProject project, PolicyElement[] domains) {
        int cnt = 0;
        while (cnt < domains.length) {
            Domain domain = (Domain)domains[cnt];
            Domain parentDomain = PolicyCacheManager.getInstance().getParentDomain(project, domain);
            this.decorateReachablePossibility(parentDomain, domain);
            ++cnt;
        }
    }

    private void decorateReachablePossibility(Domain parentDomain, Domain domain) {
        if (domain.getDepth() == 1) {
            domain.setUnreachableReason(0);
            return;
        }
        if (parentDomain == null) {
            domain.setUnreachableReason(1);
            return;
        }
        if (domain.getDepth() > 2) {
            if (domain.isInitializerSource()) {
                domain.setUnreachableReason(5);
                return;
            }
            if (parentDomain.isInitializerSource()) {
                domain.setUnreachableReason(4);
                return;
            }
        }
        if (parentDomain.isInitializerTarget() && parentDomain.getDepth() > 2) {
            domain.setUnreachableReason(5);
            return;
        }
        if (this.isKeptDomain(parentDomain, domain)) {
            domain.setUnreachableReason(3);
            return;
        }
        if (!parentDomain.isReachable()) {
            domain.setUnreachableReason(2);
            return;
        }
        domain.setUnreachableReason(0);
    }

    private boolean isKeptDomain(Domain parentDomain, Domain domain) {
        ArrayList keepDomainList = parentDomain.getKeepDomainList();
        if (parentDomain.isKeepDomain()) {
            int cnt = 0;
            while (cnt < keepDomainList.size()) {
                AbstractKeepDomainElement keepDomain = (AbstractKeepDomainElement)keepDomainList.get(cnt);
                if (keepDomain.getTarget().equals(parentDomain.getText())) {
                    if (keepDomain.hasCondition()) {
                        String conditionText = keepDomain.getCondition();
                        if (keepDomain.isConditionDomain() ? domain.getText().equals(conditionText) : domain.getProcessName().equals(conditionText)) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                ++cnt;
            }
        }
        return false;
    }
}

