/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.parser;

import java.util.regex.Matcher;
import jp.sourceforge.tomoyo.core.local.model.AbstractPolicyModel;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.core.local.parser.PolicyParser;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;

public class ExceptPolicyParser
extends PolicyParser {
    public ExceptPolicyParser(LocalResource localResource) {
        super(localResource);
    }

    protected void handleParseAboutToStart() {
    }

    protected PolicyElement parseLine(AbstractPolicyModel model, String line, int lineno, int column) {
        PolicyElement retElement = null;
        Matcher matcher = this.getMatchingPattern().matcher(line);
        if (matcher.matches()) {
            String directive = matcher.group(1);
            PolicyElementDefinition definition = this.getLocalResource().getModel().getDefinitionByDirective(directive);
            if (definition == null) {
                return null;
            }
            PolicyElement element = PolicyCacheManager.getInstance().findElement(model.getProject(), definition.getElementClass(), line);
            if (element == null) {
                element = definition.createElement(directive, line, lineno, column);
                element.setCreated(model.isValid());
                PolicyCacheManager.getInstance().addElement(model.getProject(), element);
                model.addChild(element);
            } else {
                element.setLineno(lineno);
                element.setOffset(column);
                element.setCreated(false);
            }
            element.setChecked(true);
            retElement = element;
        }
        return retElement;
    }

    protected void handleParseCompleted() {
    }
}

