/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.parser;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.local.model.AbstractPolicyModel;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.texteditor.MarkerUtilities;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class PolicyParser {
    private LocalResource localResource;
    private Pattern matchingPattern = null;

    public PolicyParser(LocalResource localResource) {
        this.localResource = localResource;
        this.matchingPattern = Pattern.compile("^(" + PolicyParser.getOrPattern((String[])localResource.getModel().listSupportedDirectives()) + ")[\\s]+(.*)");
    }

    protected Pattern getMatchingPattern() {
        return this.matchingPattern;
    }

    protected LocalResource getLocalResource() {
        return this.localResource;
    }

    protected boolean parse() {
        IFile file = this.localResource.getFile();
        AbstractPolicyModel model = this.localResource.getModel();
        this.handleParseAboutToStart();
        BufferedReader bufferdReader = null;
        InputStreamReader reader = null;
        try {
            try {
                String line;
                model.initialize();
                reader = new InputStreamReader(file.getContents());
                bufferdReader = new BufferedReader(reader);
                int lineno = 0;
                int offset = 0;
                while ((line = bufferdReader.readLine()) != null) {
                    PolicyElement policyElement = this.parseLine(model, line, ++lineno, offset);
                    offset += line.length() + 1;
                }
                model.setValid(true);
                model.setSize(offset);
                ArrayList<PolicyElement> notifyElementList = new ArrayList<PolicyElement>();
                PolicyElement[] elements = model.getElementArray();
                int cnt = 0;
                while (cnt < elements.length) {
                    PolicyElement element = elements[cnt];
                    if (element.isCreated()) {
                        notifyElementList.add(element);
                    } else if (!element.isDeleted() && !element.isChecked()) {
                        element.setDeleted(true);
                        notifyElementList.add(element);
                    }
                    ++cnt;
                }
                this.updateMarker(this.localResource);
                this.handleParseCompleted();
            }
            catch (Exception e) {
                model.setValid(false);
                TomoyoCorePlugin.logException((Throwable)e);
                try {
                    if (bufferdReader != null) {
                        bufferdReader.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (bufferdReader != null) {
                    bufferdReader.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    private void updateMarker(LocalResource localResource) {
        IFile resource = localResource.getFile();
        try {
            resource.deleteMarkers(null, true, 0);
        }
        catch (CoreException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
        try {
            PolicyElement[] elements = PolicyCacheManager.getInstance().findElements(resource.getProject(), localResource.getModel().getClass());
            if (elements == null) {
                return;
            }
            int cnt = 0;
            while (cnt < elements.length) {
                block12: {
                    PolicyElement element = elements[cnt];
                    if (element.hasNote()) {
                        HashMap<String, Integer> attributes = new HashMap<String, Integer>();
                        MarkerUtilities.setCharStart(attributes, (int)element.getOffset());
                        MarkerUtilities.setCharEnd(attributes, (int)(element.getOffset() + 1));
                        MarkerUtilities.setLineNumber(attributes, (int)element.getLine());
                        MarkerUtilities.setMessage(attributes, (String)element.getNote());
                        switch (element.getNoteID()) {
                            case 1: {
                                attributes.put("severity", new Integer(0));
                                break;
                            }
                            case 2: {
                                attributes.put("severity", new Integer(1));
                                break;
                            }
                            case 3: {
                                attributes.put("severity", new Integer(2));
                                break;
                            }
                            default: {
                                break block12;
                            }
                        }
                        MarkerUtilities.createMarker((IResource)resource, attributes, (String)"org.eclipse.core.resources.problemmarker");
                    }
                }
                ++cnt;
            }
        }
        catch (CoreException e) {
            TomoyoCorePlugin.logException((Throwable)e);
        }
    }

    protected abstract PolicyElement parseLine(AbstractPolicyModel var1, String var2, int var3, int var4);

    protected abstract void handleParseAboutToStart();

    protected abstract void handleParseCompleted();

    protected static String getOrPattern(String[] pats) {
        StringBuffer buffer = new StringBuffer();
        int cnt = 0;
        while (cnt < pats.length) {
            buffer.append(pats[cnt]);
            buffer.append("|");
            ++cnt;
        }
        return buffer.deleteCharAt(buffer.length() - 1).toString();
    }
}

