/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.parser;

import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.parser.DomainPolicyParser;
import jp.sourceforge.tomoyo.core.local.parser.ExceptPolicyParser;
import jp.sourceforge.tomoyo.core.local.parser.PolicyParser;
import jp.sourceforge.tomoyo.core.local.parser.SystemPolicyParser;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.ExceptPolicy;
import jp.sourceforge.tomoyo.core.local.resource.IPolicy;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceSet;
import jp.sourceforge.tomoyo.core.local.resource.SystemPolicy;
import org.eclipse.core.resources.IProject;

public class PolicyParserManager
extends Observable
implements Observer {
    private static PolicyParserManager instance = null;

    private PolicyParserManager() {
    }

    public static PolicyParserManager getInstance() {
        if (instance == null) {
            instance = new PolicyParserManager();
            ProcResourceManager.getInstance().addObserver((Observer)instance);
        }
        return instance;
    }

    public void preload(IProject project) {
        ProcResourceSet resource = ProcResourceManager.getInstance().getProcResourceSet(project);
        if (resource.hasPolicies()) {
            if (resource.isLoading() || resource.isLoaded()) {
                return;
            }
            resource.setLoading(true);
            if (Utilities.is20((IProject)project)) {
                this.parse((LocalResource)resource.getExceptPolicy());
                this.parse((LocalResource)resource.getDomainPolicy());
            } else {
                this.parse((LocalResource)resource.getExceptPolicy());
                this.parse((LocalResource)resource.getDomainPolicy());
                this.parse((LocalResource)resource.getSystemPolicy());
            }
            resource.setLoading(false);
        }
    }

    private void parse(LocalResource localResource) {
        PolicyParser parser;
        boolean isParsed;
        if (localResource instanceof IPolicy && (isParsed = (parser = this.createParser(localResource)).parse())) {
            this.setChanged();
            this.notifyObservers((Object)localResource);
        }
    }

    private PolicyParser createParser(LocalResource localResource) {
        DomainPolicyParser parser = null;
        if (localResource instanceof DomainPolicy) {
            parser = new DomainPolicyParser(localResource);
        }
        if (localResource instanceof ExceptPolicy) {
            parser = new ExceptPolicyParser(localResource);
        }
        if (localResource instanceof SystemPolicy) {
            parser = new SystemPolicyParser(localResource);
        }
        if (parser == null) {
            throw new IllegalArgumentException("invalid resource to parse : " + localResource);
        }
        return parser;
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg0 instanceof ProcResourceManager) {
            LocalResource localResource = (LocalResource)arg1;
            this.parse(localResource);
            if (localResource instanceof ExceptPolicy) {
                DomainPolicy domainPolicy = ProcResourceManager.getInstance().getProcResourceSet(localResource.getProject()).getDomainPolicy();
                this.parse((LocalResource)domainPolicy);
            }
        }
    }
}

