/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Observable;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.Messages;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceSet;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.ReadCommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ProcResourceManager
extends Observable {
    private static ProcResourceManager instance;
    private static Hashtable<IProject, ProcResourceSet> projectCache;

    static {
        projectCache = new Hashtable();
    }

    public static ProcResourceManager getInstance() {
        if (instance == null) {
            instance = new ProcResourceManager();
        }
        return instance;
    }

    public ProcResourceSet getProcResourceSet(IProject project) {
        if (projectCache.get(project) == null) {
            ProcResourceSet pr = new ProcResourceSet(project);
            projectCache.put(project, pr);
        }
        return (ProcResourceSet)projectCache.get(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean synchronize(IProject project, LocalResource localResource) {
        ProcResourceManager procResourceManager = this;
        synchronized (procResourceManager) {
            TomoyoCorePlugin.getDefault().setStatusMessage(Messages.ProcResourceManager_StatusMessageSyncronizing, true);
            try {
                ReadCommand rCommand = CommandManager.getInstance().read(project, localResource);
                if (rCommand.isSuccessful()) {
                    IFile localFile = localResource.getFile();
                    localFile.delete(true, true, null);
                    localFile.create((InputStream)new ByteArrayInputStream(rCommand.getSTDOut().getBytes()), true, null);
                    this.setChanged();
                    this.notifyObservers((Object)localResource);
                }
            }
            catch (CoreException e) {
                TomoyoCorePlugin.getDefault().setStatusErrorMessage(Messages.ProcResourceManager_StatusErrorMessageSyncronizing);
                TomoyoCorePlugin.logException((Throwable)e);
                return false;
            }
            TomoyoCorePlugin.getDefault().setStatusMessage(Messages.ProcResourceManager_StatusMessageSynchronized, true);
            return true;
        }
    }
}

