/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.server;

import java.util.Observable;
import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.extensions.IConnectionAdapter;
import jp.sourceforge.tomoyo.core.local.resource.IProcFile;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.server.ConcreteCommand;
import jp.sourceforge.tomoyo.core.server.ICommand;
import jp.sourceforge.tomoyo.core.server.ReadCommand;
import jp.sourceforge.tomoyo.core.server.WriteCommand;
import org.eclipse.core.resources.IProject;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommandManager
extends Observable {
    public static final String CMD_CCSTREE = "ccstree";
    public static final String CMD_SETLEVEL = "setlevel";
    public static final String CMD_SETPROFILE = "setprofile";
    public static final String CMD_SAVEPOLICY = "savepolicy";
    public static final String CMD_LOADPOLICY = "loadpolicy";
    public static final String CMD_EDITPOLICY = "editpolicy";
    public static final String CMD_SORTPOLICY = "sortpolicy";
    public static final String CMD_SYSTEM_LN = "ln";
    public static final String CMD_SYSTEM_SORT = "sort";
    private static CommandManager instance;
    private static final String SERVER_PATH_DELIMITER = "/";

    public static CommandManager getInstance() {
        if (instance == null) {
            instance = new CommandManager();
        }
        return instance;
    }

    public ConcreteCommand exec(IProject project, String strCommand) {
        return this.exec(project, strCommand, null, null, new int[1]);
    }

    public ConcreteCommand exec(IProject project, String strCommand, String[] options, String[] args) {
        return this.exec(project, strCommand, options, args, new int[1]);
    }

    public ConcreteCommand exec(IProject project, String strCommand, String[] options, String[] args, int[] okSystemCodes) {
        ConcreteCommand command = new ConcreteCommand(project, strCommand, options, args, okSystemCodes);
        IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter((IProject)command.getProject());
        if (!connectionMgr.exec(command)) {
            TomoyoCorePlugin.logErrorMessage((String)("Command exec failure : status = " + command.getSystemStatusCode() + " cmd = " + command.toString()));
        }
        this.notifyResult((ICommand)command);
        return command;
    }

    public ReadCommand read(IProject project, LocalResource localResource) {
        return this.read(project, CommandManager.getServerProcPath((LocalResource)localResource), localResource.getSorterCommand());
    }

    public ReadCommand read(IProject project, String source) {
        return this.read(project, source, null);
    }

    public ReadCommand read(IProject project, String source, String sorterCommand) {
        ReadCommand command = new ReadCommand(project, source, sorterCommand);
        IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter((IProject)command.getProject());
        if (!connectionMgr.read(command)) {
            TomoyoCorePlugin.logErrorMessage((String)("Command exec failure : status = " + command.getSystemStatusCode() + " cmd = " + command.toString()));
        }
        this.notifyResult((ICommand)command);
        return command;
    }

    public WriteCommand write(IProject project, LocalResource localResource, String inputText) {
        return this.write(project, CommandManager.getServerProcPath((LocalResource)localResource), inputText, false);
    }

    public WriteCommand write(IProject project, String target, String inputText) {
        return this.write(project, target, inputText, false);
    }

    public WriteCommand write(IProject project, String target, String inputText, boolean append) {
        return this.write(project, target, inputText, append, null);
    }

    public WriteCommand write(IProject project, String target, String inputText, boolean append, String filter) {
        WriteCommand wCommand = new WriteCommand(project, target, inputText, append);
        wCommand.setFilter(filter);
        IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter((IProject)wCommand.getProject());
        if (!connectionMgr.write(wCommand)) {
            TomoyoCorePlugin.logErrorMessage((String)("Command exec failure : status = " + wCommand.getSystemStatusCode() + " cmd = " + wCommand.toString()));
        }
        this.notifyResult((ICommand)wCommand);
        return wCommand;
    }

    public String getSelfDomain(IProject project) {
        IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter((IProject)project);
        return connectionMgr.getSelfDomain(project);
    }

    private void notifyResult(ICommand command) {
        this.setChanged();
        this.notifyObservers((Object)command);
    }

    public static String createCCSToolPath(IProject project, String toolName) {
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(project);
        return CommandManager.concatServerPath((String)properties.getProperty(PersistentPropertyManager.PROPERTY_CCS_TOOL_DIRECTORY), (String)toolName);
    }

    public static String createCCSDataPath(IProject project, String fileName) {
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(project);
        return CommandManager.concatServerPath((String)properties.getProperty(PersistentPropertyManager.PROPERTY_CCS_DATA_DIRECTORY), (String)fileName);
    }

    public static String getServerProcPath(LocalResource localResource) {
        if (localResource instanceof IProcFile) {
            IProcFile proc = (IProcFile)localResource;
            return proc.getProcPath();
        }
        throw new IllegalArgumentException("Argument " + localResource + " is not supported.");
    }

    private static String concatServerPath(String directory, String file) {
        if (directory == null) {
            throw new IllegalArgumentException("Argment directory is null.");
        }
        if (directory.endsWith("/")) {
            return String.valueOf(directory) + file;
        }
        return String.valueOf(directory) + "/" + file;
    }
}

