/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.server;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Observable;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.extensions.IConnectionAdapter;
import jp.sourceforge.tomoyo.core.server.ConnectionStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Composite;

public class ConnectionManager
extends Observable {
    private static ConnectionManager instance;
    private Hashtable<IProject, ArrayList<ConnectionStatus>> connectionHistoryCache = new Hashtable();

    private ConnectionManager() {
    }

    public static ConnectionManager getInstance() {
        if (instance == null) {
            instance = new ConnectionManager();
        }
        return instance;
    }

    public boolean connect(IProject project) {
        IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter((IProject)project);
        if (connectionMgr == null) {
            return false;
        }
        if (connectionMgr.isConnected(project)) {
            return true;
        }
        return connectionMgr.connect(project);
    }

    public void disConnect(IProject project) {
        IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter((IProject)project);
        if (connectionMgr == null) {
            return;
        }
        connectionMgr.disconnect(project);
    }

    public boolean isConnected(IProject project) {
        IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter((IProject)project);
        if (connectionMgr == null) {
            return false;
        }
        return connectionMgr.isConnected(project);
    }

    public void createSettingComposite(IProject project, Composite parent) {
        IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter((IProject)project);
        if (connectionMgr == null) {
            return;
        }
        connectionMgr.createSettingComposite(project, parent);
    }

    public String getErrorMessage(IProject project) {
        IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter((IProject)project);
        if (connectionMgr == null) {
            return null;
        }
        return connectionMgr.getErrorMessage(project);
    }

    public void updateConnectionState(IProject project, boolean isConnected) {
        ArrayList connectionStatusList = null;
        if (this.connectionHistoryCache.get(project) == null) {
            connectionStatusList = new ArrayList(1);
            this.connectionHistoryCache.put(project, connectionStatusList);
        } else {
            connectionStatusList = (ArrayList)this.connectionHistoryCache.get(project);
        }
        boolean wasConnected = this.wasConnected(project);
        ConnectionStatus connectionStatus = new ConnectionStatus(project, isConnected, wasConnected);
        connectionStatusList.add(connectionStatus);
        this.setChanged();
        this.notifyObservers((Object)connectionStatus);
    }

    private boolean wasConnected(IProject project) {
        ArrayList connectionHistoryList = (ArrayList)this.connectionHistoryCache.get(project);
        if (connectionHistoryList.size() == 0) {
            return false;
        }
        ConnectionStatus connectionStatus = (ConnectionStatus)connectionHistoryList.get(connectionHistoryList.size() - 1);
        return connectionStatus.isConnected();
    }
}

