/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.ui.propertysheet;

import java.util.ArrayList;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.ui.propertysheet.Messages;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ElementPropertySource
implements IPropertySource {
    private static final String PROPERTY_ID_DIRECTIVE = "id.directive";
    private static final String PROPERTY_ID_VALUE = "id.value";
    protected PolicyElement element;

    public ElementPropertySource(PolicyElement element) {
        this.element = element;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        String[] propertyIDs = this.getPropertyIDs();
        ArrayList<PropertyDescriptor> propertyList = new ArrayList<PropertyDescriptor>();
        int cnt = 0;
        while (cnt < propertyIDs.length) {
            String propertyID = propertyIDs[cnt];
            String propertyName = this.getPropertyName(propertyID);
            if (propertyName != null) {
                propertyList.add(new PropertyDescriptor((Object)propertyID, propertyName));
            }
            ++cnt;
        }
        return (IPropertyDescriptor[])propertyList.toArray(new PropertyDescriptor[propertyList.size()]);
    }

    protected String[] getPropertyIDs() {
        return new String[]{PROPERTY_ID_DIRECTIVE, PROPERTY_ID_VALUE};
    }

    protected String getPropertyName(String propertyID) {
        if (propertyID.equals(PROPERTY_ID_DIRECTIVE)) {
            return Messages.Directive;
        }
        if (propertyID.equals(PROPERTY_ID_VALUE)) {
            return Messages.ElementPropertySource_Value;
        }
        return null;
    }

    public Object getPropertyValue(Object id) {
        if (id == null) {
            return null;
        }
        if (id.equals(PROPERTY_ID_DIRECTIVE)) {
            return this.element.getText(0);
        }
        if (id.equals(PROPERTY_ID_VALUE)) {
            return this.element.getContents();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

