/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.ui.propertysheet.domain;

import jp.sourceforge.tomoyo.core.local.model.AbstractPolicyModel;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.ui.propertysheet.ElementPropertySource;
import jp.sourceforge.tomoyo.core.ui.propertysheet.domain.Messages;

public class DomainPropertySource
extends ElementPropertySource {
    private static final String PROPERTY_ID_DOMAIN = "p.domain";
    private static final String PROPERTY_ID_DOMAIN_DEPTH = "p.domain_depth";
    private static final String PROPERTY_ID_PROCESS = "p.process";
    private static final String PROPERTY_ID_PROFILE = "p.profile";
    private static final String PROPERTY_ID_IS_INITIALIZED_TARGET = "p.is_initialized_target";
    private static final String PROPERTY_ID_IS_INITIALIZED_SOURCE = "p.is_initialized_source";
    private static final String PROPERTY_ID_KEEP_DOMAIN = "p.keep_domain";
    private static final String PROPERTY_ID_RESOURCE_COUNT = "p.resource_count";
    private static final String PROPERTY_ID_RESOURCE_REACHABLE = "p.reachable";
    private static final String PROPERTY_ID_DESCENDENT_DOMAIN_COUNT = "p.descendent_domain_count";

    public DomainPropertySource(PolicyElement element) {
        super(element);
    }

    protected String[] getPropertyIDs() {
        return new String[]{PROPERTY_ID_DOMAIN, PROPERTY_ID_DOMAIN_DEPTH, PROPERTY_ID_PROCESS, PROPERTY_ID_PROFILE, PROPERTY_ID_IS_INITIALIZED_TARGET, PROPERTY_ID_IS_INITIALIZED_SOURCE, PROPERTY_ID_KEEP_DOMAIN, PROPERTY_ID_RESOURCE_COUNT, PROPERTY_ID_RESOURCE_REACHABLE, PROPERTY_ID_DESCENDENT_DOMAIN_COUNT};
    }

    protected String getPropertyName(String propertyID) {
        if (propertyID.equals(PROPERTY_ID_DOMAIN)) {
            return Messages.DomainPropertySource_Domain;
        }
        if (propertyID.equals(PROPERTY_ID_DOMAIN_DEPTH)) {
            return Messages.DomainPropertySource_DomainDepth;
        }
        if (propertyID.equals(PROPERTY_ID_PROCESS)) {
            return Messages.DomainPropertySource_ProcessName;
        }
        if (propertyID.equals(PROPERTY_ID_PROFILE)) {
            return Messages.DomainPropertySource_Profile;
        }
        if (propertyID.equals(PROPERTY_ID_IS_INITIALIZED_TARGET)) {
            return Messages.DomainPropertySource_IsInitializedTarget;
        }
        if (propertyID.equals(PROPERTY_ID_IS_INITIALIZED_SOURCE)) {
            return Messages.DomainPropertySource_IsInitializedSource;
        }
        if (propertyID.equals(PROPERTY_ID_KEEP_DOMAIN)) {
            return Messages.DomainPropertySource_KeepDomain;
        }
        if (propertyID.equals(PROPERTY_ID_RESOURCE_COUNT)) {
            return Messages.DomainPropertySource_ResourceCount;
        }
        if (propertyID.equals(PROPERTY_ID_RESOURCE_REACHABLE)) {
            return Messages.DomainPropertySource_Reachble;
        }
        if (propertyID.equals(PROPERTY_ID_DESCENDENT_DOMAIN_COUNT)) {
            return Messages.DomainPropertySource_ChildrenCount2Bottom;
        }
        return null;
    }

    public Object getPropertyValue(Object id) {
        if (id == null) {
            return null;
        }
        Domain domain = (Domain)this.element;
        if (id.equals(PROPERTY_ID_DOMAIN)) {
            return domain.getText();
        }
        if (id.equals(PROPERTY_ID_DOMAIN_DEPTH)) {
            return domain.getDepth();
        }
        if (id.equals(PROPERTY_ID_PROCESS)) {
            return domain.getProcessName();
        }
        if (id.equals(PROPERTY_ID_PROFILE) && domain.getProfile() != null) {
            return domain.getProfile().getLongName();
        }
        if (id.equals(PROPERTY_ID_IS_INITIALIZED_TARGET)) {
            return domain.isInitializerTarget() ? Messages.DomainPropertySource_YES : Messages.DomainPropertySource_NO;
        }
        if (id.equals(PROPERTY_ID_IS_INITIALIZED_SOURCE)) {
            return domain.isInitializerSource() ? Messages.DomainPropertySource_YES : Messages.DomainPropertySource_NO;
        }
        if (id.equals(PROPERTY_ID_KEEP_DOMAIN)) {
            return domain.isKeepDomain() ? Messages.DomainPropertySource_YES : Messages.DomainPropertySource_NO;
        }
        if (id.equals(PROPERTY_ID_RESOURCE_COUNT)) {
            AbstractPolicyModel document = (AbstractPolicyModel)domain.getParent();
            if (document == null) {
                return null;
            }
            int count = PolicyCacheManager.getInstance().count(document.getProject(), domain, AccessPermission.class, false);
            return count;
        }
        if (id.equals(PROPERTY_ID_RESOURCE_REACHABLE)) {
            if (domain.isReachable()) {
                return Messages.DomainPropertySource_YES;
            }
            switch (domain.getUnreachableReason()) {
                case 1: {
                    return String.valueOf(Messages.DomainPropertySource_NO) + "(" + "No parerents" + ")";
                }
                case 4: {
                    return String.valueOf(Messages.DomainPropertySource_NO) + "(" + "Parent domain is initialized" + ")";
                }
                case 3: {
                    return String.valueOf(Messages.DomainPropertySource_NO) + "(" + "Parent domain is keptdomain" + ")";
                }
                case 2: {
                    return String.valueOf(Messages.DomainPropertySource_NO) + "(" + "Parent domain is unreachable" + ")";
                }
                case 5: {
                    return String.valueOf(Messages.DomainPropertySource_NO) + "(" + "Initialised" + ")";
                }
            }
        }
        if (id.equals(PROPERTY_ID_DESCENDENT_DOMAIN_COUNT)) {
            AbstractPolicyModel document = (AbstractPolicyModel)domain.getParent();
            if (document == null) {
                return null;
            }
            return PolicyCacheManager.getInstance().listDecendantDomainCount(document.getProject(), domain);
        }
        return null;
    }
}

