/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  
 */


/*
 *	ץå¸Υͥ񸻡BLACKfinѡ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  ӥޥɤ߹
 */
#ifdef __GNUC__
/*
* ӥϡconfigureץȤʤΤǡgnuĶǤ
*/
//#include <api.h>
#elif defined(__ECC__)
/*
* ӥϡIPAԤΤǡVisualDSP++ĶǤϤ٤򤷤Ƥ
*/
#include <api.h>
#else
#error "Compiler is not supported"
#endif
/*
 *  BLACKfinϢեɤ߹
 */
#ifdef __GNUC__
#include "cdef_LPBlackfin.h"		/* gnu tool chain */
#elif defined(__ECC__)
#include <cdef_lpblackfin.h>	/* VisualDSP++ */
#else
#error "Compiler is not supported"
#endif

/*
*  ٥ȥץ饤ƥ. sys_config.h  device_dispatcher()ǻȤ
*/
#ifdef __GNUC__
#define ik_timer 6
#define ik_hardware_err 5
#elif defined(__ECC__)
#else
#error "Compiler is not supported"
#endif

/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>

/*
*	BLACKfinΥӥåȥޥå׸ǽȤ
*   BLACKfinMSB롣
*/
#define	CPU_BITMAP_SEARCH
#define	PRIMAP_BIT(pri)		(0x40000000u >> (pri))


/*
 *  TCB ΥեɤΥӥå
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */
#define	TBIT_TCB_TSTAT		8	/* tstat եɤΥӥå */
#define	TBIT_TCB_PRIORITY	8	/* priority եɤΥӥå */


/*
*	BLACKfinIMASKؤѥ
*
*/
#define IMASK_LOCK   0xc01f
#define IMASK_UNLOCK 0xffff

#ifndef _MACRO_ONLY
/*
 *  ץåü̿Υ饤ؿ
 */
/*
 *  ǥ塼ΤΥӥåȥޥåץؿ
 *
 *  ӥåȥޥåפβ16ӥåȤѤǲ̥ӥåȤͥ٤б
 *  롥
 */


Inline UINT
bitmap_search(UINT bitmap)
{
	UINT	numOfSign;

	/*
	 *  ΥɤϡbitmapUINTˤ32ӥåȤǤ뤳Ȥꤷ
	 *  Ƥ롥Signbits ̿32ӥåäMSBϢ³
	 *  ӥå - 1 ֤all 0ΤȤ31֤LSBΤߤ1
	 *  Ȥ30֤
	 */
#ifdef __GNUC__			// gcc
	// gcc 3.4.1 λǤϡڥɤ˲̥ϡե쥸
	// Ǥʤᡢ;פʥɤɬפˤʤ롣
	Asm( "r0.L=signbits %1; %0 = r0.L;": "=d"(numOfSign) : "d"(bitmap) : "R0" );
#elif defined(__ECC__)	// visualdsp
	Asm( "%0=signbits %1;": "=l"(numOfSign) : "d"(bitmap) );
#else
#error "Compiler is not supported"
#endif
	return( numOfSign );
}



/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
	VP	sp;		/* åݥ */
	FP	pc;		/* ץ५ */
} CTXB;


/*
 *  ƥֻ
 *	֤ͤϰʲΤȤ
 *	TRUE : 󥿥ƥ
 *	FALSE: ƥ
 *				IPEND$8000$8010λƥȤǤ롣ʳΤȤ󥿥ƥȡ
 */

Inline BOOL
sense_context()
{
	return( *pIPEND & 0x7FEF );
}

/*
* ߤΥå֤Ĵ٤롣ߤޤǥåsil_loc_int()
* å֤ϡsense_lock()Ǥ̵뤹롣
*/
Inline BOOL
sense_lock()
{
#ifdef UNMANAGED_INT
	return((*pIMASK & ~UNMANAGED_INT )== 0xC01F );
#else
	return(*pIMASK == 0xC01F );
#endif
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock


/*
 *  CPUåȤβʥƥѡ
 *
 *  task_intmask ϡchg_ipm 򥵥ݡȤ뤿ѿchg_ipm 򥵥ݡ
 *  Ȥʤˤϡtask_intmask  0 ˤʤäƤȹͤФ褤
 *
 */

#ifdef SUPPORT_CHG_IPM
extern UH	task_intmask;	/* ƥȤǤγߥޥ */
#endif /* SUPPORT_CHG_IPM */

#ifdef UNMANAGED_INT
#if UNMANAGED_INT & 0xC01F
// ߤϰϥåߤIVHWIVG13δ֤ǤʤФʤʤ
#error "Illegal un-managed interrupt : must be IVHW-IVG13"
#endif
#endif


// BLACKfinǤIMASK0xC01F񤭹CPUå롣
Inline void
t_lock_cpu()
{
#ifdef UNMANAGED_INT
	unsigned int imask;
	Asm( "cli %0;" :"=d"(imask) );
	Asm( "sti %0;" : :"d"(0xC01f | (imask & UNMANAGED_INT) ) );
#else
    Asm( "cli r0;" : : :"R0" );
	Asm( "sti %0;" : :"d"(0xC01F) );
#endif
}

Inline void
t_unlock_cpu()
{
#ifdef UNMANAGED_INT
	unsigned int imask;
	Asm( "cli %0;" :"=d"(imask) );
	Asm( "sti %0;" : :"d"( (0xffff & ~UNMANAGED_INT) | (imask & UNMANAGED_INT) ) );
#else
	Asm( "sti %0;" : :"d"(0xffff) );
#endif
}

/*
 *  CPUåȤβ󥿥ƥѡ
 */


Inline void
i_lock_cpu()
{
#ifdef UNMANAGED_INT
	unsigned int imask;
	Asm( "cli %0;" :"=d"(imask) );
	Asm( "sti %0;" : :"d"(0xC01f | (imask & UNMANAGED_INT) ) );
#else
    Asm( "cli r0;" : : :"R0" );
	Asm( "sti %0;" : :"d"(0xC01F) );
#endif
}

Inline void
i_unlock_cpu()
{
#ifdef UNMANAGED_INT
	unsigned int imask;
	Asm( "cli %0;" :"=d"(imask) );
	Asm( "sti %0;" : :"d"( (0xffff & ~UNMANAGED_INT) | (imask & UNMANAGED_INT) ) );
#else
	Asm( "sti %0;" : :"d"(0xffff) );
#endif
}

/*
 *  ǥѥå 
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.S
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.S
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	exit_and_dispatch(void);

/*
 *  ߥϥɥ顿CPU㳰ϥɥ
 */


/*
 *  ߥϥɥ
 *
 *  ٥ȥֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 * evtvector start.asmƤ롣
 */
extern void (* dev_vector[])(void) ;

extern void (* exc_vector)(VP) ;
Inline void
define_inh(INHNO inhno, FP inthdr)
{
	dev_vector[inhno] = inthdr;
}

/*
 *  CPU㳰ϥɥ
 *
 *  ٥ȥֹ excno CPU㳰ϥɥεưϤ exchdr ꤹ롥
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{
//	exc_vector[excno] = exchdr;		// 㳰ϥɥ˳Ǽ 
	exc_vector = (void (*)(VP))exchdr;		// 㳰ϥɥǼ
}

/*
 *  ߥϥɥ顿CPU㳰ϥɥν
 */

/*
 *  ߥϥɥνޥ
 *
 *  reqflg å˳ߤػߤʤȡreqflg å
 *  ˵ư줿ߥϥɥǥǥѥå׵ᤵ줿ˡǥ
 *  ѥåʤ
 */

#define	INTHDR_ENTRY(inthdr)	extern void inthdr(void);	
#define	INT_ENTRY(inthdr)	inthdr

/*
 *  CPU㳰ϥɥνޥ
 *
 *  reqflg å˳ߤػߤʤȡreqflg å
 *  ˵ư줿ߥϥɥǥǥѥå׵ᤵ줿ˡǥ
 *  ѥåʤ
 */

#define	EXCHDR_ENTRY(exchdr)	extern void exchdr( VP );
#define	EXC_ENTRY(exchdr)	exchdr

/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥƥȤλ
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	return( *pIPEND & 0x7FE6 );				// IVG15, GIE, EXP, EMU ʳΥӥåȤΩäƤ󥿥ƥ
}

/*
 *  CPU㳰ȯCPUå֤λȡߤξ̵֤뤹롣
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
#ifdef UNMANAGED_INT
	return((*pIMASK | UNMANAGED_INT) != 0xFFFF );		// 0xFFFFʤ饢å
#else
	return(*pIMASK != 0xFFFF );				// 0xFFFFʤ饢å
#endif
}

/*
 *  ץå¸ν
 */
extern void	cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
