/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  
 */

/*
 *	åȥƥ¸⥸塼ADSP-BF533ѡ
 */

#include "jsp_kernel.h"
#include <sil.h>

#ifdef __GNUC__
#include "../cdefBF532.h"		/* gnu tool chain */
#elif defined(__ECC__)
#include <cdefBF53x.h>				/* VisualDSP++ */
#include <sys/exception.h>
#include <ccblkfn.h>
#include <sysreg.h>
#else
#error "Compiler is not supported"
#endif



#define SYSCFG_VALUE 0x36

/*
 *  åȥƥ¸ν
 */
void
sys_initialize()
{
	// BF531/2/3ΥΡޥ꡼к rev 0.1, 0.2
	Asm( "SYSCFG=%0;"  : :"d"(SYSCFG_VALUE) ) ;

	/*
	 *  PLL
	 *
	 */
	/*
	 *  27MHz*22=594MHzꤹ(600MHz)
	 *  27MHz*28=756MHzꤹ(750MHz)
	 *  CSEL = 1; SSEL = 5 (600MHz)
	 *  CSEL = 1; SSEL = 6 (750MHz)
	 */
	 
	 	// PLLͤΤޤޤǤꡢġSDRAMǤʤPLL 
	 if ( ( *pPLL_CTL == 0x1400 ) && ( !(*pEBIU_SDBCTL & EBE ) ) )
	 {
	 
		*pSIC_IWR = IWR_ENABLE(0);				// PLLΤIWR
#if CSELVAL == 1 
		*pPLL_DIV = CCLK_DIV1 | SCLK_DIV(SSELVAL);
#elif CSELVAL == 2
		*pPLL_DIV = CCLK_DIV2 | SCLK_DIV(SSELVAL);
#elif CSELVAL == 4
		*pPLL_DIV = CCLK_DIV4 | SCLK_DIV(SSELVAL);
#elif CSELVAL == 8
		*pPLL_DIV = CCLK_DIV8 | SCLK_DIV(SSELVAL);
#else
#error Wrong CSELVAL. Must be one of 1,2,4,8.
#endif
	
		*pPLL_CTL = MSELVAL << 9;
		
		asm("cli r0; csync; idle; sti r0;": : :"R0");
		*pSIC_IWR = IWR_ENABLE_ALL;
	}

}


unsigned int priority_mask[16]={
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x0000007F,
0x00000180,
0x00001E00,
0x0000E000,
0x00070000,
0x00180000,
0x00E00000,
0x00000000,
0x00000000
};


/*
* SIC_IARxϤơ٥Ƚ̤Ȥ˳ƤƤ
* Υӥåȥޥåפ롣SIC_IARxΥեͤͥ-7ʤΤ
* ʬ롣
*/
#define INSTALL_PRIORITY    \
    for ( i=0; i<8; i++ ){ \
        priority = iar & 0xf;                         /* IAR̤ͥФ */ \
        priority_mask[priority + 7] |= device;        /* Ф̤ͥ˴ŤǥХϿ */ \
        device <<= 1;                                 /* ΥǥХ */ \
        iar >>= 4;                                    /* IARե */ \
    }

void make_priority_mask( void )
{
	unsigned int i, priority, device, iar;
	
	
	/*
 *  ߽̤ȤISRӥåȥޥåפκ
 *  SIC_IARxϤʬ˺Ѥޤ뤳
 */
 
 	for ( i=0; i<16; i++ ){
 		priority_mask[i] = 0;
 	}
 
	device = 1;
	iar = *pSIC_IAR0;
    INSTALL_PRIORITY	
	
	iar = *pSIC_IAR1;
    INSTALL_PRIORITY    

	iar = *pSIC_IAR2;
    INSTALL_PRIORITY    

}


/*
 * ߤεġػ
 *
 */
ER ena_int( INTNO intno )
{
	unsigned int mask;
	
	if ( intno >= DEVICE_INTERRUPT_COUNT )
		return ( E_PAR );
	else {
		mask = 1 << intno;
		*pSIC_IMASK |= mask;
		return (0);
	}
}
ER dis_int( INTNO intno )
{
	unsigned int mask;

	if ( intno >= DEVICE_INTERRUPT_COUNT )
		return ( E_PAR );
	else {
		mask = 1 << intno;
		mask = ~mask;
		*pSIC_IMASK &= mask;
		return (0);
	}
}

/*
 * ߥޥ
 *
 *
 */
ER chg_ims( IMS ims )
{
	*pSIC_IMASK = ims;
	return( 0 );
}

extern ER get_ims( IMS * p_ims )
{
	*p_ims = *pSIC_IMASK;
	return( 0 );;
}


/*
 *  ߤǥХ˳Ƥ
 */
void device_dispatcher( unsigned int priority )
{
	unsigned int candidates, device;
	
	candidates = priority_mask[priority] & *pSIC_ISR & *pSIC_IMASK;	// ߤΥץ饤ƥ߸ꤹ

	if ( ! candidates ) // ߸Ǥʤʤ顢ͳǤ
	{
		if ( priority == ik_hardware_err)
			dev_vector[INHNO_HW_ERROR]();
		else 
			if ( priority == ik_timer)
			dev_vector[INHNO_TIMER]();
		else
			dev_vector[INHNO_RAISE]();		//եȥ

	}
	else 
	{
		if ( candidates & 0x80000000 )
			device = 31;
		else
		{
#ifdef __GNUC__
	asm ( "r1.L = signbits %1; %0 = r1.L(z);":"=d"(device) :"d"(candidates): "R1"  );
#elif defined(__ECC__)
	asm( "%0 = signbits %1;" : "=l"( device ) : "d"( candidates ) );
#else
#error "Compiler is not supported"
#endif
			device = 30 - device;		// bit mask is converted to bit number
		}
		dev_vector[device]();
	}
}



/*
 *  åȥƥνλ
 */
void
sys_exit()
{
	while(1)
		;
}

/*
 *  åȥƥʸ
 */
void
sys_putc(char c)
{
}



