/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: collection.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/base/collection.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $

#include "base/collection.h"


using namespace std;

    //ä˲⤷ʤ󥹥ȥ饯
Collection::Collection(void) throw()
{}

    //ǥȥ饯
Collection::~Collection(void) throw()
{
        //ǰΤ㳰ˤդ򤹤
    try { clear(); }
    catch(...) {}
}

    //󥹥󥹤򥳥쥯ɲ (Ͽ)
bool Collection::addInstance(Collectable * _instance, bool _destruction) throw()
{
    bool result = false;

    if(isValid() && _instance != 0) {

            // Ʊ󥹥󥹤2Ͽʤ褦ˤ
        list<Element>::iterator scope;

        scope = container.begin();
        while(scope != container.end()) {
            if(scope->instance == _instance)
                break;
            ++ scope;
        }

        if(scope == container.end()) {
                // Ǥɲ
            struct Element element;
            element.instance    = _instance;
            element.destruction = _destruction;
            container.push_back(element);
        }
        else {
                // ˴ؼϺǿľƤ
            scope->destruction = _destruction;
        }

        result = true;
    }

    return result;
}

    //ꤵ줿Collectable󥹥󥹤ؤƥ졼μ (getInstance)
list<Collection::Element>::const_iterator Collection::_findInstance(const Collectable * predecessor) const throw()
{
    list<Element>::const_iterator result;

    result = container.begin();

        //predecessorꤵƤõ
    if(predecessor != 0) {
        while(result != container.end()) {
            if(result->instance == predecessor) {
                ++ result;   //predecessorμ
                break;
            }
            ++ result;
        }
    }

    return result;
}

    //쥯󤫤饤󥹥󥹤
Collectable * Collection::getInstance(const type_info & type, const Collectable * predecessor) const throw()
{
    Collectable * result;

    result = 0;
    if(isValid()) {

        list<Element>::const_iterator scope;

            // Ԥ륤󥹥󥹤ξõ
        scope = _findInstance(predecessor);

            // ꤵ줿ļΥ󥹥󥹤õ
        while(scope != container.end()) {
            if(typeid(*scope->instance) == type) {
                result = scope->instance;
                break;
            }
            ++ scope;
        }
    }

    return result;
}

    //쥯󤫤饤󥹥󥹤 (˴Ϥʤ)
bool Collection::removeInstance(const Collectable * instance) throw()
{
    bool result = false;

    if(isValid() && instance != 0) {
        list<Element>::iterator scope;

        scope = container.begin();
        while(scope != container.end()) {
            if(scope->instance == instance) {
                    //Ǥκ
                container.erase(scope);
                result = true;
                break;
            }
            ++ scope;
        }
    }

    return result;
}

    //Ǥ˴
void Collection::clear(void)
{
    if(isValid()) {
        list<Element>::iterator scope;
        list<Element>::iterator next;

            //˴ե饰ĤƤ륤󥹥󥹤˴
        scope = container.begin();
        while(scope != container.end()) {

            next = scope;       //ROTϤdeleteȼʬäˤΤǡƥ졼¸뤿˼Ƥ
            ++ next;

            if(scope->destruction)
                delete scope->instance;

            scope = next;
        }

        container.clear();
    }
}

/************************************************* ƥȥ *************************************************/

#ifdef TESTSUITE
#include "coverage_undefs.h"

class TestCollectable : public Collectable
{};

class TestCollectable2 : public Collectable
{   public: ~TestCollectable2(void) throw() { TestSuite::check("TestCollectable2::~TestCollectable2"); }   };

#ifdef _MSC_VER
class TestCollectable3 : public Collectable
{   public: ~TestCollectable3(void) throw(int) { throw 0; }   };
#endif

class TestCollectable4 : public TestCollectable2
{   public: ~TestCollectable4(void) throw() { TestSuite::check("TestCollectable4::~TestCollectable4"); }   };

TESTSUITE(main, Collection)
{
    BEGIN_CASE("addInstance","addInstance") {
        BEGIN_CASE("1","󥹥󥹤ϿǤ") {
            Collection col;
            TestCollectable test;
            TestCollectable2 test2;

            BEGIN_CASE("1","ϿǤTRUE֤ (1)") {
                if(!col.addInstance(&test,  false))
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("2","ϿǤtrue֤ (2)") {
                if(!col.addInstance(&test2, false))
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("3","ĿäƤ") {
                if(col.container.size() != 2)
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("4","֤äƤ") {
            list<Element>::iterator scope;
                scope = col.container.begin();
                if(scope->instance != &test || scope->destruction != false)
                    TEST_FAIL;
                ++ scope;
                if(scope->instance != &test2 || scope->destruction != false)
                    TEST_FAIL;
                ++ scope;
                if(scope != col.container.end())
                    TEST_FAIL;
            } END_CASE;
        } END_CASE;

        BEGIN_CASE("2","NULL󥹥󥹤Ͽʤ") {
            Collection col;

            BEGIN_CASE("1","NULL󥹥󥹤Ϥfalse֤") {
                if(col.addInstance(0))
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("2","ϿƤʤ") {
                if(col.container.size() != 0)
                    TEST_FAIL;
            } END_CASE;
        } END_CASE;

        BEGIN_CASE("3","̵ʥ󥹥󥹤Фfalse֤") {
            Collection col;

            if(col.addInstance(0))
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("4","ƱΥ󥹥󥹤2ϿƤ1ĤϿʤ") {
            Collection col;
            TestCollectable test;

            TEST_CASE("0","[] ܤ", col.addInstance(&test, false));

            TEST_CASE("1","ؿλ", col.addInstance(&test, false));
            TEST_CASE("2","󥹥󥹿Ƥʤ", col.container.size() == 1);

        } END_CASE;

    } END_CASE;

    BEGIN_CASE("getInstance(type_info)","getInstance(type_info)") {
        Collection col;
        TestCollectable test;
        TestCollectable test_2;
        TestCollectable test_3;
        TestCollectable2 test2;
        TestCollectable2 test2_2;
        TestCollectable2 test2_3;

        col.addInstance(test);
        col.addInstance(test2);
        col.addInstance(test_2);
        col.addInstance(test2_2);
        col.addInstance(test_3);
        col.addInstance(test2_3);

        Collectable * instance = 0;

        BEGIN_CASE("1","ǽǤǤ") {
            instance = col.getInstance(typeid(TestCollectable));
            if(instance != &test)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","ǤǤ") {
            instance = col.getInstance(typeid(TestCollectable), instance);
            if(instance != &test_2)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3","˼ǤǤ") {
            instance = col.getInstance(typeid(TestCollectable), instance);
            if(instance != &test_3)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("4","ΤޤǤNULL֤") {
            instance = col.getInstance(typeid(TestCollectable), instance);
            if(instance != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("5","ǽǤǤ") {
            instance = col.getInstance(typeid(TestCollectable2));
            if(instance != &test2)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("6","ǤǤ") {
            instance = col.getInstance(typeid(TestCollectable2), instance);
            if(instance != &test2_2)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("7","˼ǤǤ") {
            instance = col.getInstance(typeid(TestCollectable2), instance);
            if(instance != &test2_3)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("8","ΤޤǤNULL֤") {
            instance = col.getInstance(typeid(TestCollectable), instance);
            if(instance != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("9","쥯饹ǤϤҤäʤ") {
            instance = col.getInstance(typeid(Collectable));
            if(instance != 0)
                TEST_FAIL;
        } END_CASE;

        TEST_CASE("10","NULLФƼ¹ԤNULL֤", ((Collection *)0)->getInstance(typeid(Collectable)) == 0);
    } END_CASE;

    BEGIN_CASE("getInstance<T>()","getInstance<T>()") {
        Collection col;
        TestCollectable test;
        TestCollectable test_2;
        TestCollectable test_3;
        TestCollectable2 test2;
        TestCollectable2 test2_2;
        TestCollectable2 test2_3;

        col.addInstance(test);
        col.addInstance(test2);
        col.addInstance(test_2);
        col.addInstance(test2_2);
        col.addInstance(test_3);
        col.addInstance(test2_3);

        Collectable * instance = 0;

        BEGIN_CASE("1","ǽǤǤ") {
            instance = col.getInstance<TestCollectable>();
            if(instance != &test)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","ǤǤ") {
            instance = col.getInstance<TestCollectable>(instance);
            if(instance != &test_2)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3","˼ǤǤ") {
            instance = col.getInstance<TestCollectable>(instance);
            if(instance != &test_3)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("4","ΤޤǤNULL֤") {
            instance = col.getInstance<TestCollectable>(instance);
            if(instance != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("5","ǽǤǤ") {
            instance = col.getInstance<TestCollectable2>();
            if(instance != &test2)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("6","ǤǤ") {
            instance = col.getInstance<TestCollectable2>(instance);
            if(instance != &test2_2)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("7","˼ǤǤ") {
            instance = col.getInstance<TestCollectable2>(instance);
            if(instance != &test2_3)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("8","ΤޤǤNULL֤") {
            instance = col.getInstance<TestCollectable2>(instance);
            if(instance != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("9","쥯饹ǰóݤ 1") {
            instance = col.getInstance<Collectable>();
            if(instance != &test)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("10","쥯饹ǰóݤ 2") {
            instance = col.getInstance<Collectable>(instance);
            if(instance != &test2)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("11","쥯饹ǰóݤ 3") {
            instance = col.getInstance<Collectable>(instance);
            if(instance != &test_2)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("12","쥯饹ǰóݤ 4") {
            instance = col.getInstance<Collectable>(instance);
            if(instance != &test2_2)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("13","쥯饹ǰóݤ 5") {
            instance = col.getInstance<Collectable>(instance);
            if(instance != &test_3)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("14","쥯饹ǰóݤ 6") {
            instance = col.getInstance<Collectable>(instance);
            if(instance != &test2_3)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("15","쥯饹ǰóݤ 7") {
            instance = col.getInstance<Collectable>(instance);
            if(instance != 0)
                TEST_FAIL;
        } END_CASE;

        TEST_CASE("16","NULLФƼ¹ԤNULL֤", ((Collection *)0)->getInstance<Collectable>() == 0);

    } END_CASE;

    BEGIN_CASE("removeInstance","removeInstance") {

        BEGIN_CASE("1","˺Ǥ") {
            Collection col;
            TestCollectable test;
            TestCollectable test2;

            col.addInstance(test);
            col.addInstance(test2);

            BEGIN_CASE("1","¸ߤǤremovetrue") {
                if(!col.removeInstance(&test))
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("2","ȾäƤ") {
                if(col.container.size() != 1 || col.container.begin()->instance != &test2)
                    TEST_FAIL;
            } END_CASE;
        } END_CASE;

        BEGIN_CASE("2","NULL󥹥󥹤˼¹Ԥfalse") {
            if(((Collection *)0)->removeInstance(0))
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3","ϿƤʤ󥹥󥹤ꤹȼԤ") {
            Collection col;
            TestCollectable test;
            TestCollectable test2;

            col.addInstance(test);

            if(col.removeInstance(&test2))
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("4","NULL󥹥󥹤ϤȼԤ") {
            Collection col;
            TestCollectable test;
            col.addInstance(test);

            if(col.removeInstance(0))
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("clear","clear") {
        BEGIN_CASE("1","ΤϿclear") {
            Collection col;
            TestCollectable2 test2;

            TestSuite::clearCheckpoints();
            col.addInstance(test2);
            col.clear();

            BEGIN_CASE("1","ǤʤʤäƤ") {
                if(col.container.size() != 0)
                    TEST_FAIL;
            } END_CASE;

            TEST_CASE("2","test2˴ʤ", !TestSuite::isReached("TestCollectable2::~TestCollectable2"));
        } END_CASE;

        BEGIN_CASE("2","ݥ󥿤Ͽclear") {
            Collection col;
            TestCollectable2 * test2 = new TestCollectable2;
            
            TestSuite::clearCheckpoints();
            col.addInstance(test2);
            col.clear();

            BEGIN_CASE("1","ǤʤʤäƤ") {
                if(col.container.size() != 0)
                    TEST_FAIL;
            } END_CASE;

            TEST_CASE("2","test2˴", TestSuite::isReached("TestCollectable2::~TestCollectable2"));
        } END_CASE;

        BEGIN_CASE("3","NULL֥ȤФƼ¹ԤƤ˽ʤ") {
            ((Collection *)0)->clear();
        } END_CASE;

#ifdef _MSC_VER
        BEGIN_CASE("4","㳰Ф褦ʥǥȥ饯ĥ󥹥󥹤˴㳰ϳ") {
            Collection col;
            bool result = false;
            TestCollectable3 * test = new TestCollectable3;

            col.addInstance(test);
            try {
                col.clear();
            }
            catch(...) {
                result = true;
            }


            if(!result)
                TEST_FAIL;
        } END_CASE;
#endif
    } END_CASE;

    BEGIN_CASE("destructor","destructor") {
        BEGIN_CASE("1","ΤϿ˴") {
            Collection * col = new Collection;
            TestCollectable2 test2;

            TestSuite::clearCheckpoints();
            col->addInstance(test2);
            delete col;

            TEST_CASE("1","test2˴ʤ", !TestSuite::isReached("TestCollectable2::~TestCollectable2"));
        } END_CASE;

        BEGIN_CASE("2","ݥ󥿤Ͽclear") {
            Collection * col = new Collection;
            TestCollectable2 * test2 = new TestCollectable2;

            TestSuite::clearCheckpoints();
            col->addInstance(test2);
            delete col;

            TEST_CASE("1","test2˴", TestSuite::isReached("TestCollectable2::~TestCollectable2"));
        } END_CASE;

#ifdef _MSC_VER
        BEGIN_CASE("3","㳰Ф褦ʥǥȥ饯ĥ󥹥󥹤˴Ƥ㳰ϳʤ") {
            Collection * col = new Collection;
            TestCollectable3 * test2 = new TestCollectable3;
            bool result = true;
            
            TestSuite::clearCheckpoints();
            col->addInstance(test2);

            try {
                delete col;
            }
            catch(...) {
                result = false;
            }

            if(!result)
                TEST_FAIL;
        } END_CASE;
#endif
    } END_CASE;

    BEGIN_CASE("deleteInstance","deleteInstance") {
        BEGIN_CASE("1","󥹥󥹤Ǥ") {
            Collection col;
            TestCollectable2 * test = new TestCollectable2;

            TestSuite::clearCheckpoints();
            col.addInstance(test);

            TEST_CASE("0","[] ϿƤ", col.getInstance<TestCollectable2>() != 0);

            col.deleteInstance<TestCollectable2>();
            TEST_CASE("1","󥹥󥹤äƤ", col.getInstance<TestCollectable2>() == 0);
            TEST_CASE("2","ǥȥ饯¹ԤƤ", TestSuite::isReached("TestCollectable2::~TestCollectable2"));
        }END_CASE;

        BEGIN_CASE("2","طʤ饹ꤷʤ") {
            Collection col;
            TestCollectable2 * test = new TestCollectable2;

            TestSuite::clearCheckpoints();
            col.addInstance(test);

            TEST_CASE("0","[] ϿƤ", col.getInstance<TestCollectable2>() != 0);

            col.deleteInstance<TestCollectable>();
            TEST_CASE("1","󥹥󥹤äƤʤ", col.getInstance<TestCollectable2>() != 0);
            TEST_CASE("2","ǥȥ饯¹ԤƤʤ", !TestSuite::isReached("TestCollectable2::~TestCollectable2"));
            delete test;
        }END_CASE;

        BEGIN_CASE("3","Ʊ饹Ǥʤä") {
            Collection col;
            TestCollectable2 * test = new TestCollectable2;
            TestCollectable4 * test2 = new TestCollectable4;

            TestSuite::clearCheckpoints();
            col.addInstance(test);
            col.addInstance(test2);

            TEST_CASE("0","[] ϿƤ", col.getInstance(typeid(TestCollectable2)) != 0);
            TEST_CASE("0","[] ϿƤ", col.getInstance(typeid(TestCollectable4)) != 0);

            col.deleteInstance<TestCollectable2>();
            TEST_CASE("1","󥹥󥹤٤ƾäƤ", col.getInstance<TestCollectable2>() == 0);
            TEST_CASE("2","TestCollectable2Υǥȥ饯¹ԤƤ", TestSuite::isReached("TestCollectable2::~TestCollectable2"));
            TEST_CASE("3","TestCollectable4Υǥȥ饯¹ԤƤ", TestSuite::isReached("TestCollectable4::~TestCollectable4"));
        }END_CASE;

        BEGIN_CASE("4","Τ˴оݤˤʤʤ") {
            Collection col;
            TestCollectable2 test;

            TestSuite::clearCheckpoints();
            col.addInstance(test);

            TEST_CASE("0","[] ϿƤ", col.getInstance<TestCollectable2>() != 0);

            col.deleteInstance<TestCollectable2>();
            TEST_CASE("1","󥹥󥹤äƤ", col.getInstance<TestCollectable2>() == 0);
            TEST_CASE("2","ǥȥ饯¹ԤƤʤ", !TestSuite::isReached("TestCollectable2::~TestCollectable2"));
        }END_CASE;

        BEGIN_CASE("5","NULL֥ȤФȯԤƤ˽ʤ") {
            ((Collection *)0)->deleteInstance<TestCollectable>();
        } END_CASE;

    } END_CASE;

    BEGIN_CASE("replaceInstance","replaceInstance") {
        BEGIN_CASE("1","ϿѤߤΥ󥹥󥹤ؤ") {
            Collection col;
            TestCollectable2 test;
            TestCollectable2 test2;

            TestSuite::clearCheckpoints();
            col.addInstance(test);

            TEST_CASE("0","[] ϿƤ", col.getInstance(typeid(TestCollectable2)) != 0);
            
            TEST_CASE("1", "ؿ", col.replaceInstance<TestCollectable2>(test2));
            TEST_CASE("2", "󥹥󥹤ؤäƤ", col.getInstance(typeid(TestCollectable2)) == &test2);
            TEST_CASE("3", "test2ʳ˥󥹥󥹤Ϥʤ", col.getInstance(typeid(TestCollectable2), &test2) == 0);
            TEST_CASE("4", "ǥȥ饯ϼ¹ԤƤʤ", !TestSuite::isReached("TestCollectable2::~TestCollectable2"));
        } END_CASE;

        BEGIN_CASE("2","ϿѤߤΥ󥹥󥹤饹Υ󥹥󥹤ؤ") {
            Collection col;
            TestCollectable2 test;
            TestCollectable4 test2;

            TestSuite::clearCheckpoints();
            col.addInstance(test);

            TEST_CASE("0","[] ϿƤ", col.getInstance(typeid(TestCollectable2)) != 0);
            
            TEST_CASE("1", "ؿ", col.replaceInstance<TestCollectable2>(test2));
            TEST_CASE("2", "󥹥󥹤ؤäƤ", col.getInstance<TestCollectable2>() == &test2);
            TEST_CASE("3", "test2ʳ˥󥹥󥹤Ϥʤ", col.getInstance(typeid(TestCollectable2)) == 0);
            TEST_CASE("4", "ǥȥ饯ϼ¹ԤƤʤ", !TestSuite::isReached("TestCollectable2::~TestCollectable2"));
        } END_CASE;

        BEGIN_CASE("3","̵طʥ饹ꤷؤ") {
            Collection col;
            TestCollectable2 test;
            TestCollectable4 test2;

            TestSuite::clearCheckpoints();
            col.addInstance(test);

            TEST_CASE("0","[] ϿƤ", col.getInstance(typeid(TestCollectable2)) != 0);
            
            TEST_CASE("1", "ؿϼԤ", !col.replaceInstance<TestCollectable>(test2));
            TEST_CASE("2", "󥹥󥹤ϻĤäƤ", col.getInstance<TestCollectable2>() == &test);
        } END_CASE;

        BEGIN_CASE("4","ϿѤߤΥ󥹥󥹤ؤ (ưŪ)") {
            Collection col;
            TestCollectable2 * test = new TestCollectable2;
            TestCollectable2 test2;

            TestSuite::clearCheckpoints();
            col.addInstance(test);

            TEST_CASE("0","[] ϿƤ", col.getInstance(typeid(TestCollectable2)) != 0);
            
            TEST_CASE("1", "ؿ", col.replaceInstance<TestCollectable2>(test2));
            TEST_CASE("2", "󥹥󥹤ؤäƤ", col.getInstance(typeid(TestCollectable2)) == &test2);
            TEST_CASE("3", "test2ʳ˥󥹥󥹤Ϥʤ", col.getInstance(typeid(TestCollectable2), &test2) == 0);
            TEST_CASE("4", "ǥȥ饯ϼ¹ԤƤ", TestSuite::isReached("TestCollectable2::~TestCollectable2"));
        } END_CASE;

    } END_CASE;
}


class TestRuntimeObject : public RuntimeObject
{
public:
    TestRuntimeObject(void) { CHECKPOINT("TestRuntimeObject::TestRuntimeObject"); }
    ~TestRuntimeObject(void) { CHECKPOINT("TestRuntimeObject::~TestRuntimeObject"); }
};

class TestRuntimeObject2 : public RuntimeObject
{
public:
    TestRuntimeObject2(void) : RuntimeObject(true) { CHECKPOINT("TestRuntimeObject2::TestRuntimeObject2"); }
    ~TestRuntimeObject2(void) { CHECKPOINT("TestRuntimeObject2::~TestRuntimeObject2"); }
};

TESTSUITE(main, RuntimeObjectTable)
{
    Singleton<RuntimeObjectTable>::Context context;
    Singleton<RuntimeObjectTable>::saveContext(context);

    BEGIN_CASE("getInstance","getInstance") {
        BEGIN_CASE("1","getInstanceǽ") {
            Singleton<RuntimeObjectTable>::renewInstance();
            TestCollectable test;

            Singleton<RuntimeObjectTable>::getInstance()->addInstance(test);

            BEGIN_CASE("1","getInstance(typeid)") {
                if(RuntimeObjectTable::getInstance(typeid(TestCollectable)) != &test)
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("2","getInstance<T>()") {
                if(RuntimeObjectTable::getInstance<TestCollectable>() != &test)
                    TEST_FAIL;
            } END_CASE;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("RuntimeObject","RuntimeObject") {
        BEGIN_CASE("1","Ͽ졢˴ǾǤ") {
            TestRuntimeObject * ro;

            TestSuite::clearCheckpoints();

            TEST_CASE("0","[] ϿƤʤ", RuntimeObjectTable::getInstance<TestRuntimeObject>() == 0);

            ro = new TestRuntimeObject;

            TEST_CASE("1","󥹥ȥ饯¹ԤƤ", TestSuite::isReached("TestRuntimeObject::TestRuntimeObject"));
            TEST_CASE("2","ϿƤ", RuntimeObjectTable::getInstance<TestRuntimeObject>() == ro);

            delete ro;

            TEST_CASE("3","ǥȥ饯¹ԤƤ", TestSuite::isReached("TestRuntimeObject::~TestRuntimeObject"));
            TEST_CASE("4","ϿƤ", RuntimeObjectTable::getInstance<TestRuntimeObject>() == 0);

        } END_CASE;

        BEGIN_CASE("2","ư˴Υå") {
            TestRuntimeObject * ro;
            TestRuntimeObject2 * ro2;

            TestSuite::clearCheckpoints();

            TEST_CASE("0","[] ϿƤʤ", RuntimeObjectTable::getInstance<TestRuntimeObject>() == 0);
            TEST_CASE("0","[] ϿƤʤ", RuntimeObjectTable::getInstance<TestRuntimeObject2>() == 0);

            ro = new TestRuntimeObject;
            ro2 = new TestRuntimeObject2;

            TEST_CASE("1","󥹥ȥ饯¹ԤƤ(ro)", TestSuite::isReached("TestRuntimeObject::TestRuntimeObject"));
            TEST_CASE("2","󥹥ȥ饯¹ԤƤ(ro2)", TestSuite::isReached("TestRuntimeObject2::TestRuntimeObject2"));
            TEST_CASE("3","ϿƤ(ro)", RuntimeObjectTable::getInstance<TestRuntimeObject>() == ro);
            TEST_CASE("4","ϿƤ(ro2)", RuntimeObjectTable::getInstance<TestRuntimeObject2>() == ro2);

            Singleton<RuntimeObjectTable>::getInstance()->clear();

            TEST_CASE("5","ǥȥ饯ϼ¹ԤƤʤ (ro)", !TestSuite::isReached("TestRuntimeObject::~TestRuntimeObject"));
            TEST_CASE("6","ǥȥ饯ϼ¹ԤƤ (ro2)", TestSuite::isReached("TestRuntimeObject2::~TestRuntimeObject2"));
            TEST_CASE("7","ϿƤ", RuntimeObjectTable::getInstance<TestRuntimeObject>() == 0);
            TEST_CASE("8","ϿƤ", RuntimeObjectTable::getInstance<TestRuntimeObject2>() == 0);

            delete ro;
        } END_CASE;

    } END_CASE;

    Singleton<RuntimeObjectTable>::restoreContext(context);
}

#endif

