/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: message.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/base/message.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $

#include "base/message.h"

using namespace std;


/*****************************************************************************/

/*
 *   åʸإѡ饹
 */

    //ǥեȥ󥹥ȥ饯
Formatter::Formatter(void) throw() : templatestring(""), accept(false)
{}

    //󥹥ȥ饯
Formatter::Formatter(string src) throw() : templatestring(src)
{   shift();   }

    //ԡ󥹥ȥ饯
Formatter::Formatter(const Formatter & src) throw() : templatestring(src.templatestring), accept(src.accept)
{
    string work;

    work = src.content.str();
    content << work;
}

    //ΰؤȰư
void Formatter::shift(void) throw()
{
    string::size_type pos;

    accept = false;
    if(!templatestring.empty()) {

        do {
            pos = templatestring.find_first_of("%");

            if(pos != string::npos) {

                    /* %äƤ줬\%Ȥʤ顢%򤽤Τޤ޽Ф */
                if(pos != string::npos && pos != 0 && templatestring.at(pos - 1) == '\\') {

                    if(pos > 1)
                        content << templatestring.substr(0, pos - 2);
                    content << '%';

                    templatestring = templatestring.substr(pos + 1);

                    continue;
                }
                else {
                        /* %ޤ */
                    if(pos != string::npos)
                        accept = true;
                    break;
                }
            }
        } while(pos != string::npos);

        if(pos != string::npos) {
            if(pos != 0)
                content << templatestring.substr(0, pos);
            templatestring = templatestring.substr(pos + 1);
        }
        else {
            content << templatestring;
            templatestring.erase();
        }
    }
}


    //̤ΰ (null) ִ
void Formatter::shift_all(void) throw()
{
    while(accept)
        *this << "(null)";
}

    //åμФ
string Formatter::str(void) throw()
{
    shift_all();
    return content.str();
}

    //ƥץ졼ʸ (ȤϾä)
void Formatter::assign(string src) throw()
{
    clear();
    templatestring.assign(src);
    shift();
}

    //Ƥξõ
void Formatter::clear(void) throw()
{
    if(!templatestring.empty())
        templatestring.erase();
    content.str(string(""));
    accept = false;
}

    //黻
Formatter & Formatter::operator =(const Formatter & src) throw()
{
    string work;

    templatestring = src.templatestring;
    accept         = src.accept;

    work = src.content.str();
    content << work;

    return *this;
}


/*****************************************************************************/

/*
 *   åʸإѡ饹
 */

const char * Message::MessageControl::select(const char * msg1, const char * msg2, va_list vl) throw()
{
    const char * msg = msg1;
    int i = language;

    if(i > 0) {
        msg = msg2;

        while(--i > 0)
            msg = va_arg(vl, const char *);
    }

    return msg;
}

    //ǥեȥ󥹥ȥ饯 (ƥ)
Message::Message(void) throw()
{}

    //󥹥ȥ饯
Message::Message(string src) throw() : Formatter(src)
{}

    //󥹥ȥ饯 (ʣ)
Message::Message(const char * src1, const char * src2, ...) throw()
{
    va_list vl;

    va_start(vl, src2);
    templatestring.assign(Singleton<MessageControl>::getInstance()->select(src1, src2, vl));
    shift();
}

    //ԡ󥹥ȥ饯
Message::Message(const Message & src) throw() : Formatter(src)
{}

    //饹νѴؿ (ʣ)
void Message::_initialize(const char * src1, const char * src2, va_list vl) throw()
{
    content.clear();
    accept = false;
    templatestring.assign(Singleton<MessageControl>::getInstance()->select(src1, src2, vl));
    shift();
}

    //
void Message::selectLanguage(enum tagLanguage lang) throw()
{
    if(lang >= 0 && lang < LAST_LANG)
        Singleton<Message::MessageControl>::getInstance()->setLanguage(lang);
}

    //ƥץ졼ʸ (ȤϾä)
void Message::assign(const char * src1, const char * src2, ... ) throw()
{
    va_list vl;

    clear();

    va_start(vl, src2);
    templatestring.assign(Singleton<MessageControl>::getInstance()->select(src1, src2, vl));
    shift();
}

/*****************************************************************************/

/*
 *   Ĺʸإѡ饹
 */

    //ǥեȥ󥹥ȥ饯
VerboseMessage::VerboseMessage(void) throw() : Message()
{}

    //󥹥ȥ饯
VerboseMessage::VerboseMessage(const char * src) throw() : Message(src)
{}

    //󥹥ȥ饯
VerboseMessage::VerboseMessage(const string & src) throw() : Message(src)
{}

    //󥹥ȥ饯
VerboseMessage::VerboseMessage(const char * src1, const char * src2, ... ) throw() : Message()
{
    va_list vl;

    va_start(vl, src2);
    _initialize(src1, src2, vl);
}

    //ǥȥ饯
VerboseMessage::~VerboseMessage(void) throw()
{   Singleton< VerboseControl >::getInstance()->operator << (str());    }

/*****************************************************************************/

/*
 *   㳰åʸإѡ饹
 */

    //󥹥ȥ饯
ExceptionMessage::ExceptionMessage(const char * src) throw() : Message(src), level(DEFAULT)
{}

    //󥹥ȥ饯
ExceptionMessage::ExceptionMessage(const std::string & src) throw() : Message(src), level(DEFAULT)
{}

    //󥹥ȥ饯
ExceptionMessage::ExceptionMessage(const char * src1, const char * src2, ...) throw() : Message(), level(DEFAULT)
{
    va_list vl;
    
    va_start(vl, src2);
    _initialize(src1, src2, vl);
}

    //󥹥ȥ饯
ExceptionMessage::ExceptionMessage(enum tagLevel _level) throw() : Message(), level(_level)
{}

    //󥹥ȥ饯
ExceptionMessage::ExceptionMessage(enum tagLevel _level, const char * src) throw() : Message(src), level(_level)
{}

    //󥹥ȥ饯
ExceptionMessage::ExceptionMessage(enum tagLevel _level, const std::string & src) throw() : Message(src), level(_level)
{}

    //󥹥ȥ饯
ExceptionMessage::ExceptionMessage(enum tagLevel _level, const char * src1, const char * src2, ...) throw() : Message(), level(_level)
{
    va_list vl;
    
    va_start(vl, src2);
    _initialize(src1, src2, vl);
}

    //ԡ󥹥ȥ饯
ExceptionMessage::ExceptionMessage(const ExceptionMessage & src) throw() : Message(src), level(src.level)
{}


/*****************************************************************************/

/*
 *   ǥХååʸإѡ饹
 */

    //󥹥ȥ饯
DebugMessage::DebugMessage(string src) throw() : Formatter(src)
{}

    //ǥȥ饯
DebugMessage::~DebugMessage(void) throw()
{   Singleton<DebugControl>::getInstance()->operator << (str());    }

