/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: mpstrstream.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/base/mpstrstream.h,v 1.1 2009/01/31 05:27:37 suikan Exp $

#ifndef MPSTRSTREAM_H
#define MPSTRSTREAM_H

#ifdef _MSC_VER
#  pragma warning(disable:4290) //C++ 㳰λ̵뤵ޤؿ __declspec(nothrow) ǤʤȤΤɽޤ
#  pragma warning(disable:4786) //ǥХåǼ̻Ҥ255ʸڤΤƤޤ
#endif

#include "testsuite.h"
#include "base/except.h"
#include "base/message.h"
#include "base/event.h"

#include <fstream>
#include <sstream>
#include <string>
#include <list>


    //ʣ̤ʤѥȥ꡼Υ饹
class MultipartStream : public Event<ShutdownEvent>::Handler
{
public:

        //ʣ̤ʤѥȥ꡼ΰ̤륯饹
    class Part
    {
    protected:
        std::string       name;
        std::stringstream stream;

    public:
            //󥹥ȥ饯
        Part(std::string name) throw();
        Part(const Part & src) throw();

            //Ƚ
        inline bool isValid(void) const throw()
        {   return (this != 0) && !name.empty() && stream.good();   }

            //ȥ꡼ؤν
        template<class T>
        Part & operator << ( T src ) throw(Exception)
        {
            if(isValid())
                stream << src;
            else
                ExceptionMessage("Operation was performed against an invalid stream.","̵ʥȥ꡼ФԤޤ").throwException();

            return *this;
        }

            //ȥ꡼˽񤤤Ƥ
        std::string getContents(void) const throw(Exception);

            //ȥ꡼Ƥľꤹ
        void setContents(std::string contents) throw(Exception);

            //ȥ꡼̾λ
        inline const std::string & getName(void) const throw(Exception)
        {
            if(!isValid())
                ExceptionMessage("Operation was performed against an invalid stream.","̵ʥȥ꡼ФԤޤ").throwException();
            return name;
        }

            //黻
        inline Part & operator = (const Part & src) throw()
        {
            name = src.name;
            stream.clear();
            stream << src.stream.str();
        
            return *this;
        }

        TESTSUITE_PROTOTYPE(main)
    };


protected:
    std::string         filename;       //Ϣդ줿ե̾
    std::list<Part>     parts;          //̽(Ĥ)
    Part *              current;        //Ƥ
    bool                dirty;          //ե˽Ϥפtrue (񤭹... ǤϤʤޤϤƤʤɤ)
    bool                output;         //ϤƤɤʤtrue

    virtual void handler(ShutdownEvent & evt)
    {   serialize();    }
  
public:
        //󥹥ȥ饯
    MultipartStream(std::string filename = "") throw();

        //ǥȥ饯
    virtual ~MultipartStream(void) throw();

        //Ƚ
    inline bool isValid(void) const throw()
    {   return (this != 0) && !filename.empty();   }

        //ե̾
    std::string setFilename(std::string filename) throw(Exception);
    std::string getFilename(void) const throw() { return filename; };

        //ȥ꡼Ƥե˽
    bool serialize(void) throw(Exception);

        //̤
    MultipartStream & createPart(std::string name, bool precedence = false) throw(Exception);

        //̤
    MultipartStream & movePart(std::string name) throw(Exception);

        //Ϥ뤫ɤ
    inline void enableOutput(void) throw()
    {   if(isValid()) output = true;   }
    inline void disableOutput(void) throw()
    {   if(isValid()) output = false;   }

        //ƥӥåȤ
    inline void setDirty(bool _dirty = true) throw()
    {   dirty = _dirty;   }

        //
    template <class T>
    inline MultipartStream & operator << ( T src ) throw(Exception)
    {
        if(this != 0 && current != 0) {
            setDirty();
            (*current) << src;
        }
        else
            ExceptionMessage("Invalid operation against an invalid object","̵ʥ֥ȤФ׵").throwException();
        return *this;
    }

        //̤ (Synonym)
    inline MultipartStream & operator[] (std::string name) throw(Exception)
    {   return movePart(name);   }

    TESTSUITE_PROTOTYPE(main)
};

#endif


