/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *
 */

/*
 *	ޥɥ饤СADSP-BF537ѡ
 *
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>


#ifndef _MACRO_ONLY

#ifdef __GNUC__			// gcc
#include "../cdefbf537.h"
#elif defined(__ECC__)	// visualdsp
#include <cdefbf53x.h>
#else
#error "Compiler is not supported"
#endif

//#include <ccblkfn.h>




/**************************************************************
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 *
 **************************************************************/
Inline void
hw_timer_initialize()
{
#ifndef USE_TIC_CORE
	UW	reg;
#endif

#ifdef USE_TIC_CORE
	// Core timer
	*pTCNTL = TMPWR;					// power up timer;
	*pTPERIOD = CORECLOCK/1000;			// CORE CLOCK is defined in sys_config.h
	*pTCNTL = TMPWR | TMREN | TAUTORLD;
#else
	// GPT7(General-purpose timer7)

	*pTIMER7_CONFIG = PERIOD_CNT | OUT_DIS |IRQ_ENA | PWM_OUT;	// PWM_OUT, Output Pad disable
	*pTIMER7_PERIOD = SYSCLOCK/1000;	// SYS CLOCK is defined in sys_config.h
	*pTIMER7_WIDTH = 1;					// 0 < width < period
	*pTIMER_ENABLE = TIMEN7;			// timer7 start
	ena_int( INHNO_TIMER );				// enable Timer Interrupt

#endif
	asm("ssync;");

}

/**************************************************************
 *  ޳׵Υꥢ
 **************************************************************/
Inline void
hw_timer_int_clear()
{
#ifdef USE_TIC_CORE
	// Core timer
	*pTCNTL = TMPWR | TMREN | TAUTORLD | TINT;
#else
	// GPT7(General-purpose timer7)
	*pTIMER_STATUS = TIMIL7;
#endif
	asm("ssync;");
}

/**************************************************************
 *  ޤ߽
 *
 *  ޤưߤ롥
 **************************************************************/
Inline void
hw_timer_terminate()
{
	/*
	 *  ޤưߤ롥
	 */
#ifdef USE_TIC_CORE
	// Core timer
	*pTCNTL = TMPWR | TAUTORLD | TINT;		// 
	*pTCNTL = 0;							// ѥ⡼
#else
	// GPT2(General-purpose timer7)
	*pTIMER_DISABLE = TIMEN7;			// timer7 disable
#endif
	asm("ssync;");
}


#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
