/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  
 */


#define _MACRO_ONLY

/*
 *	ͥѤΥȥåץ⥸塼BLACKfinѡ
 */
 
#include "jsp_kernel.h"
 


			// ߡ㳰ꥯȤ㳰
#define RETURNREQ 0xf

			// 32bit 쥸¨ͤɤޥ
#ifdef __GNUC__
#define LOADLABEL( reg, value32 ) reg##.h = value32; reg##.l = value32;
#define LOADVALUE( reg, value32 ) reg##.h = ( value32 >> 16 ) &0xFFFF; reg##.l = value32 & 0xFFFF;
#elif defined(__ECC__)
#define LOADVALUE( reg, value32 ) reg##.h = hi(value32); reg##.l = lo(value32);
#define LOADLABEL LOADVALUE
#else
#error "Compiler is not supported"
#endif


#ifdef __GNUC__
#include "cdef_LPBlackfin.h"		/* gnu tool chain */
#elif defined(__ECC__)
#include <cdef_lpblackfin.h>	/* VisualDSP++ */
#else
#error "Compiler is not supported"
#endif

#include "saverestore.h"


#ifdef __GNUC__
.section .init;
.extern _boot_for_gdb;
.extern __bss_start, __bss_end;
#elif defined(__ECC__)
.section program;
#else
#error "Compiler is not supported"
#endif

.global start;
.extern _exc_vector;
.extern ldf_stack_end;
.extern _kernel_start;
.extern _reqflg;
.extern expEntry;
.extern nmiEntry;
.extern ivHWEntry;
.extern ivTMREntry;
.extern ivg7Entry;
.extern ivg8Entry;
.extern ivg9Entry;
.extern ivg10Entry;
.extern ivg11Entry;
.extern ivg12Entry;
.extern ivg13Entry;
.extern ivg14Entry;

#ifdef USE_RUNTIME_INIT
.extern _mi_initialize;
#endif

start:
	R0 = 0;
	LC0 = R0;
	LC1 = R0;
	L0 = R0;
	L1 = R0;
	L2 = R0;
	L3 = R0;
    LOADLABEL( p0, ldf_stack_end )
    sp = p0;
#ifdef __GNUC__                 // bssΰν
    LOADLABEL( r0, __bss_start) // bss
    LOADLABEL( r1, __bss_end )
    r2 = r1 - r0;            // bssΥ
    p0 = r0;                // ϥɥ쥹
    p2 = r2;
    r0 = 0;
    loop bssfill lc0 = p2; 
loop_begin bssfill
        b[p0++] = r0;
loop_end bssfill;

    sp += -12;
    call _boot_for_gdb;     // gdbǥɤȤ˥ꥻåȤμ¤ˤ뤿Υ
    sp += 12;
#elif defined(__ECC__)
#else
#error "Compiler is not supported"
#endif

#ifdef USE_RUNTIME_INIT			// board_config.h 򻲾
	sp += -12;
	call _mi_initialize;		// ơ֥
	sp += 12;
	cc = r0;					// ֤ͤå
invalid : 
	if cc jump invalid; 		// 0ʤ饨顼
#endif
					// TOPPERS/JSP for BLACKfin emu,rst,nmiʤ
	LOADVALUE( p0,EVT0+2*4)	// NMI٥ȥ
	p1 = 4;


	LOADLABEL( r0, nmiEntry )		// NMI
	[p0++p1] = r0;

	LOADLABEL( r0, expEntry)		// EXP
	[p0++p1] = r0;

	p0 = p0+p1;					// ͽΰ򥹥å

	LOADLABEL( r0, ivHWEntry)		// ϡɥ顼
	[p0++p1] = r0;

	LOADLABEL( r0, ivTMREntry)		// ޡ
	[p0++p1] = r0;

	LOADLABEL( r0, ivg7Entry)		// IVG7
	[p0++p1] = r0;

	LOADLABEL( r0, ivg8Entry)		// IVG8
	r0.H = ivg8Entry;
	[p0++p1] = r0;

	LOADLABEL( r0, ivg9Entry)		// IVG9
	[p0++p1] = r0;

	LOADLABEL( r0, ivg10Entry)		// IVG10
	[p0++p1] = r0;

	LOADLABEL( r0, ivg11Entry)		// IVG11
	[p0++p1] = r0;

	LOADLABEL( r0, ivg12Entry)		// IVG12
	[p0++p1] = r0;

	LOADLABEL( r0, ivg13Entry)		// IVG13
	[p0++p1] = r0;

	LOADLABEL( r0, ivg14Entry)		// IVG14
	[p0++p1] = r0;

	LOADLABEL( r0, task_level)		// IVG15ϥܤ뤿Υȥ꡼
	[p0++p1] = r0;
	
	LOADLABEL( p2, user)				// ߡϤ
	reti = p2;
	csync;
	raise	15;					// IVG15롣ߤٱȯ롣
	
	r0 = 0xC01F(z);				// IVG15ղǽ(CPUå)
	sti r0;
	csync;
	rti;						// 桼⡼ɤܤ
	
task_level:                     // 饿μ¹Խ
    r0 = syscfg;
    r1 = 0x4;                   // աͥƥ󥰳
    r0 = r0 | r1;
    syscfg = r0;                // աͥȤͭ

    sp += -12;
#ifdef __GNUC__					/* GCC */
#elif defined(__ECC__)			/* VisualDSP++ */
#ifdef INIT_C_PLUS_PLUS
    r0 = 0;
    r1 = 0;
    call.x ___ctorloop;
#endif
#else
#error "Compiler is not supported"
#endif

    [--sp] = reti;				// ϤΤƤƳ߲ǽˤ
    jump.x _kernel_start;			// kernel_stgart()äƤʤ
user:
	jump	user;
start.end:







#ifdef __GNUC__
#elif defined(__ECC__)

#ifdef INIT_C_PLUS_PLUS
.section ctor;
	.align 4;
___ctor_table:
	.byte4=0;
.global ___ctor_table;
.type ___ctor_table,STT_OBJECT;
.extern ___ctorloop;
.section .gdt;
        .align 4;
___eh_gdt:
.global ___eh_gdt;
        .byte4=0;
.type ___eh_gdt,STT_OBJECT;
.section .frt;
        .align 4;
___eh_frt:
.global ___eh_frt;
        .byte4=0;
.type ___eh_frt,STT_OBJECT;
#endif  /* INIT_C_PLUS_PLUS */

#else
#error "Compiler is not supported"
#endif

