/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: dve68k.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	DVE68K/40 CPUܡɤΥϡɥ񸻤
 */

#ifndef _DVE68K_H_
#define _DVE68K_H_

/*
 *  ߥ٥ȥ
 */
#define	TVEC_G0I	0x40u		/* 롼0 ߥ٥ȥ */
#define TVEC_SQR	0x42u		/* SQR ߥ٥ȥ */
#define TVEC_ABT	0x46u		/* ܡȳߥ٥ȥ */

#define	TVEC_G1I	0x48u		/* 롼1 ߥ٥ȥ */
#define	TVEC_GP0	0x48u		/* ꥢI/O ߥ٥ȥ */
#define	TVEC_TT0	0x4cu		/* 0 ߥ٥ȥ */

#define	TVEC_SWI	0X50u		/* եȥߥ٥ȥ */
#define	TVEC_SPRI	0x40u		/* ץꥢߥ٥ȥ */

/*
 *  CPUܡɾΥ쥸
 */
#define TADR_BOARD_REG0		0xfff48000
#define TADR_BOARD_REG1		0xfff48004
#define TADR_BOARD_REG2		0xfff48008

/*
 *  DGA-001Υ쥸Υɥ쥹
 */
#define TADR_DGA_CSR0		0xfff44000
#define TADR_DGA_CSR1		0xfff44004
#define TADR_DGA_CSR3		0xfff4400c
#define TADR_DGA_CSR4		0xfff44010
#define TADR_DGA_CSR5		0xfff44014
#define TADR_DGA_CSR12		0xfff44030
#define TADR_DGA_CSR13		0xfff44034
#define	TADR_DGA_CSR19		0xfff4404c
#define	TADR_DGA_CSR20		0xfff44050
#define	TADR_DGA_CSR21		0xfff44054
#define TADR_DGA_CSR23		0xfff4405c
#define TADR_DGA_CSR24		0xfff44060
#define	TADR_DGA_CSR25		0xfff44064
#define	TADR_DGA_IFR0		0xfff44070
#define TADR_DGA_IFR3		0xfff4407c

/*
 *  DGAؤΥؿ
 */
#define	dga_rew_reg(addr)		sil_rew_mem(addr)
#define dga_wrw_reg(addr, val)		sil_wrw_mem(addr, val)

/*
 *  PD72001MPSCˤΥ쥸Υɥ쥹
 */
#define	TADR_UPD72001_DATAA	0xfff45003
#define	TADR_UPD72001_CTRLA	0xfff45007
#define	TADR_UPD72001_DATAB	0xfff4500b
#define	TADR_UPD72001_CTRLB	0xfff4500f

/*
 *  PD72001ؤΥؿ
 */
#define	upd72001_reb_reg(addr)		sil_reb_mem(addr)
#define upd72001_wrb_reg(addr, val)	sil_wrb_mem(addr, val)

/*
 *  GDB STUBƽФ롼
 */
#ifndef _MACRO_ONLY
#ifdef GDB_STUB

Inline void
dve68k_exit()
{
	Asm("trap #2");
}

Inline void
dve68k_putc(char c)
{
	Asm("move.l %0, %%d1; trap #3"
	  : /* no output */
	  : "g"((INT) c)
	  : "d0", "d1", "d2", "d6", "d7");
}

/*
 *  ˥ƽФ롼
 */
#else /* GDB_STUB */

Inline void
dve68k_exit()
{
	Asm("clr.l %%d0; trap #3"
	  : /* no output */
	  : /* no input */
	  : "d0", "d1", "d2", "d6", "d7");
}

Inline char
dve68k_getc()
{
	INT	c;

	Asm("moveq.l #3, %%d0; trap #3; move.l %%d0, %0"
	  : "=g"(c)
	  : /* no input */
	  : "d0", "d1", "d2", "d6", "d7");
	  return((char) c);
}

Inline void
dve68k_putc(char c)
{
	Asm("moveq.l #5, %%d0; move.l %0, %%d1; trap #3"
	  : /* no output */
	  : "g"((INT) c)
	  : "d0", "d1", "d2", "d6", "d7");
}

#endif /* GDB_STUB */
#endif /* _MACRO_ONLY */
#endif /* _DVE68K_H_ */
