/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_serial.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	ꥢI/OǥХSIO˥ɥ饤СDVE68K/40ѡ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#include <dve68k_dga.h>
#ifndef _MACRO_ONLY
#include <upd72001.h>
#endif /* _MACRO_ONLY */

/*
 *  SIOγߥϥɥΥ٥ֹ
 */
#define INHNO_SIO	TVEC_GP0

#ifndef _MACRO_ONLY

/*
 *  SIOɥ饤Фν롼
 */
#define	sio_initialize	upd72001_initialize

/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

	/*
	 *  ץ󤷤ݡȤ뤫 openflag ɤǤ
	 */
	openflag = upd72001_openflag();

	/*
	 *  ǥХ¸Υץ
	 */
	siopcb = upd72001_opn_por(siopid, exinf);

	/*
	 *  ꥢI/Oߤγߥ٥ꤷޥ롥
	 */
	if (!openflag) {
		dga_set_ilv((VP) TADR_DGA_CSR25, TBIT_GP0IL, TIRQ_LEVEL6);
		dga_bit_or((VP) TADR_DGA_CSR21, TBIT_GP0);
	}
	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  ǥХ¸Υ
	 */
	upd72001_cls_por(siopcb);

	/*
	 *  ꥢI/Oߤޥ롥
	 */
	if (!upd72001_openflag()) {
		dga_bit_and((VP) TADR_DGA_CSR21, ~TBIT_GP0);
	}
}

/*
 *  SIOγߥϥɥ
 */
#define	sio_handler	upd72001_isr

/*
 *  ꥢI/OݡȤؤʸ
 */
#define	sio_snd_chr	upd72001_snd_chr

/*
 *  ꥢI/OݡȤʸ
 */
#define	sio_rcv_chr	upd72001_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define	sio_ena_cbr	upd72001_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define	sio_dis_cbr	upd72001_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 */
#define	sio_ierdy_snd	upd72001_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 */
#define	sio_ierdy_rcv	upd72001_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
