/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.c,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	åȥƥ¸⥸塼DVE68K/40ѡ
 */

#include "jsp_kernel.h"
#include <sil.h>
#include <dve68k_dga.h>

/*
 *  ץå̤Τѿʥޥץåб
 */
UINT	board_id;		/* ܡID */
VP	board_addr;		/* Ƭɥ쥹 */

/*
 *  åȥƥ¸ν
 */
void
sys_initialize()
{
	/*
	 *  ץå̤Τѿν
	 */
	board_id = ((UINT)(sil_rew_mem((VP) TADR_BOARD_REG0)) & 0x1f);
	board_addr = (VP)(board_id << 24);

	/*
	 *  ߴϢν
	 *
	 *  ٤Ƥγߤޥꥢߥ٥ȥꤹ롥
	 */
	dga_write((VP) TADR_DGA_CSR21, 0);
	dga_write((VP) TADR_DGA_CSR23, ~0);
	dga_write((VP) TADR_DGA_CSR19, (TVEC_G0I << 24) | (TVEC_G1I << 16)
					| (TVEC_SWI << 8) | TVEC_SPRI);

	/*
	 *  ܡȳߤNMI
	 *
	 *  ܡȳߤγߥ٥ꤷ׵򥯥ꥢ塤
	 *  ޥ롥
	 */
	dga_set_ilv((VP) TADR_DGA_CSR24, TBIT_ABTIL, TIRQ_NMI);
	dga_write((VP) TADR_DGA_CSR23, TBIT_ABT);
	dga_bit_or((VP) TADR_DGA_CSR21, TBIT_ABT);

	/*
	 *  ΰ
	 *
	 *  VMEХǤƬɥ쥹ȥ16MB
	 *  դ褦ꤹ롥ޤVMEХ
	 *  ĥɥ쥹դ褦ˤꤹ롥
	 */
	dga_write((VP) TADR_DGA_CSR4, (UW) board_addr | 0x00ff);
	dga_write((VP) TADR_DGA_CSR5, 0x0000012fu);

	/*
	 *  󥿥ե쥸IFRˤ
	 *
	 *  󥿥ե쥸Υ١ɥ쥹ꤹ롥ޤ
	 *  󥿥ե쥸0Υӥꥯȥե饰򥯥ꥢ
	 *  󥿥ե쥸3˥ܡɤIDֹꡥ
	 */
	dga_write((VP) TADR_DGA_CSR3, (board_id << 4) | 0x3);
	dga_write((VP) TADR_DGA_IFR0, 0x80000000u);
	dga_write((VP) TADR_DGA_IFR3, board_id);

	/*
	 *  饦ɥӥ⡼ɤʥޥץåб
	 */
	dga_write((VP) TADR_DGA_CSR1, (dga_read((VP) TADR_DGA_CSR1)
			& 0xffeffcff) | (1u << 20) | ((board_id % 4) << 8));
}

/*
 *  åȥƥνλ
 */
void
sys_exit()
{
	dve68k_exit();
}

/*
 *  åȥƥʸ
 */
void
sys_putc(char c)
{
	if (c == '\n') {
		dve68k_putc('\r');
	}
	dve68k_putc(c);
}
