/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: kernel.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	ITRON4.0ɸ।󥯥롼ɥե
 *
 *  ΥեǤϡɥץեɬפʤΤȡJSP
 *  ͥȼγĥǽɬפʤΤƤ롥ǡϡ
 *  ɥץե礦ɤĹˤϤƤʤ
 *
 *  ֥Υե䥷ƥॳե졼ե
 *  뤫餳Υե򥤥󥯥롼ɤϡ_MACRO_ONLY 
 *  ȤǡޥʳεҤȤǤ롥
 *
 *  Υ󥯥롼ɥեϡɸ।󥯥롼ɥեt_services.h 
 *   jsp_kernel.hˤǥ󥯥롼ɤ롥ޤ¾ ITRONOS 
 *  եȥݡƥ󥰤ʤɤˤϡΥեľܥ
 *  롼ɤƤ褤㳰ơ¾Υե뤫ľܥ󥯥롼
 *  ɤ뤳ȤϤʤ
 *
 *  ǥ󥯥롼ɤƤեơ¾Υ󥯥롼ɥե
 *  ˰¸Ƥʤ
 */

#ifndef _KERNEL_H_
#define _KERNEL_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  ͥ롦ץꥱ ̥󥯥롼ɥե
 */
#include <t_stddef.h>

/*
 *  ITRONͶ̵Υǡޥ
 */
#include <itron.h>

/*
 *  ƥץå˰¸
 */
#include <sys_defs.h>
#include <cpu_defs.h>

/*
 *  ƥӥΤ
 */
#include <t_syslog.h>

/*
 *  ޥ
 */
#define	TROUND_VP(sz)	(((sz) + sizeof(VP) - 1) & ~(sizeof(VP) - 1))
#define	TCOUNT_VP(sz)	(((sz) + sizeof(VP) - 1) / sizeof(VP))

/*
 *  ǡ
 */
#ifndef _MACRO_ONLY

typedef	UINT		TEXPTN;		/* 㳰װΥӥåȥѥ */
typedef	UINT		FLGPTN;		/* ٥ȥե饰Υӥåȥѥ */

typedef	struct t_msg {			/* ᡼ܥåΥåإå */
	struct t_msg	*next;
} T_MSG;

typedef	struct t_msg_pri {		/* ͥդåإå */
	T_MSG		msgque;		/* åإå */
	PRI		msgpri;		/* åͥ */
} T_MSG_PRI;

#endif /* _MACRO_ONLY */

/*
 *  ӥ
 */
#ifndef _MACRO_ONLY

/*
 *  ǽ
 */
extern ER	act_tsk(ID tskid) throw();
extern ER	iact_tsk(ID tskid) throw();
extern ER_UINT	can_act(ID tskid) throw();
extern void	ext_tsk(void) throw();
extern ER	ter_tsk(ID tskid) throw();
extern ER	chg_pri(ID tskid, PRI tskpri) throw();
extern ER	get_pri(ID tskid, PRI *p_tskpri) throw();

/*
 *  °Ʊǽ
 */
extern ER	slp_tsk(void) throw();
extern ER	tslp_tsk(TMO tmout) throw();
extern ER	wup_tsk(ID tskid) throw();
extern ER	iwup_tsk(ID tskid) throw();
extern ER_UINT	can_wup(ID tskid) throw();
extern ER	rel_wai(ID tskid) throw();
extern ER	irel_wai(ID tskid) throw();
extern ER	sus_tsk(ID tskid) throw();
extern ER	rsm_tsk(ID tskid) throw();
extern ER	frsm_tsk(ID tskid) throw();
extern ER	dly_tsk(RELTIM dlytim) throw();

/*
 *  㳰ǽ
 */
extern ER	ras_tex(ID tskid, TEXPTN rasptn) throw();
extern ER	iras_tex(ID tskid, TEXPTN rasptn) throw();
extern ER	dis_tex(void) throw();
extern ER	ena_tex(void) throw();
extern BOOL	sns_tex(void) throw();

/*
 *  Ʊ̿ǽ
 */
extern ER	sig_sem(ID semid) throw();
extern ER	isig_sem(ID semid) throw();
extern ER	wai_sem(ID semid) throw();
extern ER	pol_sem(ID semid) throw();
extern ER	twai_sem(ID semid, TMO tmout) throw();

extern ER	set_flg(ID flgid, FLGPTN setptn) throw();
extern ER	iset_flg(ID flgid, FLGPTN setptn) throw();
extern ER	clr_flg(ID flgid, FLGPTN clrptn) throw();
extern ER	wai_flg(ID flgid, FLGPTN waiptn,
			MODE wfmode, FLGPTN *p_flgptn) throw();
extern ER	pol_flg(ID flgid, FLGPTN waiptn,
			MODE wfmode, FLGPTN *p_flgptn) throw();
extern ER	twai_flg(ID flgid, FLGPTN waiptn,
			MODE wfmode, FLGPTN *p_flgptn, TMO tmout) throw();

extern ER	snd_dtq(ID dtqid, VP_INT data) throw();
extern ER	psnd_dtq(ID dtqid, VP_INT data) throw();
extern ER	ipsnd_dtq(ID dtqid, VP_INT data) throw();
extern ER	tsnd_dtq(ID dtqid, VP_INT data, TMO tmout) throw();
extern ER	fsnd_dtq(ID dtqid, VP_INT data) throw();
extern ER	ifsnd_dtq(ID dtqid, VP_INT data) throw();
extern ER	rcv_dtq(ID dtqid, VP_INT *p_data) throw();
extern ER	prcv_dtq(ID dtqid, VP_INT *p_data) throw();
extern ER	trcv_dtq(ID dtqid, VP_INT *p_data, TMO tmout) throw();

extern ER	snd_mbx(ID mbxid, T_MSG *pk_msg) throw();
extern ER	rcv_mbx(ID mbxid, T_MSG **ppk_msg) throw();
extern ER	prcv_mbx(ID mbxid, T_MSG **ppk_msg) throw();
extern ER	trcv_mbx(ID mbxid, T_MSG **ppk_msg, TMO tmout) throw();

/*
 *  סǽ
 */
extern ER	get_mpf(ID mpfid, VP *p_blk) throw();
extern ER	pget_mpf(ID mpfid, VP *p_blk) throw();
extern ER	tget_mpf(ID mpfid, VP *p_blk, TMO tmout) throw();
extern ER	rel_mpf(ID mpfid, VP blk) throw();

/*
 *  ִǽ
 */
extern ER	set_tim(const SYSTIM *p_systim) throw();
extern ER	get_tim(SYSTIM *p_systim) throw();
extern ER	isig_tim(void) throw();

extern ER	sta_cyc(ID cycid) throw();
extern ER	stp_cyc(ID cycid) throw();

/*
 *  ƥִǽ
 */
extern ER	rot_rdq(PRI tskpri) throw();
extern ER	irot_rdq(PRI tskpri) throw();
extern ER	get_tid(ID *p_tskid) throw();
extern ER	iget_tid(ID *p_tskid) throw();
extern ER	loc_cpu(void) throw();
extern ER	iloc_cpu(void) throw();
extern ER	unl_cpu(void) throw();
extern ER	iunl_cpu(void) throw();
extern ER	dis_dsp(void) throw();
extern ER	ena_dsp(void) throw();
extern BOOL	sns_ctx(void) throw();
extern BOOL	sns_loc(void) throw();
extern BOOL	sns_dsp(void) throw();
extern BOOL	sns_dpn(void) throw();

/*
 *  ȼӥ
 */
extern BOOL	vxsns_ctx(VP p_excinf) throw();
extern BOOL	vxsns_loc(VP p_excinf) throw();
extern BOOL	vxsns_dsp(VP p_excinf) throw();
extern BOOL	vxsns_dpn(VP p_excinf) throw();
extern BOOL	vxsns_tex(VP p_excinf) throw();
extern BOOL	vsns_ini(void) throw();

#endif /* _MACRO_ONLY */

/*
 *  ֥°
 */
#define TA_HLNG		0x00u		/* ѥ󥿥ե */
#define TA_ASM		0x01u		/* ֥ѥ󥿥ե */

#define TA_TFIFO	0x00u		/* ԤFIFO */
#define TA_TPRI		0x01u		/* Ԥͥٽ */

#define TA_MFIFO	0x00u		/* å塼FIFO */
#define TA_MPRI		0x02u		/* å塼ͥٽ */

#define TA_ACT		0x02u		/* ư줿֤ */

#define TA_WSGL		0x00u		/* ٥ȥե饰Ԥ1Ĥ */
#define TA_CLR		0x04u		/* ٥ȥե饰Υꥢ */

#define	TA_STA		0x02u		/* ϥɥư֤ */

/*
 *  ӥư⡼ɤ
 */
#define	TWF_ANDW	0x00u		/* ٥ȥե饰ANDԤ */
#define	TWF_ORW		0x01u		/* ٥ȥե饰ORԤ */

/*
 *  ¾
 */
#define	TSK_SELF	0		/*  */
#define	TSK_NONE	0		/* 륿ʤ */
#define	TPRI_SELF	0		/* Υ١ͥ٤λ */
#define	TPRI_INI	0		/* εưͥ٤λ */

/*
 *  ȥޥ
 */

/*
 *  ͥ٤ϰ
 */
#define	TMIN_TPRI	1		/* ͥ٤κǾ */
#define	TMAX_TPRI	16		/* ͥ٤κ */
#define	TMIN_MPRI	1		/* åͥ٤κǾ */
#define	TMAX_MPRI	16		/* åͥ٤κ */

/*
 *  С
 */
#define	TKERNEL_MAKER	0x0118u		/* ͥΥ᡼ */
#define	TKERNEL_PRID	0x0001u		/* ͥμֹ */
#define	TKERNEL_SPVER	0x5402u		/* ITRONͤΥСֹ */
#define	TKERNEL_PRVER	0x1043u		/* ͥΥСֹ */

/*
 *  塼󥰡ͥȲκ
 */
#define	TMAX_ACTCNT	1		/* ư׵ᥭ塼󥰿κ */
#define	TMAX_WUPCNT	1		/* ׵ᥭ塼󥰿κ */
#define	TMAX_SUSCNT	1		/* Ԥ׵ͥȿκ */

/*
 *  ӥåȥѥΥӥåȿ
 */
#define	TBIT_TEXPTN	(sizeof(TEXPTN) * CHAR_BIT)
					/* 㳰װΥӥåȿ */
#define	TBIT_FLGPTN	(sizeof(FLGPTN) * CHAR_BIT)
					/* ٥ȥե饰Υӥåȿ */

#ifdef __cplusplus
}
#endif

#endif /* _KERNEL_H_ */
