/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: t_syslog.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	ƥǽ
 *
 *  ƥӥϡƥΥϤ뤿Υӥ
 *  Ǥ롥ͥ뤫ΥνϤˤѤ뤿ᡤԤ
 *  ˤϤ뤳ȤϤʤ
 *
 *  ϡͥΥХåե˽񤭹फ٥ʸ
 *  ϴؿѤƽϤ롥ɤȤϡĥӥڤ
 *  뤳ȤǤ롥
 *
 *  Хåեΰ褬ХեˤϡŤäƾ
 *  񤭤롥
 *
 *  ֥Υե䥷ƥॳե졼ե
 *  뤫餳Υե򥤥󥯥롼ɤϡ_MACRO_ONLY 
 *  ȤǡޥʳεҤȤǤ롥
 *
 *  Υ󥯥롼ɥեϡkernel.h  sil.h ǥ󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤ뤳ȤϤʤ
 *
 *  Υե򥤥󥯥롼ɤˡt_stddef.h  itron.h 򥤥
 *  롼ɤƤȤɬפǤ롥
 */

#ifndef _T_SYSLOG_H_
#define _T_SYSLOG_H_

/*
 *  μ̤
 *
 *  LOG_TYPE_CYCLOG_TYPE_ASSERT ʳϡǥХå󥰥󥿥ե
 *  ͤȹפƤ롥
 */
#define LOG_TYPE_INH		0x01u	/* ߥϥɥ */
#define LOG_TYPE_ISR		0x02u	/* ߥӥ롼 */
#define LOG_TYPE_CYC		0x03u	/* ϥɥ */
#define LOG_TYPE_EXC		0x04u	/* CPU㳰ϥɥ */
#define LOG_TYPE_TEX		0x05u	/* 㳰롼 */
#define LOG_TYPE_TSKSTAT	0x06u	/* Ѳ */
#define LOG_TYPE_DSP		0x07u	/* ǥѥå */
#define LOG_TYPE_SVC		0x08u	/* ӥ */
#define LOG_TYPE_COMMENT	0x09u	/*  */
#define LOG_TYPE_ASSERT		0x0au	/* μ */

#define LOG_ENTER		0x00u	/*  */
#define LOG_LEAVE		0x80u	/* иλ */

/*
 *  ν٤
 */
#define LOG_EMERG	0u		/* åȥͤ륨顼 */
#define LOG_ALERT	1u
#define LOG_CRIT	2u
#define LOG_ERROR	3u		/* ƥ२顼 */
#define LOG_WARNING	4u		/* ٹå */
#define LOG_NOTICE	5u
#define LOG_INFO	6u
#define LOG_DEBUG	7u		/* ǥХåѥå */

#ifndef _MACRO_ONLY

/*
 *  Υǡ¤
 */

#define TMAX_LOGINFO	6

typedef struct {
		UINT	logtype;		/* μ */
		SYSTIM	logtim;			/*  */
		VP_INT	loginfo[TMAX_LOGINFO];	/* ¾Υ */
	} SYSLOG;

/*
 *  ν٤Υӥåȥޥåפ뤿Υޥ
 */
#define LOG_MASK(prio)	(1u << (prio))
#define LOG_UPTO(prio)	((1u << ((prio) + 1)) - 1)

#ifndef OMIT_SYSLOG

/*
 *  ν
 */
extern ER	vwri_log(UINT prio, SYSLOG *p_log) throw();

/*
 *  ХåեΥɽФ
 */
extern ER_UINT	vrea_log(SYSLOG *p_log) throw();

/* 
 *  Ϥ٤ν٤
 */
extern ER	vmsk_log(UINT logmask, UINT lowmask) throw();

/*
 *  Ϥ뤿Υ饤֥ؿ
 */

Inline ER
_syslog_0(UINT prio, UINT type)
{
	SYSLOG	log;

	log.logtype = type;
	return(vwri_log(prio, &log));
}

Inline ER
_syslog_1(UINT prio, UINT type, VP_INT arg1)
{
	SYSLOG	log;

	log.logtype = type;
	log.loginfo[0] = arg1;
	return(vwri_log(prio, &log));
}

Inline ER
_syslog_2(UINT prio, UINT type, VP_INT arg1, VP_INT arg2)
{
	SYSLOG	log;

	log.logtype = type;
	log.loginfo[0] = arg1;
	log.loginfo[1] = arg2;
	return(vwri_log(prio, &log));
}

Inline ER
_syslog_3(UINT prio, UINT type, VP_INT arg1, VP_INT arg2, VP_INT arg3)
{
	SYSLOG	log;

	log.logtype = type;
	log.loginfo[0] = arg1;
	log.loginfo[1] = arg2;
	log.loginfo[2] = arg3;
	return(vwri_log(prio, &log));
}

Inline ER
_syslog_4(UINT prio, UINT type, VP_INT arg1, VP_INT arg2,
				VP_INT arg3, VP_INT arg4)
{
	SYSLOG	log;

	log.logtype = type;
	log.loginfo[0] = arg1;
	log.loginfo[1] = arg2;
	log.loginfo[2] = arg3;
	log.loginfo[3] = arg4;
	return(vwri_log(prio, &log));
}

Inline ER
_syslog_5(UINT prio, UINT type, VP_INT arg1, VP_INT arg2,
				VP_INT arg3, VP_INT arg4, VP_INT arg5)
{
	SYSLOG	log;

	log.logtype = type;
	log.loginfo[0] = arg1;
	log.loginfo[1] = arg2;
	log.loginfo[2] = arg3;
	log.loginfo[3] = arg4;
	log.loginfo[4] = arg5;
	return(vwri_log(prio, &log));
}

Inline ER
_syslog_6(UINT prio, UINT type, VP_INT arg1, VP_INT arg2, VP_INT arg3,
				VP_INT arg4, VP_INT arg5, VP_INT arg6)
{
	SYSLOG	log;

	log.logtype = type;
	log.loginfo[0] = arg1;
	log.loginfo[1] = arg2;
	log.loginfo[2] = arg3;
	log.loginfo[3] = arg4;
	log.loginfo[4] = arg5;
	log.loginfo[5] = arg6;
	return(vwri_log(prio, &log));
}

#else /* OMIT_SYSLOG */

#define vwri_log(prio, p_log)		E_OK
#define vrea_log(p_log)			E_OK
#define vmsk_log(logmask, lowmask)	E_OK

#define _syslog_0(prio, type)						E_OK
#define _syslog_1(prio, type, arg1)					E_OK
#define _syslog_2(prio, type, arg1, arg2)				E_OK
#define _syslog_3(prio, type, arg1, arg2, arg3)				E_OK
#define _syslog_4(prio, type, arg1, arg2, arg3, arg4)			E_OK
#define _syslog_5(prio, type, arg1, arg2, arg3, arg4, arg5)		E_OK
#define _syslog_6(prio, type, arg1, arg2, arg3, arg4, arg5, arg6)	E_OK

#endif /* OMIT_SYSLOG */

/*
 *  ʥȡˤϤ뤿Υޥ
 *
 *  format Ӹ³ΰå򡤽 prio 
 *  ȤƽϤ뤿Υޥarg1argn  VP_INT˥
 *  Ȥ뤿ᡤVP_INT˷ѴǤǤդηǤ褤
 */

#define	syslog_0(prio, format) \
		_syslog_1(prio, LOG_TYPE_COMMENT, (VP_INT) format)

#define	syslog_1(prio, format, arg1) \
		_syslog_2(prio, LOG_TYPE_COMMENT, (VP_INT) format, \
							(VP_INT)(arg1))

#define	syslog_2(prio, format, arg1, arg2) \
		_syslog_3(prio, LOG_TYPE_COMMENT, (VP_INT) format, \
					(VP_INT)(arg1), (VP_INT)(arg2))

#define	syslog_3(prio, format, arg1, arg2, arg3) \
		_syslog_4(prio, LOG_TYPE_COMMENT, (VP_INT) format, \
			(VP_INT)(arg1), (VP_INT)(arg2), (VP_INT)(arg3))

#define	syslog_4(prio, format, arg1, arg2, arg3, arg4) \
		_syslog_5(prio, LOG_TYPE_COMMENT, (VP_INT) format, \
			(VP_INT)(arg1), (VP_INT)(arg2), (VP_INT)(arg3), \
							(VP_INT)(arg4))

#define	syslog_5(prio, format, arg1, arg2, arg3, arg4, arg5) \
		_syslog_6(prio, LOG_TYPE_COMMENT, (VP_INT) format, \
			(VP_INT)(arg1), (VP_INT)(arg2), (VP_INT)(arg3), \
					(VP_INT)(arg4), (VP_INT)(arg5))

/*
 *  ʥȡˤϤ뤿Υ饤֥ؿvasyslog.c
 */
extern ER	syslog(UINT prio, const char *format, ...) throw();

/* 
 *  ΥեޥåȽϡlog_output.c
 */
extern void	syslog_printf(const char *format, VP_INT *args,
						void (*putc)(char)) throw();
extern void	syslog_print(SYSLOG *p_log, void (*putc)(char)) throw();
extern void	syslog_output(void (*putc)(char)) throw();

#endif /* _MACRO_ONLY */
#endif /* _T_SYSLOG_H_ */
