/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: dataqueue.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	ǡ塼ǽ
 */

#ifndef _DATAQUEUE_H_
#define _DATAQUEUE_H_

#include "queue.h"

/*
 *  ǡ塼֥å
 */
typedef struct dataqueue_initialization_block {
	ATR	dtqatr;		/* ǡ塼° */
	UINT	dtqcnt;		/* ǡ塼ΰ */
	VP	dtq;		/* ǡ塼ΰƬ */
} DTQINIB;

/*
 *  ǡ塼֥å
 */
typedef struct dataqueue_control_block {
	QUEUE	swait_queue;	/* ǡ塼Ԥ塼 */
	const DTQINIB *dtqinib;	/* ǡ塼֥åؤΥݥ */
	QUEUE	rwait_queue;	/* ǡ塼Ԥ塼 */
	UINT	count;		/* ǡ塼Υǡο */
	UINT	head;		/* ǽΥǡγǼ */
	UINT	tail;		/* ǸΥǡγǼμ */
} DTQCB;

/*
 *  ǡ塼ǽν
 */
extern void	dataqueue_initialize(void);

/*
 *  ǡ塼ΰ˥ǡǼ
 */
extern BOOL	enqueue_data(DTQCB *dtqcb, VP_INT data);

/*
 *  ǡ塼ΰ˥ǡǼ
 */
extern void	force_enqueue_data(DTQCB *dtqcb, VP_INT data);

/*
 *  ǡ塼ΰ褫ǡФ
 */
extern BOOL	dequeue_data(DTQCB *dtqcb, VP_INT *p_data);

/*
 *  Ԥ塼ƬؤΥǡ
 */
extern TCB	*send_data_rwait(DTQCB *dtqcb, VP_INT data);

/*
 *  Ԥ塼ƬΥǡ
 */
extern TCB	*receive_data_swait(DTQCB *dtqcb, VP_INT *p_data);

#endif /* _DATAQUEUE_H_ */
